/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.completion.CompletionHandler;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;

public class GspCompleter
extends CompletionHandler {
    public CodeCompletionResult complete(CodeCompletionContext context) {
        ParserResult info = context.getParserResult();
        int caretOffset = context.getCaretOffset();
        Document doc = info.getSnapshot().getSource().getDocument(false);
        if (doc != null && GspCompleter.isWithinGroovy(doc, caretOffset)) {
            return super.complete(context);
        }
        return CodeCompletionResult.NONE;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        int caretOffset;
        Document doc = component.getDocument();
        if (GspCompleter.isWithinGroovy(doc, caretOffset = component.getCaret().getDot())) {
            return super.getAutoQuery(component, typedText);
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    static boolean isWithinGroovy(Document doc, int offset) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(offset);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            TokenId tokenID = tokenSequence.token().id();
            if (tokenID == GspTokenId.GROOVY || tokenID == GspTokenId.GROOVY_EXPR) {
                return true;
            }
            if (tokenID == GspTokenId.DELIMITER) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == GspTokenId.GROOVY || tokenSequence.token().id() == GspTokenId.GROOVY_EXPR) {
                    return true;
                }
            }
        }
        return false;
    }
}

