/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.MethodModelSupport;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.SessionMethodController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session.IconVisitor;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.ComponentMethodModel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.ComponentMethodViewStrategy;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.MethodsNode;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class MethodChildren
extends ComponentMethodModel {
    private ComponentMethodViewStrategy mvs;
    private final SessionMethodController controller;
    private final MethodsNode.ViewType viewType;

    public MethodChildren(ClasspathInfo cpInfo, SessionMethodController smc, Collection<String> interfaces, MethodsNode.ViewType viewType) {
        super(cpInfo, smc.getBeanClass(), interfaces, viewType == MethodsNode.ViewType.NO_INTERFACE ? null : (viewType == MethodsNode.ViewType.LOCAL ? smc.getLocalHome() : smc.getHome()));
        this.controller = smc;
        this.viewType = viewType;
        this.mvs = new SessionStrategy();
    }

    @Override
    protected Collection<String> getInterfaces() {
        List intfs = super.getInterfaces();
        return intfs != null ? intfs : Collections.EMPTY_LIST;
    }

    @Override
    public ComponentMethodViewStrategy createViewStrategy() {
        return this.mvs;
    }

    private class SessionStrategy
    implements ComponentMethodViewStrategy {
        private SessionStrategy() {
        }

        @Override
        public void deleteImplMethod(MethodModel me, String implClass, FileObject implClassFO, Collection interfaces) throws IOException {
            switch (MethodChildren.this.viewType) {
                case NO_INTERFACE: {
                    MethodChildren.this.controller.delete(me);
                    break;
                }
                case LOCAL: 
                case REMOTE: {
                    SessionMethodController sessionMethodController = MethodChildren.this.controller;
                    MethodsNode.ViewType viewType = MethodChildren.this.viewType;
                    MethodChildren.this.viewType;
                    sessionMethodController.delete(me, viewType == MethodsNode.ViewType.LOCAL);
                }
            }
        }

        @Override
        public Image getBadge(MethodModel me, Collection interfaces) {
            return null;
        }

        @Override
        public Image getIcon(MethodModel me, Collection interfaces) {
            IconVisitor iv = new IconVisitor();
            return ImageUtilities.loadImage((String)iv.getIconUrl(MethodChildren.this.controller.getMethodTypeFromInterface(me)));
        }

        @Override
        public void openMethod(final MethodModel me, final String implClass, FileObject implClassFO, Collection interfaces) {
            final ArrayList methodHandle = new ArrayList();
            try {
                JavaSource javaSource = JavaSource.forFileObject((FileObject)implClassFO);
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws IOException {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = controller.getElements().getTypeElement(implClass);
                        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                            if (!MethodModelSupport.isSameMethod((CompilationController)controller, (ExecutableElement)executableElement, (MethodModel)me)) continue;
                            methodHandle.add(ElementHandle.create((Element)executableElement));
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            if (methodHandle.size() > 0) {
                ElementOpen.open((FileObject)implClassFO, (ElementHandle)((ElementHandle)methodHandle.get(0)));
            }
        }
    }
}

