/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.methodcontroller;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodParams;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.dd.api.ejb.QueryMethod;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.AbstractMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EjbMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityGenerateFromImplVisitor;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityGenerateFromIntfVisitor;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.MethodType;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class EntityMethodController
extends AbstractMethodController {
    private static final int IDX_ABSTRACT_SCHEMA_NAME = 0;
    private static final int IDX_PERSISTENCE_TYPE = 1;
    private static final int IDX_LOCAL_HOME = 2;
    private static final int IDX_HOME = 3;
    private final MetadataModel<EjbJarMetadata> metadataModel;
    private final String ejbClass;
    private final Set<Modifier> modifiersPublicAbstract = new HashSet<Modifier>(2);
    private final String abstractSchemaName;
    private final String persistenceType;
    private final String localHome;
    private final String home;

    public EntityMethodController(final String ejbClass, MetadataModel<EjbJarMetadata> metadataModel) {
        super(ejbClass, metadataModel);
        this.metadataModel = metadataModel;
        this.modifiersPublicAbstract.add(Modifier.PUBLIC);
        this.modifiersPublicAbstract.add(Modifier.ABSTRACT);
        final String[] results = new String[4];
        this.ejbClass = ejbClass;
        try {
            metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

                public FileObject run(EjbJarMetadata metadata) {
                    Entity entity = (Entity)metadata.findByEjbClass(ejbClass);
                    if (entity != null) {
                        results[0] = entity.getAbstractSchemaName();
                        results[1] = entity.getPersistenceType();
                        results[2] = entity.getLocalHome();
                        results[3] = entity.getHome();
                    }
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        this.abstractSchemaName = results[0];
        this.persistenceType = results[1];
        this.localHome = results[2];
        this.home = results[3];
    }

    public List getMethods(CmpField field) {
        return this.getMethods(field.getFieldName());
    }

    public List getMethods(CmrField field) {
        return this.getMethods(field.getCmrFieldName());
    }

    public void deleteQueryMapping(MethodModel method, FileObject ddFileObject) throws IOException {
    }

    public void deleteField(CmpField field, FileObject ddFileObject) throws IOException {
    }

    private void removeMethodsFromBean(List<MethodModel> methods) throws IOException {
        for (MethodModel method : methods) {
            EjbMethodController.ClassMethodPair classMethodPair;
            if (this.hasLocal() && (classMethodPair = this.getInterface(method, true)) != null) {
                this.removeMethodFromClass(classMethodPair.getClassName(), classMethodPair.getMethodModel());
            }
            if (this.hasRemote() && (classMethodPair = this.getInterface(method, false)) != null) {
                this.removeMethodFromClass(classMethodPair.getClassName(), classMethodPair.getMethodModel());
            }
            this.removeMethodFromClass(this.getBeanClass(), method);
        }
    }

    public void deleteField(CmrField field, FileObject ddFileObject) throws IOException {
    }

    public static String getMethodName(String fieldName, boolean get) {
        String prefix = get ? "get" : "set";
        return EntityMethodController.prependAndUpper(fieldName, prefix);
    }

    @Override
    public boolean hasJavaImplementation(MethodModel intfView) {
        return this.hasJavaImplementation(this.getMethodTypeFromInterface(intfView));
    }

    @Override
    public boolean hasJavaImplementation(MethodType methodType) {
        return !this.isCMP() || !this.isFinder(methodType.getKind()) && !this.isSelect(methodType.getKind());
    }

    @Override
    public MethodType getMethodTypeFromImpl(MethodModel implView) {
        MethodType methodType = null;
        if (implView.getName().startsWith("ejbCreate") || implView.getName().startsWith("ejbPostCreate")) {
            methodType = new MethodType.CreateMethodType(implView);
        } else if (!implView.getName().startsWith("ejb")) {
            methodType = new MethodType.BusinessMethodType(implView);
        } else if (implView.getName().startsWith("ejbSelect")) {
            methodType = new MethodType.SelectMethodType(implView);
        } else if (implView.getName().startsWith("ejbHome")) {
            methodType = new MethodType.HomeMethodType(implView);
        }
        return methodType;
    }

    @Override
    public MethodType getMethodTypeFromInterface(MethodModel clientView) {
        MethodType methodType = this.findInClass(this.localHome, clientView) || this.findInClass(this.home, clientView) ? (clientView.getName().startsWith("create") ? new MethodType.CreateMethodType(clientView) : (clientView.getName().startsWith("find") ? new MethodType.FinderMethodType(clientView) : new MethodType.HomeMethodType(clientView))) : new MethodType.BusinessMethodType(clientView);
        return methodType;
    }

    @Override
    public AbstractMethodController.GenerateFromImpl createGenerateFromImpl() {
        return new EntityGenerateFromImplVisitor();
    }

    @Override
    public AbstractMethodController.GenerateFromIntf createGenerateFromIntf() {
        try {
            return new EntityGenerateFromIntfVisitor(this.ejbClass, this.metadataModel);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return null;
        }
    }

    public void addSelectMethod(MethodModel selectMethod, String ejbql, FileObject ddFileObject) throws IOException {
        this.addMethodToClass(this.getBeanClass(), selectMethod);
        this.addEjbQl(selectMethod, ejbql, ddFileObject);
    }

    @Override
    public void addEjbQl(MethodModel clientView, String ejbql, FileObject ddFileObject) throws IOException {
        Entity model;
        if (this.isBMP()) {
            super.addEjbQl(clientView, ejbql, ddFileObject);
        }
        if ((model = (Entity)this.metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Entity>(){

            public Entity run(EjbJarMetadata metadata) {
                return (Entity)metadata.findByEjbClass(EntityMethodController.this.ejbClass);
            }
        })) != null) {
            model.addQuery(this.buildQuery(model, clientView, ejbql));
        }
        DDProvider.getDefault().getDDRoot(ddFileObject).write(ddFileObject);
    }

    private MethodModel addSetterMethod(String javaClass, MethodModel.Variable field, Set<Modifier> modifiers, boolean remote, Entity entity) {
        MethodModel method = this.createSetterMethod(javaClass, field, modifiers, remote);
        this.addMethod(javaClass, method, entity);
        return method;
    }

    private MethodModel addGetterMethod(String javaClass, MethodModel.Variable variable, Set<Modifier> modifiers, boolean remote, Entity entity) {
        MethodModel method = this.createGetterMethod(javaClass, variable, modifiers, remote);
        this.addMethod(javaClass, method, entity);
        return method;
    }

    private void addMethod(String javaClass, MethodModel method, Entity entity) {
        try {
            this.addMethodToClass(javaClass, method);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private MethodModel createGetterMethod(String javaClass, MethodModel.Variable field, Set<Modifier> modifiers, boolean remote) {
        String fieldName = field.getName();
        List exceptions = remote ? Collections.singletonList(RemoteException.class.getName()) : Collections.emptyList();
        MethodModel method = MethodModel.create((String)EntityMethodController.getMethodName(fieldName, true), (String)"void", (String)"", Collections.singletonList(field), exceptions, modifiers);
        return method;
    }

    private MethodModel createSetterMethod(String javaClass, MethodModel.Variable field, Set<Modifier> modifiers, boolean remote) {
        String fieldName = field.getName();
        List exceptions = remote ? Collections.singletonList(RemoteException.class.getName()) : Collections.emptyList();
        MethodModel method = MethodModel.create((String)EntityMethodController.getMethodName(fieldName, false), (String)"void", (String)"", Collections.singletonList(field), exceptions, modifiers);
        return method;
    }

    private boolean isBMP() {
        return "Bean".equals(this.persistenceType);
    }

    public boolean isCMP() {
        return !this.isBMP();
    }

    private boolean isFinder(MethodType.Kind methodType) {
        return methodType == MethodType.Kind.FINDER;
    }

    private boolean isSelect(MethodType.Kind methodType) {
        return methodType == MethodType.Kind.SELECT;
    }

    @Override
    public String createDefaultQL(MethodModel methodModel) {
        String ejbql = null;
        if (methodModel.getName().startsWith("find") && this.isCMP()) {
            ejbql = "SELECT OBJECT(o) \nFROM " + this.abstractSchemaName + " o";
        } else if (methodModel.getName().startsWith("ejbSelect")) {
            ejbql = "SELECT COUNT(o) \nFROM " + this.abstractSchemaName + " o";
        }
        return ejbql;
    }

    private Query buildQuery(Entity model, MethodModel clientView, String ejbql) {
        Query query = model.newQuery();
        QueryMethod queryMethod = query.newQueryMethod();
        queryMethod.setMethodName(clientView.getName());
        MethodParams mParams = queryMethod.newMethodParams();
        for (MethodModel.Variable parameter : clientView.getParameters()) {
            mParams.addMethodParam(parameter.getType());
        }
        queryMethod.setMethodParams(mParams);
        query.setQueryMethod(queryMethod);
        query.setEjbQl(ejbql);
        return query;
    }

    private static String prependAndUpper(String fullName, String prefix) {
        StringBuffer buffer = new StringBuffer(fullName);
        buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
        return prefix + buffer.toString();
    }

    private boolean isEjbUsed(EjbRelationshipRole role, String ejbName, String fieldName) {
        return role != null && role.getRelationshipRoleSource() != null && ejbName.equals(role.getRelationshipRoleSource().getEjbName()) && fieldName.equals(role.getCmrField().getCmrFieldName());
    }

    private boolean relationContainsField(EjbRelation relation, String ejbName, String fieldName) {
        return this.isEjbUsed(relation.getEjbRelationshipRole(), ejbName, fieldName) || this.isEjbUsed(relation.getEjbRelationshipRole2(), ejbName, fieldName);
    }

    private void deleteRelationships(String fieldName) {
    }

    private List<MethodModel> getMethods(String propName) {
        assert (propName != null);
        LinkedList<MethodModel> resultList = new LinkedList<MethodModel>();
        String ejbClass = this.getBeanClass();
        MethodModel getMethod = this.getGetterMethod(ejbClass, propName);
        if (getMethod != null) {
            resultList.add(getMethod);
            MethodModel setMethod = this.getSetterMethod(ejbClass, propName, getMethod.getReturnType());
            if (setMethod != null) {
                resultList.add(setMethod);
            }
        }
        return resultList;
    }

    public MethodModel getGetterMethod(String javaClass, String fieldName) {
        if (javaClass == null || fieldName == null) {
            return null;
        }
        MethodModel method = MethodModel.create((String)EntityMethodController.getMethodName(fieldName, true), (String)"void", (String)"", Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
        return this.findInClass(javaClass, method) ? method : null;
    }

    public MethodModel getGetterMethod(String fieldName, boolean local) {
        return this.getGetterMethod(this.getBeanInterface(local, true), fieldName);
    }

    public MethodModel getSetterMethod(String classElement, String fieldName, String type) {
        if (classElement == null) {
            return null;
        }
        if (type == null) {
            return null;
        }
        MethodModel method = MethodModel.create((String)EntityMethodController.getMethodName(fieldName, true), (String)"void", (String)"", Collections.singletonList(MethodModel.Variable.create((String)type, (String)"arg0")), Collections.emptyList(), Collections.emptySet());
        return this.findInClass(classElement, method) ? method : null;
    }

    public MethodModel getSetterMethod(String fieldName, boolean local) {
        MethodModel.Variable field = this.getField(fieldName, true);
        if (field == null) {
            return null;
        }
        return this.getSetterMethod(this.getBeanInterface(local, true), fieldName, field.getType());
    }

    public MethodModel getFinderMethod(String classElement, String fieldName, MethodModel getterMethod) {
        if (getterMethod == null) {
            return null;
        }
        MethodModel method = MethodModel.create((String)EntityMethodController.getMethodName(fieldName, true), (String)"void", (String)"", Collections.singletonList(MethodModel.Variable.create((String)getterMethod.getReturnType(), (String)"arg0")), Collections.emptyList(), Collections.emptySet());
        return this.findInClass(classElement, method) ? method : null;
    }

    @Override
    public boolean supportsMethodType(MethodType.Kind methodType) {
        return !this.isSelect(methodType) || this.isCMP();
    }

    private void updateFieldAccessors(String fieldName, boolean localGetter, boolean localSetter, boolean remoteGetter, boolean remoteSetter) {
        this.updateFieldAccessor(fieldName, true, true, localGetter);
        this.updateFieldAccessor(fieldName, false, true, localSetter);
        this.updateFieldAccessor(fieldName, true, false, remoteGetter);
        this.updateFieldAccessor(fieldName, false, false, remoteSetter);
    }

    public void updateFieldAccessor(String fieldName, boolean getter, boolean local, boolean shouldExist) {
    }

    private MethodModel.Variable getField(String fieldName, boolean create) {
        String beanClass = this.getBeanClass();
        MethodModel getterMethod = this.getGetterMethod(beanClass, fieldName);
        if (getterMethod == null) {
            if (!create) {
                return null;
            }
            MethodModel.Variable field = MethodModel.Variable.create((String)String.class.getName(), (String)fieldName);
            this.createGetterMethod(this.getBeanClass(), field, this.modifiersPublicAbstract, false);
            return field;
        }
        String type = getterMethod.getReturnType();
        if (type == null) {
            return null;
        }
        return MethodModel.Variable.create((String)type, (String)fieldName);
    }
}

