/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.core.WindowSystem;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.TopComponentGroupImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;

public class ResetWindowsAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        final WindowSystem ws = (WindowSystem)Lookup.getDefault().lookup(WindowSystem.class);
        if (null == ws) {
            Logger.getLogger(ResetWindowsAction.class.getName()).log(Level.INFO, "Reset Windows action does not support custom WindowSystem implementations.");
            return;
        }
        final WindowManagerImpl wm = WindowManagerImpl.getInstance();
        MainWindow.getInstance().setFullScreenMode(false);
        wm.getMainWindow().setExtendedState(0);
        TopComponentGroupImpl projectTCGroup = (TopComponentGroupImpl)wm.findTopComponentGroup("OpenedProjects");
        final boolean isProjectsTCGroupOpened = null != projectTCGroup && projectTCGroup.isOpened();
        final TopComponent[] editors = wm.getEditorTopComponents();
        wm.closeNonEditorViews();
        wm.getMainWindow().setVisible(false);
        final TopComponent activeEditor = wm.getArbitrarySelectedEditorTopComponent();
        wm.deselectEditorTopComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponentGroup tcGroup;
                FileObject rootFolder = FileUtil.getConfigFile((String)"Windows2Local");
                if (null != rootFolder) {
                    try {
                        for (FileObject fo : rootFolder.getChildren()) {
                            if ("Components".equals(fo.getName())) continue;
                            fo.delete();
                        }
                    }
                    catch (IOException ioE) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioE);
                    }
                }
                ws.hide();
                WindowManagerImpl.getInstance().resetModel();
                PersistenceManager.getDefault().reset();
                PersistenceHandler.getDefault().clear();
                ws.load();
                ws.show();
                if (isProjectsTCGroupOpened && null != (tcGroup = wm.findTopComponentGroup("OpenedProjects"))) {
                    tcGroup.open();
                }
                ModeImpl editorMode = (ModeImpl)wm.findMode("editor");
                for (int i = 0; i < editors.length; ++i) {
                    editorMode.addOpenedTopComponentNoNotify(editors[i]);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Frame mainWindow = wm.getMainWindow();
                        mainWindow.invalidate();
                        mainWindow.repaint();
                    }
                });
                if (null != activeEditor) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            activeEditor.requestActive();
                        }
                    });
                }
            }
        });
    }
}

