/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;
import org.h2.command.CommandInterface;
import org.h2.command.CommandRemote;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Constants;
import org.h2.engine.SessionInterface;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.NetUtils;
import org.h2.util.ObjectArray;
import org.h2.util.RandomUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;
import org.h2.value.Transfer;
import org.h2.value.Value;
import org.h2.value.ValueString;

public class SessionRemote
implements SessionInterface,
DataHandler {
    public static final int SESSION_PREPARE = 0;
    public static final int SESSION_CLOSE = 1;
    public static final int COMMAND_EXECUTE_QUERY = 2;
    public static final int COMMAND_EXECUTE_UPDATE = 3;
    public static final int COMMAND_CLOSE = 4;
    public static final int RESULT_FETCH_ROWS = 5;
    public static final int RESULT_RESET = 6;
    public static final int RESULT_CLOSE = 7;
    public static final int COMMAND_COMMIT = 8;
    public static final int CHANGE_ID = 9;
    public static final int COMMAND_GET_META_DATA = 10;
    public static final int SESSION_PREPARE_READ_PARAMS = 11;
    public static final int SESSION_SET_ID = 12;
    public static final int SESSION_CANCEL_STATEMENT = 13;
    public static final int STATUS_ERROR = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_CLOSED = 2;
    private TraceSystem traceSystem;
    private Trace trace;
    private ObjectArray transferList;
    private int nextId;
    private boolean autoCommit = true;
    private CommandInterface switchOffAutoCommit;
    private ConnectionInfo connectionInfo;
    private int objectId;
    private String databaseName;
    private String cipher;
    private byte[] fileEncryptionKey;
    private Object lobSyncObject = new Object();
    private String sessionId;
    private int clientVersion = 5;

    public SessionRemote() {
    }

    private SessionRemote(ConnectionInfo connectionInfo) throws SQLException {
        this.connectionInfo = connectionInfo;
        this.connect();
    }

    private Transfer initTransfer(ConnectionInfo connectionInfo, String string, String string2) throws IOException, SQLException {
        Socket socket = NetUtils.createSocket(string2, 9092, connectionInfo.isSSL());
        Transfer transfer = new Transfer(this);
        transfer.setSocket(socket);
        transfer.setSSL(connectionInfo.isSSL());
        transfer.init();
        transfer.writeInt(this.clientVersion);
        transfer.writeString(string);
        transfer.writeString(connectionInfo.getOriginalURL());
        transfer.writeString(connectionInfo.getUserName());
        transfer.writeBytes(connectionInfo.getUserPasswordHash());
        transfer.writeBytes(connectionInfo.getFilePasswordHash());
        String[] stringArray = connectionInfo.getKeys();
        transfer.writeInt(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            transfer.writeString(string3).writeString(connectionInfo.getProperty(string3));
        }
        try {
            this.done(transfer);
        }
        catch (SQLException sQLException) {
            transfer.close();
            throw sQLException;
        }
        this.autoCommit = true;
        return transfer;
    }

    public void cancel() {
    }

    public void cancelStatement(int n) {
        if (this.clientVersion <= 5) {
            return;
        }
        for (int i = 0; i < this.transferList.size(); ++i) {
            Transfer transfer = (Transfer)this.transferList.get(i);
            try {
                Transfer transfer2 = transfer.openNewConnection();
                transfer2.init();
                transfer2.writeInt(this.clientVersion);
                if (this.clientVersion >= 6) {
                    transfer2.writeInt(this.clientVersion);
                }
                transfer2.writeString(null);
                transfer2.writeString(null);
                transfer2.writeString(this.sessionId);
                transfer2.writeInt(13);
                transfer2.writeInt(n);
                transfer2.close();
                continue;
            }
            catch (IOException iOException) {
                this.trace.debug("Could not cancel statement", iOException);
            }
        }
    }

    private void switchOffAutoCommitIfCluster() throws SQLException {
        if (this.autoCommit && this.transferList.size() > 1) {
            if (this.switchOffAutoCommit == null) {
                this.switchOffAutoCommit = this.prepareCommand("SET AUTOCOMMIT FALSE", Integer.MAX_VALUE);
            }
            this.switchOffAutoCommit.executeUpdate();
            this.autoCommit = true;
        }
    }

    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    public void autoCommitIfCluster() throws SQLException {
        if (this.autoCommit && this.transferList != null && this.transferList.size() > 1) {
            for (int i = 0; i < this.transferList.size(); ++i) {
                Transfer transfer = (Transfer)this.transferList.get(i);
                try {
                    this.traceOperation("COMMAND_COMMIT", 0);
                    transfer.writeInt(8);
                    this.done(transfer);
                    continue;
                }
                catch (IOException iOException) {
                    this.removeServer(i--);
                }
            }
        }
    }

    private String getFilePrefix(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        for (int i = 0; i < this.databaseName.length(); ++i) {
            char c = this.databaseName.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    public int getPowerOffCount() {
        return 0;
    }

    public void setPowerOffCount(int n) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public SessionInterface createSession(ConnectionInfo connectionInfo) throws SQLException {
        return new SessionRemote(connectionInfo);
    }

    private void connect() throws SQLException {
        String[] stringArray;
        String string;
        int n;
        ConnectionInfo connectionInfo = this.connectionInfo;
        String string2 = connectionInfo.getName();
        if (string2.startsWith("//")) {
            string2 = string2.substring("//".length());
        }
        if ((n = string2.indexOf(47)) < 0) {
            throw connectionInfo.getFormatException();
        }
        this.databaseName = string2.substring(n + 1);
        String string3 = string2.substring(0, n);
        this.traceSystem = new TraceSystem(null, false);
        try {
            string = connectionInfo.getProperty(10, null);
            if (string != null) {
                int n2 = Integer.parseInt(string);
                String string4 = this.getFilePrefix(SysProperties.CLIENT_TRACE_DIRECTORY);
                String string5 = FileUtils.createTempFile(string4, ".trace.db", false, false);
                this.traceSystem.setFileName(string5);
                this.traceSystem.setLevelFile(n2);
            }
            if ((stringArray = connectionInfo.getProperty(9, null)) != null) {
                int n3 = Integer.parseInt((String)stringArray);
                this.traceSystem.setLevelSystemOut(n3);
            }
        }
        catch (Exception exception) {
            throw Message.convert(exception);
        }
        this.trace = this.traceSystem.getTrace("jdbc");
        this.transferList = new ObjectArray();
        string = null;
        if (string3.indexOf(44) >= 0) {
            string = StringUtils.quoteStringSQL(string3);
            connectionInfo.setProperty("CLUSTER", string);
        }
        this.cipher = connectionInfo.getProperty("CIPHER");
        if (this.cipher != null) {
            this.fileEncryptionKey = RandomUtils.getSecureBytes(32);
        }
        stringArray = StringUtils.arraySplit(string3, ',', true);
        int n4 = stringArray.length;
        this.transferList = new ObjectArray();
        boolean bl = false;
        try {
            for (int i = 0; i < n4; ++i) {
                try {
                    Transfer transfer = this.initTransfer(connectionInfo, this.databaseName, stringArray[i]);
                    this.transferList.add(transfer);
                    continue;
                }
                catch (IOException iOException) {
                    bl = true;
                }
            }
            this.checkClosed();
            if (bl) {
                this.switchOffCluster();
            }
            this.switchOffAutoCommitIfCluster();
        }
        catch (SQLException sQLException) {
            this.traceSystem.close();
            throw sQLException;
        }
        this.upgradeClientVersionIfPossible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeClientVersionIfPossible() {
        Object object;
        Object object2;
        try {
            Value[] valueArray;
            String string;
            object2 = this.prepareCommand("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?", 1);
            ParameterInterface parameterInterface = (ParameterInterface)object2.getParameters().get(0);
            parameterInterface.setValue(ValueString.get("info.BUILD_ID"), false);
            object = object2.executeQuery(1, false);
            if (object.next() && (string = (valueArray = object.currentRow())[0].getString()).compareTo("71") > 0) {
                this.clientVersion = 6;
            }
            object.close();
        }
        catch (Exception exception) {
            this.trace.error("Error trying to upgrade client version", exception);
        }
        if (this.clientVersion >= 6) {
            this.sessionId = ByteUtils.convertBytesToString(RandomUtils.getSecureBytes(32));
            object2 = this;
            synchronized (object2) {
                for (int i = 0; i < this.transferList.size(); ++i) {
                    object = (Transfer)this.transferList.get(i);
                    try {
                        this.traceOperation("SESSION_SET_ID", 0);
                        ((Transfer)object).writeInt(12);
                        ((Transfer)object).writeString(this.sessionId);
                        this.done((Transfer)object);
                        continue;
                    }
                    catch (Exception exception) {
                        this.trace.error("sessionSetId", exception);
                    }
                }
            }
        }
    }

    private void switchOffCluster() throws SQLException {
        CommandInterface commandInterface = this.prepareCommand("SET CLUSTER ''", Integer.MAX_VALUE);
        commandInterface.executeUpdate();
    }

    public void removeServer(int n) throws SQLException {
        this.transferList.remove(n);
        this.checkClosed();
        this.switchOffCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandInterface prepareCommand(String string, int n) throws SQLException {
        SessionRemote sessionRemote = this;
        synchronized (sessionRemote) {
            this.checkClosed();
            return new CommandRemote(this, this.transferList, string, n);
        }
    }

    public void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw Message.getSQLException(90067);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.transferList != null) {
            SessionRemote sessionRemote = this;
            synchronized (sessionRemote) {
                for (int i = 0; i < this.transferList.size(); ++i) {
                    Transfer transfer = (Transfer)this.transferList.get(i);
                    try {
                        this.traceOperation("SESSION_CLOSE", 0);
                        transfer.writeInt(1);
                        this.done(transfer);
                        transfer.close();
                        continue;
                    }
                    catch (Exception exception) {
                        this.trace.error("close", exception);
                    }
                }
            }
            this.transferList = null;
        }
        this.traceSystem.close();
    }

    public Trace getTrace() {
        return this.traceSystem.getTrace("jdbc");
    }

    public int getNextId() {
        return this.nextId++;
    }

    public int getCurrentId() {
        return this.nextId;
    }

    public void done(Transfer transfer) throws SQLException, IOException {
        transfer.flush();
        int n = transfer.readInt();
        if (n == 0) {
            String string = transfer.readString();
            String string2 = transfer.readString();
            String string3 = transfer.readString();
            int n2 = transfer.readInt();
            String string4 = transfer.readString();
            throw new JdbcSQLException(string2, string3, string, n2, null, string4);
        }
        if (n == 2) {
            this.transferList = null;
        }
    }

    public boolean isClustered() {
        return this.transferList.size() > 1;
    }

    public boolean isClosed() {
        return this.transferList == null || this.transferList.size() == 0;
    }

    public void traceOperation(String string, int n) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug(string + " " + n);
        }
    }

    public int allocateObjectId(boolean bl, boolean bl2) {
        return this.objectId++;
    }

    public void checkPowerOff() {
    }

    public void checkWritingAllowed() {
    }

    public int compareTypeSave(Value value, Value value2) {
        throw Message.getInternalError();
    }

    public String createTempFile() throws SQLException {
        try {
            String string = this.getFilePrefix(System.getProperty("java.io.tmpdir"));
            return FileUtils.createTempFile(string, ".temp.db", true, false);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, this.databaseName);
        }
    }

    public void freeUpDiskSpace() {
    }

    public int getChecksum(byte[] byArray, int n, int n2) {
        return 0;
    }

    public String getDatabasePath() {
        return "";
    }

    public String getLobCompressionAlgorithm(int n) {
        return null;
    }

    public int getMaxLengthInplaceLob() {
        return 65536;
    }

    public boolean getTextStorage() {
        return false;
    }

    public void handleInvalidChecksum() throws SQLException {
        throw Message.getSQLException(90030, "wrong checksum");
    }

    public FileStore openFile(String string, String string2, boolean bl) throws SQLException {
        if (bl && !FileUtils.exists(string)) {
            throw Message.getSQLException(90030, string);
        }
        byte[] byArray = Constants.MAGIC_FILE_HEADER.getBytes();
        FileStore fileStore = this.cipher == null ? FileStore.open(this, string, string2, byArray) : FileStore.open(this, string, string2, byArray, this.cipher, this.fileEncryptionKey, 0);
        fileStore.setCheckedWriting(false);
        try {
            fileStore.init();
        }
        catch (SQLException sQLException) {
            fileStore.closeSilently();
            throw sQLException;
        }
        return fileStore;
    }

    public DataHandler getDataHandler() {
        return this;
    }

    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }

    public boolean getLobFilesInDirectories() {
        return false;
    }

    public SmallLRUCache getLobFileListCache() {
        return null;
    }

    public int getClientVersion() {
        return this.clientVersion;
    }
}

