/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.refactoring;

import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstMethodSuffix;
import com.sun.el.parser.AstPropertySuffix;
import com.sun.el.parser.Node;
import com.sun.el.parser.NodeVisitor;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELIndex;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.ELVariableResolvers;
import org.netbeans.modules.web.el.refactoring.ELRefactoringPlugin;
import org.netbeans.modules.web.el.refactoring.RefactoringUtil;
import org.netbeans.modules.web.el.refactoring.WhereUsedQueryElement;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class ELWhereUsedQuery
extends ELRefactoringPlugin {
    private static final Logger LOGGER = Logger.getLogger(ELWhereUsedQuery.class.getName());
    protected CompilationInfo info;
    protected ELTypeUtilities typeUtilities;

    ELWhereUsedQuery(AbstractRefactoring whereUsedQuery) {
        super(whereUsedQuery);
    }

    @Override
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        TreePathHandle handle = this.getHandle();
        if (handle == null) {
            return null;
        }
        this.info = RefactoringUtil.getCompilationInfo(handle, this.refactoring);
        this.typeUtilities = ELTypeUtilities.create(this.info.getFileObject(), (ClasspathInfo)this.refactoring.getContext().lookup(ClasspathInfo.class));
        Element element = this.resolveElement(handle);
        if (element == null) {
            LOGGER.log(Level.INFO, "Could not resolve Element for TPH: {0}", handle);
            return null;
        }
        if ((Tree.Kind.METHOD == handle.getKind() || Tree.Kind.MEMBER_SELECT == handle.getKind()) && element instanceof ExecutableElement) {
            return this.handleProperty(refactoringElementsBag, handle, (ExecutableElement)element);
        }
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)handle.getKind())) {
            return this.handleClass(refactoringElementsBag, handle, element);
        }
        return null;
    }

    private Element resolveElement(final TreePathHandle handle) {
        ClasspathInfo cpInfo = (ClasspathInfo)this.refactoring.getContext().lookup(ClasspathInfo.class);
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{handle.getFileObject()});
        final Element[] result = new Element[1];
        try {
            source.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    result[0] = handle.resolveElement((CompilationInfo)cc);
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result[0];
    }

    protected Problem handleClass(RefactoringElementsBag refactoringElementsBag, TreePathHandle handle, Element targetType) {
        TypeElement type = (TypeElement)targetType;
        String clazz = type.getQualifiedName().toString();
        String beanName = ELVariableResolvers.findBeanName(clazz, this.getFileObject());
        if (beanName != null) {
            ELIndex index = ELIndex.get(handle.getFileObject());
            Collection<? extends IndexResult> result = index.findIdentifierReferences(beanName);
            for (ELElement elem : this.getMatchingElements(result)) {
                this.addElements(elem, this.findMatchingIdentifierNodes(elem.getNode(), beanName), refactoringElementsBag);
            }
        }
        return null;
    }

    protected Problem handleProperty(RefactoringElementsBag refactoringElementsBag, TreePathHandle handle, ExecutableElement targetType) {
        String propertyName = RefactoringUtil.getPropertyName(targetType.getSimpleName().toString());
        ELIndex index = ELIndex.get(handle.getFileObject());
        HashSet<Object> result = new HashSet<Object>();
        if (targetType.getParameters().isEmpty() || targetType.getParameters().size() == 1 && targetType.isVarArgs()) {
            result.addAll(index.findPropertyReferences(propertyName));
        }
        result.addAll(index.findMethodReferences(propertyName));
        for (ELElement each : this.getMatchingElements(result)) {
            List<Node> matchingNodes = this.findMatchingPropertyNodes(each.getNode(), targetType, each.getSnapshot().getSource().getFileObject());
            this.addElements(each, matchingNodes, refactoringElementsBag);
            this.handleVariableReferences(each, targetType, refactoringElementsBag);
        }
        return null;
    }

    private void handleVariableReferences(ELElement elElement, Element targetType, RefactoringElementsBag refactoringElementsBag) {
    }

    private Collection<? extends ELVariableResolver> getResolvers() {
        return Lookup.getDefault().lookupAll(ELVariableResolver.class);
    }

    protected void addElements(ELElement elem, List<Node> matchingNodes, RefactoringElementsBag refactoringElementsBag) {
        for (Node property : matchingNodes) {
            WhereUsedQueryElement wuqe = new WhereUsedQueryElement(elem.getSnapshot().getSource().getFileObject(), property.getImage(), elem, property, ELWhereUsedQuery.getParserResult(elem.getSnapshot().getSource().getFileObject()));
            refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)wuqe);
        }
    }

    private List<Node> findMatchingPropertyNodes(Node root, final ExecutableElement targetMethod, final FileObject context) {
        final ArrayList<Node> result = new ArrayList<Node>();
        final TypeMirror targetType = targetMethod.getEnclosingElement().asType();
        root.accept(new NodeVisitor(){

            public void visit(Node node) throws ELException {
                if (node instanceof AstIdentifier) {
                    Node parent = node.jjtGetParent();
                    String beanClass = ELVariableResolvers.findBeanClass(node.getImage(), context);
                    if (beanClass == null) {
                        return;
                    }
                    TypeElement fmbType = ELWhereUsedQuery.this.info.getElements().getTypeElement(beanClass);
                    TypeMirror enclosing = fmbType.asType();
                    for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
                        Node child = parent.jjtGetChild(i);
                        if (!(child instanceof AstPropertySuffix) && !(child instanceof AstMethodSuffix)) continue;
                        if (enclosing == null) break;
                        if (ELWhereUsedQuery.this.info.getTypes().isSameType(targetType, enclosing) && ELWhereUsedQuery.this.typeUtilities.isSameMethod(child, targetMethod)) {
                            TypeMirror matching = ELWhereUsedQuery.this.getTypeForProperty(child, enclosing);
                            if (matching == null) continue;
                            result.add(child);
                            continue;
                        }
                        enclosing = ELWhereUsedQuery.this.getTypeForProperty(child, enclosing);
                    }
                }
            }
        });
        return result;
    }

    private boolean refersToType(Node root, final TypeMirror targetType, final FileObject context) {
        final boolean[] result = new boolean[1];
        root.accept(new NodeVisitor(){

            public void visit(Node node) throws ELException {
                if (node instanceof AstIdentifier) {
                    Node parent = node.jjtGetParent();
                    String beanClass = ELVariableResolvers.findBeanClass(node.getImage(), context);
                    if (beanClass == null) {
                        return;
                    }
                    TypeElement fmbType = ELWhereUsedQuery.this.info.getElements().getTypeElement(beanClass);
                    TypeMirror enclosing = fmbType.asType();
                    Node current = parent;
                    for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
                        current = parent.jjtGetChild(i);
                        if (!(current instanceof AstPropertySuffix) && !(current instanceof AstMethodSuffix)) continue;
                        enclosing = ELWhereUsedQuery.this.getTypeForProperty(current, enclosing);
                    }
                    if (enclosing instanceof DeclaredType) {
                        List<? extends TypeMirror> typeArguments = ((DeclaredType)enclosing).getTypeArguments();
                        for (TypeMirror typeMirror : typeArguments) {
                            if (!ELWhereUsedQuery.this.info.getTypes().isSubtype(typeMirror, targetType)) continue;
                            result[0] = true;
                            return;
                        }
                    }
                }
            }
        });
        return result[0];
    }

    private List<Node> findMatchingIdentifierNodes(Node root, final String identifierName) {
        final ArrayList<Node> result = new ArrayList<Node>();
        root.accept(new NodeVisitor(){

            public void visit(Node node) throws ELException {
                if (node instanceof AstIdentifier && identifierName.equals(node.getImage())) {
                    result.add(node);
                }
            }
        });
        return result;
    }

    private TypeMirror getTypeForProperty(Node property, TypeMirror enclosing) {
        String name = property.getImage();
        List<? extends Element> enclosedElements = this.info.getTypes().asElement(enclosing).getEnclosedElements();
        for (ExecutableElement each : ElementFilter.methodsIn(enclosedElements)) {
            if (!each.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            ExecutableElement methodElem = each;
            String methodName = methodElem.getSimpleName().toString();
            if (this.typeUtilities.isSameMethod(property, methodElem)) {
                return this.typeUtilities.getReturnType(methodElem);
            }
            if (!RefactoringUtil.getPropertyName(methodName).equals(name) && !methodName.equals(name)) continue;
            return this.typeUtilities.getReturnType(methodElem);
        }
        return null;
    }

    private List<ELElement> getMatchingElements(Collection<? extends IndexResult> indexResult) {
        ArrayList<ELElement> result = new ArrayList<ELElement>();
        for (IndexResult indexResult2 : indexResult) {
            FileObject file = indexResult2.getFile();
            ELRefactoringPlugin.ParserResultHolder parserResultHolder = ELWhereUsedQuery.getParserResult(file);
            if (parserResultHolder.parserResult == null) continue;
            String expression = indexResult2.getValue("expression");
            for (ELElement element : parserResultHolder.parserResult.getElements()) {
                if (!expression.equals(element.getExpression()) || result.contains(element)) continue;
                result.add(element);
            }
        }
        return result;
    }
}

