/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import javax.tools.Diagnostic;

class CleaningAnnotationProcessorImpl
implements Runnable {
    private final ProcessingEnvironment processingEnv;
    private final RoundEnvironment roundEnv;
    private final Set<String> seenElements;
    private static final AtomicReference<Boolean> HAS_BUG = new AtomicReference();

    public CleaningAnnotationProcessorImpl(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, Set<String> seenElements) {
        this.processingEnv = processingEnv;
        this.roundEnv = roundEnv;
        this.seenElements = seenElements;
    }

    @Override
    public void run() {
        try {
            if (!this.shouldWorkaroundBug()) {
                return;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Attempting to workaround 6512707");
            final Trees t = Trees.instance(this.processingEnv);
            final LinkedList toClean = new LinkedList();
            for (Element element : this.roundEnv.getRootElements()) {
                if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
                this.seenElements.add(((TypeElement)element).getQualifiedName().toString());
            }
            for (String string : this.seenElements) {
                TypeElement resolved = this.processingEnv.getElementUtils().getTypeElement(string);
                if (resolved == null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Cannot clean " + string);
                    continue;
                }
                new ElementScanner6<Void, Void>(){

                    @Override
                    public Void visitExecutable(ExecutableElement e, Void p) {
                        MethodTree tree = t.getTree(e);
                        if (tree != null && tree.getKind() == Tree.Kind.METHOD) {
                            JCTree.JCMethodDecl jcTree = (JCTree.JCMethodDecl)tree;
                            toClean.add(jcTree.defaultValue);
                        }
                        return (Void)super.visitExecutable(e, p);
                    }
                }.scan(resolved, null);
            }
            Method cleanTrees = JavacProcessingEnvironment.class.getDeclaredMethod("cleanTrees", List.class);
            cleanTrees.setAccessible(true);
            cleanTrees.invoke(null, List.from(toClean.toArray(new JCTree[0])));
        }
        catch (Throwable t) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Failed with a Throwable: " + t.getMessage());
        }
    }

    private boolean shouldWorkaroundBug() {
        Boolean result = HAS_BUG.get();
        if (result != null) {
            return result;
        }
        Context ctx = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        TreeMaker make = TreeMaker.instance(ctx);
        final JCTree.JCLiteral val = make.Literal("");
        JCTree.JCMethodDecl method = make.MethodDef(null, null, null, List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), null, val);
        final boolean[] noBug = new boolean[]{false};
        new TreeScanner(){

            @Override
            public void scan(JCTree tree) {
                noBug[0] = noBug[0] | tree == val;
                super.scan(tree);
            }
        }.scan(method);
        HAS_BUG.compareAndSet(null, !noBug[0]);
        return HAS_BUG.get();
    }
}

