/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URIException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.ZipScanner;
import org.apache.tools.ant.util.LineTokenizer;
import org.apache.webdav.ant.Mimetypes;
import org.apache.webdav.ant.Utils;
import org.apache.webdav.ant.taskdefs.WebdavTask;

public class Put
extends WebdavTask {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private boolean lock = true;
    private String locktoken = null;
    private int lockTimeout = 3600;
    private String lockOwnerInfo = null;
    private List filesets = new ArrayList();
    private List zipfilesets = new ArrayList();
    private File file = null;
    private boolean overwrite = false;
    private FilterSetCollection filterSets = new FilterSetCollection();
    private String encoding = null;
    private int countWrittenFiles = 0;
    private int countOmittedFiles = 0;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public void setOverwrite(boolean value) {
        this.overwrite = value;
    }

    public void setLocktoken(String token) {
        this.locktoken = token;
        if (!this.locktoken.startsWith("opaquelocktoken:")) {
            throw new BuildException("Invalid locktoken: " + token);
        }
    }

    public FilterSet createFilterSet() {
        FilterSet filterSet = new FilterSet();
        this.filterSets.addFilterSet(filterSet);
        return filterSet;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setTimeout(int value) {
        if (value <= 0) {
            throw new BuildException("Invalid timeout value (Must be positive integer)");
        }
        this.lockTimeout = value;
    }

    public void setOwnerinfo(String value) {
        this.lockOwnerInfo = value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        boolean selfCreatedLock = false;
        this.validate();
        try {
            try {
                block15: {
                    int i;
                    block16: {
                        this.log("Uploading to: " + this.getUrl(), this.ifVerbose());
                        if (this.file == null) {
                            Utils.assureExistingCollection(this.getHttpClient(), this.getUrl(), this.locktoken);
                        }
                        if (this.lock && this.locktoken == null) {
                            this.log("Locking " + this.getUrl(), this.ifVerbose());
                            this.locktoken = Utils.lockResource(this.getHttpClient(), this.getUrl(), this.lockOwnerInfo, Integer.MAX_VALUE, this.lockTimeout);
                            this.log("locktoken: " + this.locktoken, 4);
                            selfCreatedLock = true;
                        }
                        if (this.file == null) break block16;
                        if (Utils.collectionExists(this.getHttpClient(), this.getUrl())) {
                            this.setUrl(Put.assureCollectionUrl(this.getUrl()));
                            this.uploadFile(this.file.getName(), this.file);
                            break block15;
                        } else if (this.getUrl().getURI().endsWith("/")) {
                            Utils.assureExistingCollection(this.getHttpClient(), this.getUrl(), this.locktoken);
                            this.uploadFile(this.file.getName(), this.file);
                            break block15;
                        } else {
                            HttpURL targetColl = Utils.createHttpURL(this.getUrl(), ".");
                            Utils.assureExistingCollection(this.getHttpClient(), targetColl, this.locktoken);
                            this.uploadFile(this.getUrl(), this.file, this.file.getName());
                        }
                        break block15;
                    }
                    for (i = 0; i < this.filesets.size(); ++i) {
                        FileSet fileSet = (FileSet)this.filesets.get(i);
                        this.uploadFileSet(fileSet);
                    }
                    for (i = 0; i < this.zipfilesets.size(); ++i) {
                        ZipFileSet zipFileSet = (ZipFileSet)((Object)this.zipfilesets.get(i));
                        this.uploadZipFileSet(zipFileSet);
                    }
                }
                this.log("Puted " + this.countWrittenFiles + (this.countWrittenFiles == 1 ? " file" : " files") + " to " + this.getUrl(), this.countWrittenFiles > 0 ? 2 : this.ifVerbose());
            }
            catch (IOException e) {
                throw Utils.makeBuildException("Put error!", e);
            }
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            try {
                if (this.locktoken == null) throw throwable;
                if (!selfCreatedLock) throw throwable;
                this.log("Unlocking " + this.getUrl(), this.ifVerbose());
                Utils.unlockResource(this.getHttpClient(), this.getUrl(), this.locktoken);
                throw throwable;
            }
            catch (IOException e) {
                throw Utils.makeBuildException("Can't unlock!", e);
            }
        }
        try {}
        catch (IOException e) {
            throw Utils.makeBuildException("Can't unlock!", e);
        }
        if (this.locktoken == null) return;
        if (!selfCreatedLock) return;
        this.log("Unlocking " + this.getUrl(), this.ifVerbose());
        Utils.unlockResource(this.getHttpClient(), this.getUrl(), this.locktoken);
    }

    protected void validate() {
        super.validate();
        if (this.encoding == null && this.filterSets.hasFilters()) {
            this.log("If filterSets are used a file encoding should be specified!", 1);
            this.encoding = "ISO-8859-1";
        }
        if (this.file != null && (this.filesets.size() > 0 || this.zipfilesets.size() > 0)) {
            throw new BuildException("No filesets allowed if file is set.");
        }
        if (!(this.file == null || this.file.isFile() && this.file.exists())) {
            throw new BuildException("File attribute must point to en existing file");
        }
        if (this.file == null) {
            try {
                this.setUrl(Put.assureCollectionUrl(this.getUrl()));
            }
            catch (URIException e) {
                throw new BuildException("Problem with URI: " + this.getUrl(), (Throwable)e);
            }
        }
        if (this.lockOwnerInfo == null) {
            this.lockOwnerInfo = "ant-webdav " + this.getUserid();
        }
    }

    private void uploadFileSet(FileSet fileSet) throws IOException {
        DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
        String basedir = scanner.getBasedir().getAbsolutePath();
        Iterator i = this.determineRequiredDirectories(scanner);
        while (i.hasNext()) {
            String dir = (String)i.next();
            if (dir.equals("")) {
                Utils.assureExistingCollection(this.getHttpClient(), this.getUrl(), this.locktoken);
                continue;
            }
            HttpURL collURL = Utils.createHttpURL(this.getUrl(), dir + "/");
            Utils.assureExistingCollection(this.getHttpClient(), collURL, this.locktoken);
        }
        String[] files = scanner.getIncludedFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = this.getProject().resolveFile(basedir + File.separator + files[i2]);
            this.uploadFile(this.asDavPath(files[i2]), file);
        }
    }

    private Iterator determineRequiredDirectories(DirectoryScanner scanner) {
        HashSet<String> result = new HashSet<String>();
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            String file = this.asDavPath(files[i]);
            int slashPos = file.lastIndexOf(47);
            if (slashPos == -1) continue;
            result.add(file.substring(0, slashPos));
        }
        String[] dirs = scanner.getIncludedDirectories();
        for (int i = 0; i < dirs.length; ++i) {
            result.add(this.asDavPath(dirs[i]));
        }
        return result.iterator();
    }

    private void uploadFile(String relative, File file) throws IOException {
        HttpURL url = Utils.createHttpURL(this.getUrl(), relative);
        this.uploadFile(url, file, relative);
    }

    private void uploadFile(HttpURL url, File file, String relative) throws IOException {
        boolean putit = false;
        try {
            if (this.overwrite) {
                putit = true;
            } else {
                long remoteLastMod = Utils.getLastModified(this.getHttpClient(), url);
                long localLastMod = file.lastModified();
                putit = localLastMod > remoteLastMod;
            }
        }
        catch (HttpException e) {
            switch (e.getReasonCode()) {
                case 404: {
                    putit = true;
                    break;
                }
                default: {
                    throw Utils.makeBuildException("Can't get lastmodified!?", (Exception)((Object)e));
                }
            }
        }
        if (putit) {
            this.log("Uploading: " + relative, this.ifVerbose());
            try {
                String contentType = Mimetypes.getMimeType(file, DEFAULT_CONTENT_TYPE);
                if (this.filterSets.hasFilters()) {
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    LineTokenizer tok = new LineTokenizer();
                    tok.setIncludeDelims(true);
                    String l = tok.getToken((Reader)reader);
                    while (l != null) {
                        out.write(this.filterSets.replaceTokens(l).getBytes(this.encoding));
                        l = tok.getToken((Reader)reader);
                    }
                    Utils.putFile(this.getHttpClient(), url, new ByteArrayInputStream(out.toByteArray()), contentType, this.locktoken);
                } else {
                    Utils.putFile(this.getHttpClient(), url, new FileInputStream(file), contentType, this.locktoken);
                }
                ++this.countWrittenFiles;
            }
            catch (HttpException e) {
                throw Utils.makeBuildException("Can't upload " + url, (Exception)((Object)e));
            }
        } else {
            ++this.countOmittedFiles;
            this.log("Omitted: " + relative + " (uptodate)", this.ifVerbose());
        }
    }

    private void uploadZipFileSet(ZipFileSet fileSet) throws IOException {
        DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
        ZipFile zipFile = new ZipFile(fileSet.getSrc());
        Iterator i = this.determineRequiredDirectories(scanner);
        while (i.hasNext()) {
            String dir = (String)i.next();
            if (dir.equals("")) {
                Utils.assureExistingCollection(this.getHttpClient(), this.getUrl(), this.locktoken);
                continue;
            }
            HttpURL collURL = Utils.createHttpURL(this.getUrl(), dir + "/");
            Utils.assureExistingCollection(this.getHttpClient(), collURL, this.locktoken);
        }
        String[] files = scanner.getIncludedFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            this.uploadZipEntry(Utils.createHttpURL(this.getUrl(), files[i2]), files[i2], zipFile);
        }
    }

    private void uploadZipEntry(HttpURL url, String name, ZipFile zipFile) throws IOException {
        boolean putit = false;
        ZipEntry entry = zipFile.getEntry(name);
        try {
            if (this.overwrite) {
                putit = true;
            } else {
                long remoteLastMod = Utils.getLastModified(this.getHttpClient(), url);
                long localLastMod = entry.getTime();
                putit = localLastMod > remoteLastMod;
            }
        }
        catch (HttpException e) {
            switch (e.getReasonCode()) {
                case 404: {
                    putit = true;
                    break;
                }
                default: {
                    throw Utils.makeBuildException("Can't get lastmodified!?", (Exception)((Object)e));
                }
            }
        }
        if (putit) {
            this.log("Uploading: " + name, this.ifVerbose());
            String contentType = Mimetypes.getMimeType(name, DEFAULT_CONTENT_TYPE);
            Utils.putFile(this.getHttpClient(), url, zipFile.getInputStream(entry), contentType, this.locktoken);
            ++this.countWrittenFiles;
        } else {
            ++this.countOmittedFiles;
            this.log("Omitted: " + name + " (uptodate)", this.ifVerbose());
        }
    }

    private String asDavPath(String path) {
        return path.replace('\\', '/');
    }

    public ZipFileSet createZipfileset() {
        ZipFileSet fileSet = new ZipFileSet();
        this.zipfilesets.add(fileSet);
        return fileSet;
    }

    public static class ZipFileSet
    extends AbstractFileSet {
        private File src = null;

        public void setSrc(File src) {
            this.src = src;
        }

        File getSrc() {
            if (this.src != null) {
                return this.src;
            }
            throw new BuildException("ZipFileSet requires a src attribute!");
        }

        public DirectoryScanner getDirectoryScanner(Project p) {
            ZipScanner zs = new ZipScanner();
            zs.setSrc(this.getSrc());
            super.setDir(p.getBaseDir());
            this.setupDirectoryScanner((FileScanner)zs, p);
            zs.init();
            return zs;
        }
    }
}

