/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.tree;

import java.text.MessageFormat;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationPanel;
import org.netbeans.modules.cnd.discovery.wizard.tree.FolderConfigurationImpl;
import org.netbeans.modules.cnd.discovery.wizard.tree.FolderConfigurationNode;
import org.netbeans.modules.cnd.discovery.wizard.tree.ProjectConfigurationImpl;
import org.openide.util.NbBundle;

public class ProjectConfigurationNode
extends DefaultMutableTreeNode {
    private ProjectConfigurationImpl project;
    private int count;

    public ProjectConfigurationNode(ProjectConfigurationImpl project) {
        super(project);
        this.project = project;
        this.count = project.getFiles().size();
        this.add(new FolderConfigurationNode((FolderConfigurationImpl)project.getRoot()));
    }

    @Override
    public String toString() {
        if (this.getProject().getLanguageKind() == ItemProperties.LanguageKind.C) {
            return this.getString("ConfigurationLanguageC", "" + this.count);
        }
        if (this.getProject().getLanguageKind() == ItemProperties.LanguageKind.CPP) {
            return this.getString("ConfigurationLanguageCPP", "" + this.count);
        }
        if (this.getProject().getLanguageKind() == ItemProperties.LanguageKind.Fortran) {
            return this.getString("ConfigurationLanguageFortran", "" + this.count);
        }
        return this.getString("ConfigurationLanguageUnknown", "" + this.count);
    }

    public ProjectConfigurationImpl getProject() {
        return this.project;
    }

    private String getString(String key, String files) {
        String message = NbBundle.getBundle(SelectConfigurationPanel.class).getString(key);
        return MessageFormat.format(message, files);
    }
}

