/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.testrunner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.testrunner.spi.TestHandlerFactory;
import org.netbeans.modules.cnd.testrunner.spi.TestHandlerFactoryProvider;
import org.netbeans.modules.cnd.testrunner.ui.CndTestRunnerNodeFactory;
import org.netbeans.modules.cnd.testrunner.ui.CndUnitHandlerFactory;
import org.netbeans.modules.cnd.testrunner.ui.TestRunnerLineConvertor;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class TestRunnerActionHandler
implements ProjectActionHandler,
ExecutionListener,
RerunHandler {
    private ProjectActionEvent pae;
    private volatile Future<Integer> executorTask;
    private final List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private NativeExecutionService execution;
    private TestRunnerLineConvertor convertor;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private TestSession session;
    private Manager manager;
    private InputOutput lastIO = null;

    public void init(ProjectActionEvent pae, ProjectActionEvent[] paes) {
        this.pae = pae;
    }

    public void execute(final InputOutput io) {
        this.lastIO = io;
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    TestRunnerActionHandler.this._execute(io);
                }
            });
        } else {
            this._execute(io);
        }
    }

    private void _execute(InputOutput io) {
        String path;
        ProjectActionEvent.Type actionType = this.pae.getType();
        if (actionType != ProjectActionEvent.PredefinedType.TEST) assert (false);
        String runDirectory = this.pae.getProfile().getRunDirectory();
        MakeConfiguration conf = this.pae.getConfiguration();
        PlatformInfo pi = conf.getPlatformInfo();
        ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
        String exe = this.pae.getExecutable();
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(this.pae.getProfile().getArgsArray()));
        Map env = this.pae.getProfile().getEnvironment().getenvAsMap();
        boolean showInput = actionType == ProjectActionEvent.PredefinedType.RUN;
        boolean unbuffer = false;
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        String csdirs = compilerSet.getDirectory();
        String commands = compilerSet.getCompilerFlavor().getCommandFolder(conf.getDevelopmentHost().getBuildPlatform());
        if (commands != null && commands.length() > 0) {
            csdirs = csdirs + pi.pathSeparator() + commands;
        }
        path = (path = (String)env.get(pi.getPathName())) == null ? csdirs + pi.pathSeparator() + pi.getPathAsString() : csdirs + pi.pathSeparator() + path;
        env.put(pi.getPathName(), path);
        env.put("SPRO_EXPAND_ERRORS", "");
        String workingDirectory = TestRunnerActionHandler.convertToRemoteIfNeeded(execEnv, runDirectory);
        if (workingDirectory == null) {
            // empty if block
        }
        ProcessChangeListener processChangeListener = new ProcessChangeListener(this);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv).setWorkingDirectory(workingDirectory).unbufferOutput(unbuffer).setExecutable(exe).setArguments(args.toArray(new String[args.size()])).addNativeProcessListener((ChangeListener)processChangeListener);
        npb.getEnvironment().putAll(env);
        NativeExecutionDescriptor descr = null;
        this.convertor = this.createTestRunnerConvertor(this.pae.getProject());
        ExecutionDescriptor.LineConvertorFactory lcf = new ExecutionDescriptor.LineConvertorFactory(){
            LineConvertor c;
            {
                this.c = TestRunnerActionHandler.this.convertor;
            }

            public LineConvertor newLineConvertor() {
                return this.c;
            }
        };
        descr = new NativeExecutionDescriptor().controllable(true).frontWindow(false).inputVisible(showInput).inputOutput(io).outLineBased(true).showProgress(!CndUtils.isStandalone()).postExecution((Runnable)processChangeListener).errConvertorFactory(lcf).outConvertorFactory(lcf);
        this.execution = NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)this.pae.getActionName());
        this.runExecution();
    }

    private void runExecution() {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    TestRunnerActionHandler.this.executorTask = TestRunnerActionHandler.this.execution.run();
                }
            });
        } else {
            this.executorTask = this.execution.run();
        }
    }

    private TestRunnerLineConvertor createTestRunnerConvertor(Project project) {
        this.session = new TestSession("Test", project, TestSession.SessionType.TEST, (TestRunnerNodeFactory)new CndTestRunnerNodeFactory());
        this.session.setRerunHandler((RerunHandler)this);
        this.manager = Manager.getInstance();
        CndUnitHandlerFactory predefinedFactory = new CndUnitHandlerFactory();
        ArrayList<TestHandlerFactory> factories = new ArrayList<TestHandlerFactory>();
        Collection providers = Lookup.getDefault().lookupAll(TestHandlerFactoryProvider.class);
        for (TestHandlerFactoryProvider provider : providers) {
            factories.add(provider.getFactory());
        }
        factories.add(predefinedFactory);
        return new TestRunnerLineConvertor(this.manager, this.session, factories);
    }

    public synchronized void refresh() {
        if (this.convertor != null) {
            this.convertor.refreshSession();
        }
    }

    public void addExecutionListener(ExecutionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeExecutionListener(ExecutionListener l) {
        this.listeners.remove(l);
    }

    public boolean canCancel() {
        return true;
    }

    public void cancel() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Future et = TestRunnerActionHandler.this.executorTask;
                if (et != null) {
                    TestRunnerActionHandler.this.executorTask.cancel(true);
                }
            }
        });
    }

    protected static String convertToRemoteIfNeeded(ExecutionEnvironment execEnv, String localDir) {
        if (!TestRunnerActionHandler.checkConnection(execEnv)) {
            return null;
        }
        if (execEnv.isRemote()) {
            return HostInfoProvider.getMapper((ExecutionEnvironment)execEnv).getRemotePath(localDir, false);
        }
        return localDir;
    }

    protected static boolean checkConnection(ExecutionEnvironment execEnv) {
        if (execEnv.isRemote()) {
            try {
                ConnectionManager.getInstance().connectTo(execEnv);
                ServerRecord record = ServerList.get((ExecutionEnvironment)execEnv);
                if (record.isOffline()) {
                    record.validate(true);
                }
                return record.isOnline();
            }
            catch (IOException ex) {
                return false;
            }
            catch (CancellationException ex) {
                return false;
            }
        }
        return true;
    }

    public static String normalizeDriveLetter(CompilerSet cs, String path) {
        if (path.length() > 1 && path.charAt(1) == ':') {
            return cs.getCompilerFlavor().getToolchainDescriptor().getDriveLetterPrefix() + path.charAt(0) + path.substring(2);
        }
        return path;
    }

    public void executionStarted(int pid) {
        for (ExecutionListener l : this.listeners) {
            l.executionStarted(pid);
        }
        this.changeSupport.fireChange();
    }

    public void executionFinished(int rc) {
        for (ExecutionListener l : this.listeners) {
            l.executionFinished(rc);
        }
        this.changeSupport.fireChange();
    }

    public void rerun() {
        if (this.lastIO != null) {
            this.refresh();
            this.execute(this.lastIO);
        }
    }

    public void rerun(Set<Testcase> tests) {
    }

    public boolean enabled(RerunType type) {
        return RerunType.ALL.equals((Object)type);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private static final class ProcessChangeListener
    implements ChangeListener,
    Runnable {
        private final AtomicReference<NativeProcess> processRef = new AtomicReference();
        private final ExecutionListener listener;

        public ProcessChangeListener(ExecutionListener listener) {
            this.listener = listener;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(e instanceof NativeProcessChangeEvent)) {
                return;
            }
            NativeProcessChangeEvent event = (NativeProcessChangeEvent)e;
            this.processRef.compareAndSet(null, (NativeProcess)event.getSource());
            if (event.state == NativeProcess.State.RUNNING && this.listener != null) {
                this.listener.executionStarted(event.pid);
            }
            if (!(e instanceof NativeProcessChangeEvent)) {
                return;
            }
        }

        @Override
        public void run() {
            NativeProcess process = this.processRef.get();
            if (process != null && this.listener != null) {
                this.listener.executionFinished(process.exitValue());
            }
        }
    }
}

