/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.util.Diagnostics;
import java.util.Vector;

public abstract class PackageItem {
    private Vector<String> errors = new Vector();
    private Vector<String> warnings = new Vector();
    protected boolean proceed = true;
    private PackageItem parent;
    protected Vector<PackageItem> items = new Vector();

    public PackageItem() {
        this(null);
    }

    public PackageItem(PackageItem packageItem) {
        this.parent = packageItem;
    }

    public abstract String getItemDisplayName();

    public abstract void initialize();

    public final void process() {
        if (this.canProceed()) {
            this.processInternal();
        }
    }

    public final boolean canProceed() {
        return this.proceed;
    }

    protected abstract void processInternal();

    public final Vector<String> getErrors() {
        return this.errors;
    }

    public final Vector<String> getWarnings() {
        return this.warnings;
    }

    public final Vector<? extends PackageItem> getItems() {
        return this.items;
    }

    public final void addError(ErrorKey errorKey, Object ... objectArray) {
        this.errors.addElement(errorKey.getMessage(objectArray));
    }

    public final void addWarning(ErrorKey errorKey, Object ... objectArray) {
        this.warnings.addElement(errorKey.getMessage(objectArray));
    }

    public final void addItem(PackageItem packageItem) {
        packageItem.setParent(this);
        this.items.addElement(packageItem);
    }

    public final void gatherDiagnostics(Diagnostics diagnostics) {
        if (this.warnings.size() > 0) {
            diagnostics.addWarnings(this.getItemDisplayName().trim(), this.warnings);
        }
        if (this.errors.size() > 0) {
            diagnostics.addErrors(this.getItemDisplayName().trim(), this.errors);
        }
        for (PackageItem packageItem : this.items) {
            packageItem.gatherDiagnostics(diagnostics);
        }
    }

    public final boolean isOk() {
        return this.isOk(true);
    }

    public final boolean isOk(boolean bl) {
        boolean bl2 = true;
        boolean bl3 = bl2 = this.errors.size() <= 0;
        if (bl && bl2) {
            for (PackageItem packageItem : this.items) {
                bl2 = packageItem.isOk(bl);
                if (bl2) continue;
                return false;
            }
        }
        return bl2;
    }

    public final int countErrors() {
        int n = this.errors.size();
        for (PackageItem packageItem : this.items) {
            n += packageItem.countErrors();
        }
        return n;
    }

    public final int countWarnings() {
        int n = this.warnings.size();
        for (PackageItem packageItem : this.items) {
            n += packageItem.countWarnings();
        }
        return n;
    }

    public PackageItem getParent() {
        return this.parent;
    }

    public void setParent(PackageItem packageItem) {
        this.parent = packageItem;
    }
}

