/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.openide.awt.StatusDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class Logo
extends JPanel
implements Constants,
MouseListener {
    private String url;

    public static Logo createOracleLogo() {
        return new Logo("org/netbeans/modules/welcome/resources/oracle_logo.png", BundleSupport.getURL("OracleLogo"));
    }

    public static Logo createJavaLogo() {
        return new Logo("org/netbeans/modules/welcome/resources/java_logo.png", BundleSupport.getURL("JavaLogo"));
    }

    public Logo(String img, String url) {
        super(new BorderLayout());
        ImageIcon image = ImageUtilities.loadImageIcon((String)img, (boolean)true);
        JLabel label = new JLabel(image);
        label.setBorder(BorderFactory.createEmptyBorder());
        label.setOpaque(false);
        label.addMouseListener(this);
        this.setOpaque(false);
        this.add((Component)label, "Center");
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.url = url;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        LogRecord rec = new LogRecord(Level.INFO, "USG_START_PAGE_LINK");
        rec.setParameters(new Object[]{this.url});
        rec.setLoggerName(Constants.USAGE_LOGGER.getName());
        rec.setResourceBundle(NbBundle.getBundle((String)"org.netbeans.modules.welcome.resources.Bundle"));
        rec.setResourceBundleName("org.netbeans.modules.welcome.resources.Bundle");
        Constants.USAGE_LOGGER.log(rec);
        Utils.showURL(this.url);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        StatusDisplayer.getDefault().setStatusText(this.url);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        StatusDisplayer.getDefault().setStatusText(null);
    }
}

