/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.ui.actions.AddBreakpointAction;
import org.netbeans.modules.debugger.ui.models.BreakpointGroup;
import org.netbeans.modules.debugger.ui.models.BreakpointNestedGroupsDialog;
import org.netbeans.modules.debugger.ui.views.VariablesViewButtons;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BreakpointsViewButtons {
    public static final String PREFERENCES_NAME = "variables_view";
    public static final String SHOW_VALUE_AS_STRING = "show_value_as_string";

    public static JButton createNewBreakpointActionButton() {
        JButton button = VariablesViewButtons.createButton("org/netbeans/modules/debugger/resources/breakpointsView/NewBreakpoint.gif", NbBundle.getMessage(BreakpointsViewButtons.class, (String)"Hint_New_Breakpoint"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AddBreakpointAction().actionPerformed(e);
            }
        });
        return button;
    }

    public static synchronized JButton createGroupSelectionButton() {
        final JButton button = VariablesViewButtons.createButton("org/netbeans/modules/debugger/resources/breakpointsView/BreakpointGroups_options_16.png", NbBundle.getMessage(BreakpointsViewButtons.class, (String)"Hint_Select_bp_groups"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Properties props = Properties.getDefault().getProperties("Breakpoints");
                String[] groupNames = (String[])props.getArray("Grouping", (Object[])new String[]{BreakpointGroup.Group.CUSTOM.name()});
                String brkpGroup = groupNames.length == 0 ? BreakpointGroup.Group.NO.name() : (groupNames.length > 1 ? BreakpointGroup.Group.NESTED.name() : groupNames[0]);
                JPopupMenu menu = new JPopupMenu(NbBundle.getMessage(BreakpointsViewButtons.class, (String)"Lbl_bp_groups"));
                for (BreakpointGroup.Group group : BreakpointGroup.Group.values()) {
                    menu.add(BreakpointsViewButtons.createJRadioButtonMenuItem(group, brkpGroup));
                }
                menu.addSeparator();
                menu.add(BreakpointsViewButtons.createCheckBoxMenuItem("LBL_BreakpointsFromOpenProjectsOnly", "fromOpenProjects", props));
                if (BreakpointsViewButtons.currentSessionHaveProjects()) {
                    menu.add(BreakpointsViewButtons.createCheckBoxMenuItem("LBL_BreakpointsFromCurrentDebugSessionOnly", "fromCurrentSessionProjects", props));
                }
                menu.show(button, 16, 0);
            }
        });
        button.setVisible(false);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Breakpoint[] brkps;
                boolean groupableBreakpoints = false;
                for (Breakpoint b : brkps = DebuggerManager.getDebuggerManager().getBreakpoints()) {
                    if (b.getGroupProperties() == null) continue;
                    groupableBreakpoints = true;
                    break;
                }
                if (groupableBreakpoints) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            button.setVisible(true);
                        }
                    });
                } else {
                    final boolean[] gb = new boolean[]{groupableBreakpoints};
                    DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)new DebuggerManagerAdapter(){

                        public void breakpointAdded(Breakpoint breakpoint) {
                            if (!gb[0] && breakpoint.getGroupProperties() != null) {
                                gb[0] = true;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        button.setVisible(true);
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        return button;
    }

    private static JRadioButtonMenuItem createJRadioButtonMenuItem(BreakpointGroup.Group group, String brkpGroup) {
        JRadioButtonMenuItem gb = new JRadioButtonMenuItem(new GroupChangeAction(group));
        gb.setSelected(brkpGroup.equals(group.name()));
        return gb;
    }

    private static JCheckBoxMenuItem createCheckBoxMenuItem(String text, final String propName, final Properties props) {
        boolean selected = props.getBoolean(propName, true);
        text = NbBundle.getMessage(BreakpointsViewButtons.class, (String)text);
        final JCheckBoxMenuItem chb = new JCheckBoxMenuItem(text, selected);
        chb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = chb.isSelected();
                props.setBoolean(propName, selected);
            }
        });
        return chb;
    }

    private static boolean currentSessionHaveProjects() {
        Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
        if (currentSession == null) {
            return false;
        }
        List sessionProjects = currentSession.lookup(null, Project.class);
        return sessionProjects.size() > 0;
    }

    private static class GroupChangeAction
    extends AbstractAction {
        private BreakpointGroup.Group group;

        public GroupChangeAction(BreakpointGroup.Group group) {
            this.group = group;
            String name = "LBL_" + group.name() + "Group";
            name = NbBundle.getMessage(BreakpointsViewButtons.class, (String)name);
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.group == BreakpointGroup.Group.NESTED) {
                BreakpointNestedGroupsDialog bngd = new BreakpointNestedGroupsDialog();
                bngd.setDisplayedGroups((String[])Properties.getDefault().getProperties("Breakpoints").getArray("Grouping", (Object[])new String[]{BreakpointGroup.Group.CUSTOM.name()}));
                String title = NbBundle.getMessage(BreakpointNestedGroupsDialog.class, (String)"BreakpointNestedGroupsDialog_title");
                Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)bngd, title, true, null));
                if (NotifyDescriptor.OK_OPTION.equals(res)) {
                    Properties.getDefault().getProperties("Breakpoints").setArray("Grouping", (Object[])bngd.getDisplayedGroups());
                }
            } else {
                Properties.getDefault().getProperties("Breakpoints").setArray("Grouping", (Object[])new String[]{this.group.name()});
            }
        }
    }
}

