/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.j2meunit;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.mobility.project.support.DefaultPropertyParsers;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class TestUtils {
    static final String TEST_CLASSNAME_PREFIX = NbBundle.getMessage(TestUtils.class, (String)"PROP_test_classname_prefix");
    static final String TEST_CLASSNAME_SUFFIX = NbBundle.getMessage(TestUtils.class, (String)"PROP_test_classname_suffix");
    static final String SUITE_CLASSNAME_PREFIX = NbBundle.getMessage(TestUtils.class, (String)"PROP_suite_classname_prefix");
    static final String SUITE_CLASSNAME_SUFFIX = NbBundle.getMessage(TestUtils.class, (String)"PROP_suite_classname_suffix");
    static final boolean GENERATE_TESTS_FROM_TEST_CLASSES = NbBundle.getMessage(TestUtils.class, (String)"PROP_generate_tests_from_test_classes").equals("true");
    static final String TEST_METHODNAME_PREFIX = NbBundle.getMessage(TestUtils.class, (String)"PROP_test_method_prefix");
    static final String TEST_METHODNAME_SUFFIX = NbBundle.getMessage(TestUtils.class, (String)"PROP_test_method_suffix");
    static final String TEST_RUNNER_NAME = "TestRunnerMIDlet";

    public static Set<Modifier> createModifierSet(Modifier ... modifiers) {
        EnumSet<Modifier> modifierSet = EnumSet.noneOf(Modifier.class);
        for (Modifier m : modifiers) {
            modifierSet.add(m);
        }
        return modifierSet;
    }

    public static String getTestClassName(String sourceClassName) {
        return TEST_CLASSNAME_PREFIX + sourceClassName + TEST_CLASSNAME_SUFFIX;
    }

    public static String getSimpleName(String fullName) {
        int lastDotIndex = fullName.lastIndexOf(46);
        return lastDotIndex == -1 ? fullName : fullName.substring(lastDotIndex + 1);
    }

    public static String getPackageName(String fullName) {
        if (fullName != null) {
            int i = fullName.lastIndexOf(46);
            return i != -1 ? fullName.substring(0, i) : "";
        }
        return "";
    }

    public static String getTestClassFullName(String sourceClassName, String packageName) {
        String shortTestClassName = TestUtils.getTestClassName(sourceClassName);
        return packageName == null || packageName.length() == 0 ? shortTestClassName : packageName.replace('.', '/') + '/' + shortTestClassName;
    }

    public static String createTestMethodName(String smName) {
        return "test" + smName.substring(0, 1).toUpperCase() + smName.substring(1);
    }

    static void addTestClassProperty(Project p, AntProjectHelper aph, String clazz) throws IOException {
        ProjectConfigurationsHelper pch = (ProjectConfigurationsHelper)p.getLookup().lookup(ProjectConfigurationsHelper.class);
        Collection confs = pch.getConfigurations();
        EditableProperties ep = aph.getProperties("nbproject/project.properties");
        ReferenceHelper refHelper = (ReferenceHelper)p.getLookup().lookup(ReferenceHelper.class);
        String defaultValue = ep.getProperty("manifest.jad");
        HashMap map = defaultValue != null ? (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(defaultValue, aph, refHelper) : new HashMap();
        TestUtils.addTestClassProperty(map, clazz);
        ep.put("manifest.jad", DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode((Object)map, aph, refHelper));
        for (ProjectConfiguration conf : confs) {
            String propertyValue;
            String confName = conf.getDisplayName();
            String propertyName = VisualPropertySupport.translatePropertyName((String)confName, (String)"manifest.jad", (boolean)false);
            if (propertyName == null || (propertyValue = ep.getProperty(propertyName)) == null) continue;
            map = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(defaultValue, aph, refHelper);
            TestUtils.addTestClassProperty(map, clazz);
            ep.put(propertyName, DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode((Object)map, aph, refHelper));
        }
        aph.putProperties("nbproject/project.properties", ep);
        ProjectManager.getDefault().saveProject(p);
    }

    private static void addTestClassProperty(Map map, String clazz) {
        String key = NbBundle.getMessage(TestUtils.class, (String)"PROP_config_TestClasses_key");
        if (map.containsKey(key)) {
            String prop = (String)map.get(key);
            if (prop.indexOf(clazz) < 0) {
                prop = prop == null || prop.equals("") ? clazz : prop + " " + clazz;
                map.put(key, prop);
            }
        } else {
            map.put(key, clazz);
        }
    }

    static void addTestRunnerMIDletProperty(Project project, AntProjectHelper h) throws IOException {
        String name = NbBundle.getMessage(TestUtils.class, (String)"PROP_config_TestRunner_name");
        String clazz = NbBundle.getMessage(TestUtils.class, (String)"PROP_config_TestRunner_clazz");
        String icon = NbBundle.getMessage(TestUtils.class, (String)"PROP_config_TestRunner_icon");
        ProjectConfigurationsHelper confHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        Collection confs = confHelper.getConfigurations();
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        String defaultValue = ep.getProperty("manifest.midlets");
        HashMap map = defaultValue != null ? (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(defaultValue, null, null) : new HashMap();
        TestUtils.addTestRunnerMIDletProperty(map, name, clazz, icon);
        ep.put("manifest.midlets", DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode((Object)map, null, null));
        for (ProjectConfiguration conf : confs) {
            String propertyValue;
            String confName = conf.getDisplayName();
            String propertyName = VisualPropertySupport.translatePropertyName((String)confName, (String)"manifest.midlets", (boolean)false);
            if (propertyName == null || (propertyValue = ep.getProperty(propertyName)) == null) continue;
            map = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(defaultValue, null, null);
            TestUtils.addTestRunnerMIDletProperty(map, name, clazz, icon);
            ep.put(propertyName, DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode((Object)map, null, null));
        }
        h.putProperties("nbproject/project.properties", ep);
        ProjectManager.getDefault().saveProject(project);
    }

    private static void addTestRunnerMIDletProperty(Map map, String name, String clazz, String icon) {
        int a = 1;
        boolean flag = false;
        while (map.containsKey("MIDlet-" + a)) {
            String midletDef = (String)map.get("MIDlet-" + a);
            if (midletDef.contains(NbBundle.getMessage(TestUtils.class, (String)"PROP_config_TestRunner_clazz"))) {
                flag = true;
            }
            ++a;
        }
        if (!flag) {
            map.put("MIDlet-" + a, name + ", " + icon + ", " + clazz);
        }
    }

    public static FileObject getTestFileObject(FileObject classFile) {
        String testClassName = TEST_CLASSNAME_PREFIX + classFile.getName() + TEST_CLASSNAME_SUFFIX;
        String absolutePath = FileUtil.toFile((FileObject)classFile).getAbsolutePath();
        String directoryPath = absolutePath.substring(absolutePath.indexOf(classFile.getName()));
        File testFile = new File(directoryPath + testClassName + ".java");
        return FileUtil.toFileObject((File)testFile);
    }

    public static boolean testMethodExists(ClassTree tstClass, String testMethodName) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tstClass.getKind()));
        List<? extends Tree> members = tstClass.getMembers();
        for (Tree tree : members) {
            MethodTree methodTree;
            if (!(tree instanceof MethodTree) || !(methodTree = (MethodTree)tree).getName().toString().equals(testMethodName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTestable(ClassTree typeDecl, TreeUtilities treeUtils) {
        return !treeUtils.isAnnotation(typeDecl);
    }

    static boolean isTestable(FileObject fo) {
        return !fo.getName().endsWith(TEST_RUNNER_NAME) && !fo.getName().endsWith(TEST_CLASSNAME_SUFFIX) && fo.getExt().equals("java");
    }

    static boolean isTestable(Element typeDeclElement) {
        ElementKind elemKind = typeDeclElement.getKind();
        return elemKind != ElementKind.ANNOTATION_TYPE && (elemKind.isClass() || elemKind.isInterface());
    }

    static boolean isTestMethod(MethodTree testMethod) {
        String testMethodName = testMethod.getName().toString();
        return testMethodName.startsWith(NbBundle.getMessage(TestUtils.class, (String)"PROP_test_method_prefix")) && !testMethodName.equals(NbBundle.getMessage(TestUtils.class, (String)"PROP_test_method_prefix")) && testMethodName.endsWith(NbBundle.getMessage(TestUtils.class, (String)"PROP_test_method_suffix"));
    }

    private static List<TypeElement> findTopClassElems(CompilationInfo compInfo, CompilationUnitTree compilationUnit) {
        List<? extends Tree> typeDecls = compilationUnit.getTypeDecls();
        if (typeDecls == null || typeDecls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeElement> result = new ArrayList<TypeElement>(typeDecls.size());
        Trees trees = compInfo.getTrees();
        for (Tree tree : typeDecls) {
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
            Element element = trees.getElement(new TreePath(new TreePath(compilationUnit), tree));
            TypeElement typeElement = (TypeElement)element;
            if (!TestUtils.isTestable(element)) continue;
            result.add(typeElement);
        }
        return result;
    }

    private static List<ElementHandle<TypeElement>> findTopClassElemHandles(CompilationInfo compInfo, CompilationUnitTree compilationUnit) {
        return TestUtils.getElemHandles(TestUtils.findTopClassElems(compInfo, compilationUnit));
    }

    private static <T extends Element> List<ElementHandle<T>> getElemHandles(List<T> elements) {
        if (elements == null) {
            return null;
        }
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ElementHandle<T>> handles = new ArrayList<ElementHandle<T>>(elements.size());
        for (Element element : elements) {
            handles.add(ElementHandle.create((Element)element));
        }
        return handles;
    }

    public static List<ClassTree> findTopClasses(CompilationUnitTree compilationUnit, TreeUtilities treeUtils) {
        List<? extends Tree> typeDecls = compilationUnit.getTypeDecls();
        if (typeDecls == null || typeDecls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClassTree> result = new ArrayList<ClassTree>(typeDecls.size());
        for (Tree tree : typeDecls) {
            ClassTree clsTree;
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !TestUtils.isTestable(clsTree = (ClassTree)tree, treeUtils)) continue;
            result.add(clsTree);
        }
        return result;
    }

    public static HashMap<ElementHandle<TypeElement>, List<ExecutableElement>> findTopClasses(JavaSource javaSource, Set<Modifier> accessModifiers, boolean tpm, boolean skipAbstractClasses, boolean skipPkgPrivateClasses, boolean skipExceptionClasses) throws IOException {
        TopClassFinderTask finder = new TopClassFinderTask(accessModifiers, tpm, skipAbstractClasses, skipPkgPrivateClasses, skipExceptionClasses);
        javaSource.runUserActionTask((Task)finder, true);
        return finder.getTopClassElems();
    }

    public static boolean hasSetUp(ClassTree tstClass) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tstClass.getKind()));
        List<? extends Tree> members = tstClass.getMembers();
        for (Tree tree : members) {
            MethodTree methodTree;
            if (!(tree instanceof MethodTree) || !(methodTree = (MethodTree)tree).getName().toString().equals(NbBundle.getMessage(TestUtils.class, (String)"PROP_generator_method_setup"))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTearDown(ClassTree tstClass) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tstClass.getKind()));
        List<? extends Tree> members = tstClass.getMembers();
        for (Tree tree : members) {
            MethodTree methodTree;
            if (!(tree instanceof MethodTree) || !(methodTree = (MethodTree)tree).getName().toString().equals(NbBundle.getMessage(TestUtils.class, (String)"PROP_generator_method_teardown"))) continue;
            return true;
        }
        return false;
    }

    static class TestableTypeFinder
    implements CancellableTask<CompilationController> {
        private volatile boolean cancelled;
        private boolean testable = true;

        TestableTypeFinder() {
        }

        public void run(CompilationController parameter) throws Exception {
            parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            if (this.cancelled) {
                return;
            }
            List<? extends Tree> typeDecls = parameter.getCompilationUnit().getTypeDecls();
            if (typeDecls == null || typeDecls.isEmpty()) {
                return;
            }
            ArrayList result = new ArrayList(typeDecls.size());
            Trees trees = parameter.getTrees();
            for (Tree tree : typeDecls) {
                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                TypeElement element = (TypeElement)trees.getElement(new TreePath(new TreePath(parameter.getCompilationUnit()), tree));
                ElementKind elemKind = element.getKind();
                if (elemKind.isInterface()) {
                    this.testable = false;
                    return;
                }
                TypeElement midlet = parameter.getElements().getTypeElement("javax.microedition.midlet.MIDlet");
                if (midlet != null && !parameter.getTypeUtilities().isCastable(element.asType(), midlet.asType())) continue;
                this.testable = false;
                return;
            }
        }

        public boolean isTestable() {
            return this.testable;
        }

        public void cancel() {
            this.cancelled = true;
        }
    }

    private static class TopClassFinderTask
    implements CancellableTask<CompilationController> {
        private volatile boolean cancelled;
        private final boolean testPkgPrivateMethods;
        private final Set<Modifier> accessModifiers;
        final boolean skipAbstractClasses;
        final boolean skipPkgPrivateClasses;
        final boolean skipExceptionClasses;
        private HashMap<ElementHandle<TypeElement>, List<ExecutableElement>> topClassMap = new HashMap();

        private TopClassFinderTask(Set<Modifier> am, boolean tpm, boolean skipAbstractClasses, boolean skipPkgPrivateClasses, boolean skipExceptionClasses) {
            this.accessModifiers = am;
            this.testPkgPrivateMethods = tpm;
            this.skipAbstractClasses = skipAbstractClasses;
            this.skipExceptionClasses = skipExceptionClasses;
            this.skipPkgPrivateClasses = skipPkgPrivateClasses;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void run(CompilationController parameter) throws Exception {
            parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            if (this.cancelled) {
                return;
            }
            TypeElement exceptionType = null;
            if (this.skipExceptionClasses) {
                exceptionType = parameter.getElements().getTypeElement("java.lang.Exception");
            }
            List topCls = TestUtils.findTopClassElems((CompilationInfo)parameter, parameter.getCompilationUnit());
            for (TypeElement typeElement : topCls) {
                Types types;
                boolean isSubtype;
                Set<Modifier> modifiers = typeElement.getModifiers();
                if (this.skipAbstractClasses && modifiers.contains((Object)Modifier.ABSTRACT) || this.skipPkgPrivateClasses && !modifiers.contains((Object)Modifier.PUBLIC) || exceptionType != null && (isSubtype = (types = parameter.getTypes()).isSubtype(types.erasure(typeElement.asType()), types.erasure(exceptionType.asType())))) continue;
                List ltce = TestUtils.findTopClassElemHandles((CompilationInfo)parameter, parameter.getCompilationUnit());
                for (ElementHandle tce : ltce) {
                    this.topClassMap.put((ElementHandle<TypeElement>)tce, this.findTestableMethods((TypeElement)tce.resolve((CompilationInfo)parameter)));
                }
            }
        }

        private boolean isTestableMethod(ExecutableElement method) {
            if (method.getKind() != ElementKind.METHOD) {
                throw new IllegalArgumentException();
            }
            return this.isMethodAcceptable(method);
        }

        private boolean isMethodAcceptable(ExecutableElement method) {
            Set<Modifier> modifiers = method.getModifiers();
            if (modifiers.contains((Object)Modifier.PUBLIC) && this.accessModifiers.contains((Object)Modifier.PUBLIC)) {
                return true;
            }
            if (modifiers.contains((Object)Modifier.PROTECTED) && this.accessModifiers.contains((Object)Modifier.PROTECTED)) {
                return true;
            }
            return !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PRIVATE) && this.testPkgPrivateMethods;
        }

        private List<ExecutableElement> findTestableMethods(TypeElement classElem) {
            List<ExecutableElement> methods = ElementFilter.methodsIn(classElem.getEnclosedElements());
            if (methods.isEmpty()) {
                return Collections.emptyList();
            }
            List<ExecutableElement> testableMethods = null;
            int skippedCount = 0;
            for (ExecutableElement method : methods) {
                if (this.isTestableMethod(method)) {
                    if (testableMethods == null) {
                        testableMethods = new ArrayList<ExecutableElement>(methods.size() - skippedCount);
                    }
                    testableMethods.add(method);
                    continue;
                }
                ++skippedCount;
            }
            return testableMethods != null ? testableMethods : Collections.emptyList();
        }

        public HashMap<ElementHandle<TypeElement>, List<ExecutableElement>> getTopClassElems() {
            return this.topClassMap;
        }
    }
}

