/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.ide.JBStartServer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class JBLogWriter {
    private static final Logger LOGGER = Logger.getLogger(JBLogWriter.class.getName());
    private static final int DELAY_MIN = 50;
    private static final int DELAY_MAX = 300;
    private static final int DELAY_INC = 50;
    private static final int INC_COUNT = 10;
    private static final int START_TIMEOUT = 300000;
    private final Object READER_LOCK = new Object();
    private final Object START_LOCK = new Object();
    private LOGGER_TYPE type;
    private static final String THREAD_NAME = "JBoss Log Writer";
    private static final String STOPPER_THREAD_NAME = "JBoss Log Writer Stopper";
    private JBStartServer.ACTION_STATUS actionStatus = JBStartServer.ACTION_STATUS.UNKNOWN;
    JBStartServer startServer;
    private final OutputWriter out;
    private final OutputWriter err;
    private volatile BufferedReader reader;
    private volatile BufferedReader errorReader;
    private final String instanceName;
    private Process process;
    private File logFile;
    private LogThread logWriterThread;
    private static HashMap<String, JBLogWriter> instances = new HashMap();
    private LineReader lineReader = new LineReader();
    private LineReader errorLineReader = null;

    private JBLogWriter(InputOutput io, String instanceName) {
        this.out = io != null ? io.getOut() : null;
        this.err = io != null ? io.getErr() : null;
        this.instanceName = instanceName;
    }

    public static synchronized JBLogWriter createInstance(InputOutput io, String instanceName) {
        JBLogWriter instance = JBLogWriter.getInstance(instanceName);
        if (instance == null) {
            instance = new JBLogWriter(io, instanceName);
            instances.put(instanceName, instance);
        }
        return instance;
    }

    public static synchronized JBLogWriter getInstance(String instanceName) {
        return instances.get(instanceName);
    }

    public void start(File logFile) {
        try {
            this.logFile = logFile;
            this.reader = new BufferedReader(new FileReader(logFile));
        }
        catch (FileNotFoundException ioe) {
            LOGGER.log(Level.INFO, null, ioe);
        }
        this.startWriter(new LineProcessor(){

            @Override
            public void processLine(String line) {
                if (JBLogWriter.this.out != null && line != null && line.indexOf(" INFO ") != -1) {
                    JBLogWriter.this.out.println(line);
                }
            }

            @Override
            public void close() {
                JBLogWriter.this.out.close();
            }
        }, null, LOGGER_TYPE.FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JBStartServer.ACTION_STATUS start(Process process, JBStartServer startServer) {
        this.process = process;
        this.startServer = startServer;
        this.reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        this.errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        this.errorLineReader = new LineReader();
        this.startWriter(new LineProcessor(){
            private boolean checkStartProgress = true;

            @Override
            public void processLine(String line) {
                if (line != null) {
                    if (JBLogWriter.this.out != null) {
                        JBLogWriter.this.out.println(line);
                    }
                    if (this.checkStartProgress) {
                        this.checkStartProgress(line);
                    }
                }
            }

            @Override
            public void close() {
                JBLogWriter.this.out.close();
            }

            private void checkStartProgress(String line) {
                if (line.indexOf("Starting JBoss (MX MicroKernel)") > -1 || line.indexOf("Starting JBoss (Microcontainer)") > -1 || line.indexOf("Starting JBossAS") > -1) {
                    LOGGER.log(Level.FINER, "STARTING message fired");
                    JBLogWriter.this.fireStartProgressEvent(StateType.RUNNING, JBLogWriter.this.createProgressMessage("MSG_START_SERVER_IN_PROGRESS"));
                } else if ((line.indexOf("JBoss (MX MicroKernel)") > -1 || line.indexOf("JBoss (Microcontainer)") > -1 || line.indexOf("JBossAS") > -1) && line.indexOf("Started in") > -1) {
                    LOGGER.log(Level.FINER, "STARTED message fired");
                    this.checkStartProgress = false;
                    JBLogWriter.this.actionStatus = JBStartServer.ACTION_STATUS.SUCCESS;
                    JBLogWriter.this.notifyStartupThread();
                } else if (line.indexOf("Shutdown complete") > -1) {
                    this.checkStartProgress = false;
                    JBLogWriter.this.actionStatus = JBStartServer.ACTION_STATUS.FAILURE;
                    JBLogWriter.this.notifyStartupThread();
                }
            }
        }, new LineProcessor(){

            @Override
            public void processLine(String line) {
                if (line != null && JBLogWriter.this.err != null) {
                    JBLogWriter.this.err.println(line);
                }
            }

            @Override
            public void close() {
                JBLogWriter.this.err.close();
            }
        }, LOGGER_TYPE.PROCESS);
        try {
            Object object = this.START_LOCK;
            synchronized (object) {
                long start = System.currentTimeMillis();
                this.START_LOCK.wait(300000L);
                if (System.currentTimeMillis() - start >= 300000L) {
                    LOGGER.log(Level.FINER, "Startup thread TIMEOUT EXPIRED");
                    this.actionStatus = JBStartServer.ACTION_STATUS.UNKNOWN;
                } else {
                    LOGGER.log(Level.FINER, "Startup thread NOTIFIED");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.actionStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStartupThread() {
        Object object = this.START_LOCK;
        synchronized (object) {
            this.START_LOCK.notify();
        }
    }

    private void fireStartProgressEvent(StateType stateType, String msg) {
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.START, stateType, msg));
    }

    private String createProgressMessage(String resName) {
        return NbBundle.getMessage(JBLogWriter.class, (String)resName, (Object)this.instanceName);
    }

    private synchronized void startWriter(LineProcessor lineProcessor, LineProcessor errorLineProcessor, LOGGER_TYPE type) {
        if (this.isRunning() || this.logWriterThread != null && this.logWriterThread.isAlive()) {
            this.logWriterThread.interrupt();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "INTERRUPT thread " + this.logWriterThread.getId());
            }
        }
        this.type = type;
        this.logWriterThread = new LogThread(THREAD_NAME, lineProcessor, errorLineProcessor);
        this.logWriterThread.start();
    }

    synchronized void stop() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Stopping " + this.logWriterThread.getId());
        }
        if (this.logWriterThread != null) {
            this.logWriterThread.finish();
        }
    }

    synchronized boolean isRunning() {
        return this.logWriterThread != null && this.logWriterThread.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.type == LOGGER_TYPE.PROCESS || this.logFile == null) {
            return;
        }
        Object object = this.READER_LOCK;
        synchronized (object) {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
            }
            try {
                if (this.out != null) {
                    this.out.reset();
                }
                LOGGER.log(Level.FINER, "REFRESHING the output pane");
                this.reader = new BufferedReader(new FileReader(this.logFile));
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processInput(LineProcessor lineProcessor, LineProcessor errorLineProcessor, LOGGER_TYPE type) {
        Object object = this.READER_LOCK;
        synchronized (object) {
            boolean ready = false;
            try {
                if (type == LOGGER_TYPE.PROCESS) {
                    while (this.reader.ready()) {
                        ready = this.lineReader.readLine(this.reader, lineProcessor);
                    }
                    if (this.errorReader != null && this.errorLineReader != null) {
                        while (this.errorReader.ready()) {
                            this.errorLineReader.readLine(this.errorReader, errorLineProcessor);
                        }
                    }
                } else {
                    while (this.reader.ready()) {
                        String line = this.reader.readLine();
                        lineProcessor.processLine(line);
                        ready = true;
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, null, e);
            }
            return ready;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForServerProcessFinished(long milliseconds) {
        RequestProcessor.Task t = new RequestProcessor(STOPPER_THREAD_NAME, 1, true).post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "JBoss Log Writer Stopper: WAITING for the server process to stop");
                    }
                    if (JBLogWriter.this.type == LOGGER_TYPE.PROCESS) {
                        JBLogWriter.this.process.waitFor();
                    } else {
                        Thread.sleep(2000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        try {
            t.waitFinished(milliseconds);
        }
        catch (InterruptedException ex) {
        }
        finally {
            t.cancel();
        }
    }

    private class LogThread
    extends Thread {
        private final LineProcessor lineProcessor;
        private final LineProcessor errorLineProcessor;
        private volatile boolean read;

        public LogThread(String name, LineProcessor lineProcessor, LineProcessor errorLineProcessor) {
            super(name);
            this.read = true;
            this.lineProcessor = lineProcessor;
            this.errorLineProcessor = errorLineProcessor;
        }

        public boolean isRunning() {
            return this.read;
        }

        public void finish() {
            this.read = false;
        }

        @Override
        public void run() {
            boolean checkProfiler;
            int currentDelay = 50;
            int noReadCount = 0;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "START thread " + Thread.currentThread().getId());
            }
            boolean interrupted = false;
            long lastFileSize = -1L;
            boolean bl = checkProfiler = JBLogWriter.this.startServer != null && JBLogWriter.this.startServer.getMode() == JBStartServer.MODE.PROFILE;
            while (this.read) {
                if (checkProfiler) {
                    int state = ProfilerSupport.getState();
                    if (state == 2 || state == 3 || state == 4) {
                        JBLogWriter.this.fireStartProgressEvent(StateType.COMPLETED, JBLogWriter.this.createProgressMessage("MSG_PROFILED_SERVER_STARTED"));
                        checkProfiler = false;
                        JBLogWriter.this.notifyStartupThread();
                    } else if (state == 0) {
                        JBLogWriter.this.fireStartProgressEvent(StateType.FAILED, JBLogWriter.this.createProgressMessage("MSG_START_PROFILED_SERVER_FAILED"));
                        JBLogWriter.this.process.destroy();
                        JBLogWriter.this.notifyStartupThread();
                        break;
                    }
                }
                boolean ready = JBLogWriter.this.processInput(this.lineProcessor, this.errorLineProcessor, JBLogWriter.this.type);
                if (JBLogWriter.this.type == LOGGER_TYPE.FILE) {
                    if (ready) {
                        lastFileSize = JBLogWriter.this.logFile.length();
                    } else if (lastFileSize != JBLogWriter.this.logFile.length()) {
                        LOGGER.log(Level.FINER, "DIFFERENCE found");
                        JBLogWriter.this.refresh();
                    }
                } else {
                    try {
                        JBLogWriter.this.process.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException itse) {
                        // empty catch block
                    }
                }
                try {
                    if (!this.read) {
                        if (++noReadCount == 10) {
                            noReadCount = 0;
                            currentDelay += 50;
                            currentDelay = Math.min(currentDelay, 300);
                        }
                    } else {
                        currentDelay = 50;
                        noReadCount = 0;
                    }
                    Thread.sleep(currentDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                interrupted = true;
                break;
            }
            this.lineProcessor.processLine(JBLogWriter.this.lineReader.getTrailingLine());
            if (this.errorLineProcessor != null && JBLogWriter.this.errorLineReader != null) {
                this.errorLineProcessor.processLine(JBLogWriter.this.errorLineReader.getTrailingLine());
            }
            this.lineProcessor.close();
            if (this.errorLineProcessor != null) {
                this.errorLineProcessor.close();
            } else {
                JBLogWriter.this.err.close();
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "FINISH thread " + Thread.currentThread().getId());
            }
            if (!interrupted) {
                this.read = false;
                instances.remove(JBLogWriter.this.instanceName);
            }
        }
    }

    private static class LineReader {
        private String trailingLine = "";

        private LineReader() {
        }

        public String getTrailingLine() {
            return this.trailingLine;
        }

        private boolean readLine(BufferedReader reader, LineProcessor lineProcessor) throws IOException {
            char[] cbuf = new char[128];
            int size = -1;
            size = reader.read(cbuf);
            if (size != -1) {
                String lines = this.trailingLine != null ? this.trailingLine : "";
                lines = lines + new String(cbuf, 0, size);
                int tlLength = this.trailingLine != null ? this.trailingLine.length() : 0;
                int start = 0;
                for (int i = 0; i < size; ++i) {
                    String line;
                    if (cbuf[i] == '\r' && (i + 1 == size || cbuf[i + 1] != '\n') || cbuf[i] == '\n') {
                        line = lines.substring(start, tlLength + i);
                        start = tlLength + (i + 1);
                        if (lineProcessor == null) continue;
                        lineProcessor.processLine(line);
                        continue;
                    }
                    if (cbuf[i] != '\r' || i + 1 >= size || cbuf[i + 1] != '\n') continue;
                    line = lines.substring(start, tlLength + i);
                    start = tlLength + (++i + 1);
                    if (lineProcessor == null) continue;
                    lineProcessor.processLine(line);
                }
                this.trailingLine = start < lines.length() ? lines.substring(start) : null;
                return true;
            }
            return false;
        }
    }

    private static interface LineProcessor {
        public void processLine(String var1);

        public void close();
    }

    private static enum LOGGER_TYPE {
        PROCESS,
        FILE;

    }
}

