/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

public final class ShellSession {
    private static final HashMap<ExecutionEnvironment, NativeProcess> sessions = new HashMap();
    private static final String eop = "ShellSession.CMDDONE";

    private ShellSession() {
    }

    public static synchronized void shutdown(ExecutionEnvironment env) {
        if (sessions.containsKey(env)) {
            NativeProcess process = sessions.get(env);
            ProcessUtils.destroy(process);
            sessions.remove(env);
        }
    }

    private static synchronized NativeProcess startProcess(ExecutionEnvironment env) throws IOException {
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(env);
        HostInfo info = HostInfoUtils.getHostInfo(env);
        npb.setExecutable(info.getShell()).setArguments("-s");
        npb.getEnvironment().put("LC_ALL", "C");
        NativeProcess result = npb.call();
        sessions.put(env, result);
        return result;
    }

    public static synchronized String[] execute(ExecutionEnvironment env, String command) throws IOException {
        NativeProcess process = sessions.get(env);
        if (process == null || process.getState() != NativeProcess.State.RUNNING) {
            process = ShellSession.startProcess(env);
        }
        String cmd = command + "; echo " + eop + " \n";
        process.getOutputStream().write(cmd.getBytes());
        process.getOutputStream().flush();
        String[] result = ShellSession.getResult(process.getInputStream());
        return result;
    }

    private static String[] getResult(InputStream inputStream) throws IOException {
        int c;
        ArrayList<String> resultBuffer = new ArrayList<String>();
        StringBuilder lineBuffer = new StringBuilder();
        while ((c = inputStream.read()) >= 0) {
            if (c == 10) {
                String line = lineBuffer.toString();
                lineBuffer.setLength(0);
                if (line.startsWith(eop)) break;
                resultBuffer.add(line);
                continue;
            }
            lineBuffer.append((char)c);
        }
        return resultBuffer.toArray(new String[resultBuffer.size()]);
    }
}

