/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.net.ConnectException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.Md5checker;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

class SftpSupport {
    private static final boolean isUnitTest = Boolean.getBoolean("nativeexecution.mode.unittest");
    private static final java.util.logging.Logger LOG = Logger.getInstance();
    private static final Object instancesLock = new Object();
    private static Map<ExecutionEnvironment, SftpSupport> instances = new HashMap<ExecutionEnvironment, SftpSupport>();
    private static AtomicInteger uploadCount = new AtomicInteger(0);
    private static final int PUT_RETRY_COUNT = Integer.getInteger("sftp.put.retries", 1);
    private final ExecutionEnvironment execEnv;
    private static final RequestProcessor requestProcessor = new RequestProcessor("SFTP request processor");
    private ChannelSftp channel;
    private final Object channelLock = new Object();

    static int getUploadCount() {
        return uploadCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SftpSupport getInstance(ExecutionEnvironment execEnv) {
        SftpSupport instance = null;
        Object object = instancesLock;
        synchronized (object) {
            instance = instances.get(execEnv);
            if (instance == null) {
                instance = new SftpSupport(execEnv);
                instances.put(execEnv, instance);
            }
        }
        return instance;
    }

    static Future<Integer> uploadFile(CommonTasksSupport.UploadParameters parameters) {
        return SftpSupport.getInstance(parameters.dstExecEnv).uploadFileImpl(parameters);
    }

    static Future<Integer> downloadFile(String srcFileName, ExecutionEnvironment execEnv, String dstFileName, Writer error) {
        return SftpSupport.getInstance(execEnv).downloadFile(srcFileName, dstFileName, error);
    }

    private SftpSupport(ExecutionEnvironment execEnv) {
        this.execEnv = execEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelSftp getChannel() throws IOException, CancellationException, JSchException, ExecutionException, InterruptedException {
        Object object = this.channelLock;
        synchronized (object) {
            if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
                this.channel = null;
                ConnectionManager.getInstance().connectTo(this.execEnv);
            }
            if (this.channel != null && !this.channel.isConnected()) {
                this.channel = null;
            }
            if (this.channel == null) {
                ConnectionManagerAccessor cmAccess = ConnectionManagerAccessor.getDefault();
                if (cmAccess == null) {
                    throw new ExecutionException("Error getting ConnectionManagerAccessor", new NullPointerException());
                }
                this.channel = (ChannelSftp)cmAccess.openAndAcquireChannel(this.execEnv, "sftp", true);
                if (this.channel == null) {
                    return null;
                }
                this.channel.connect();
            }
        }
        return this.channel;
    }

    private Future<Integer> uploadFileImpl(CommonTasksSupport.UploadParameters parameters) {
        Uploader uploader = new Uploader(parameters.srcFile.getAbsolutePath(), parameters.dstExecEnv, parameters.dstFileName, parameters.mask, parameters.error, parameters.checkMd5);
        final FutureTask<Integer> ftask = new FutureTask<Integer>(uploader);
        RequestProcessor.Task requestProcessorTask = requestProcessor.create(ftask);
        if (parameters.callback != null) {
            final ChangeListener callback = parameters.callback;
            requestProcessorTask.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    callback.stateChanged(new ChangeEvent(ftask));
                }
            });
        }
        requestProcessorTask.schedule(0);
        LOG.log(Level.FINE, "{0} schedulled", uploader.getTraceName());
        return ftask;
    }

    private Future<Integer> downloadFile(String srcFileName, String dstFileName, Writer error) {
        Downloader downloader = new Downloader(srcFileName, this.execEnv, dstFileName, error);
        FutureTask<Integer> ftask = new FutureTask<Integer>(downloader);
        requestProcessor.post(ftask);
        LOG.log(Level.FINE, "{0} schedulled", downloader.getTraceName());
        return ftask;
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result;

        static {
            $SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result = new int[Md5checker.Result.values().length];
            try {
                2.$SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result[Md5checker.Result.UPTODATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result[Md5checker.Result.DIFFERS.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result[Md5checker.Result.INEXISTENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private class Downloader
    extends Worker
    implements Callable<Integer> {
        protected final String srcFileName;
        protected final String dstFileName;

        public Downloader(String srcFileName, ExecutionEnvironment execEnv, String dstFileName, Writer error) {
            super(srcFileName, execEnv, dstFileName, error);
            this.srcFileName = srcFileName;
            this.dstFileName = dstFileName;
        }

        @Override
        protected void work() throws IOException, CancellationException, JSchException, SftpException, ExecutionException, InterruptedException {
            LOG.log(Level.FINE, "{0} started", this.getTraceName());
            ChannelSftp cftp = SftpSupport.this.getChannel();
            cftp.get(this.srcFileName, this.dstFileName);
        }

        @Override
        protected String getTraceName() {
            return "Downloading " + this.execEnv + ":" + this.srcFileName + " to " + this.dstFileName;
        }
    }

    private class Uploader
    extends Worker
    implements Callable<Integer> {
        private final int mask;
        private final boolean checkMd5;
        protected final String srcFileName;
        protected final String dstFileName;

        public Uploader(String srcFileName, ExecutionEnvironment execEnv, String dstFileName, int mask, Writer error, boolean checkMd5) {
            super(srcFileName, execEnv, dstFileName, error);
            this.srcFileName = srcFileName;
            this.dstFileName = dstFileName;
            this.mask = mask;
            this.checkMd5 = checkMd5;
        }

        @Override
        protected void work() throws IOException, CancellationException, JSchException, SftpException, InterruptedException, ExecutionException {
            int slashPos;
            boolean checkDir = false;
            if (this.checkMd5) {
                LOG.log(Level.FINE, "Md5 check for {0}:{1} started", new Object[]{this.execEnv, this.dstFileName});
                Enum res = null;
                try {
                    res = new Md5checker(this.execEnv).check(new File(this.srcFileName), this.dstFileName);
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.log(Level.WARNING, "Can not perform md5 check for {0}: {1}", new Object[]{this.execEnv.getDisplayName(), ex.getMessage()});
                    res = HostInfoUtils.fileExists(this.execEnv, this.dstFileName) ? Md5checker.Result.UPTODATE : Md5checker.Result.INEXISTENT;
                }
                catch (Md5checker.CheckSumException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.FINE, "SftpSupport interrupted", ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                switch (2.$SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result[res.ordinal()]) {
                    case 1: {
                        LOG.log(Level.FINE, "{0}:{1} up to date - skipped", new Object[]{this.execEnv, this.dstFileName});
                        return;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        checkDir = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected MD5 check result: " + res);
                    }
                }
            }
            LOG.log(Level.FINE, "{0} started", this.getTraceName());
            ChannelSftp cftp = SftpSupport.this.getChannel();
            if (checkDir && (slashPos = this.dstFileName.lastIndexOf(47)) >= 0) {
                String remoteDir = this.dstFileName.substring(0, slashPos);
                CommonTasksSupport.mkDir(this.execEnv, remoteDir, this.error).get();
            }
            this.put(cftp);
            if (this.mask >= 0) {
                cftp.chmod(this.mask, this.dstFileName);
            }
            uploadCount.incrementAndGet();
        }

        private void put(ChannelSftp cftp) throws SftpException {
            int attempt = 0;
            while (true) {
                ++attempt;
                try {
                    cftp.put(this.srcFileName, this.dstFileName);
                    if (attempt > 1) {
                        LOG.log(Level.FINE, "Success on attempt {0} to copy {1} to {2}:{3} :\n", new Object[]{attempt, this.srcFileName, this.execEnv, this.dstFileName});
                    }
                    return;
                }
                catch (SftpException e) {
                    if (attempt > PUT_RETRY_COUNT) {
                        throw e;
                    }
                    String message = String.format("Error on attempt %d to copy %s to %s:%s :\n", attempt, this.srcFileName, this.execEnv, this.dstFileName);
                    LOG.log(Level.FINE, message);
                    if (attempt == 2) {
                        Logger.fullThreadDump(message);
                    }
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        @Override
        protected String getTraceName() {
            return "Uploading " + this.srcFileName + " to " + this.execEnv + ":" + this.dstFileName;
        }
    }

    private abstract class Worker
    implements Callable<Integer> {
        protected final ExecutionEnvironment execEnv;
        protected final Writer error;

        public Worker(String srcFileName, ExecutionEnvironment execEnv, String dstFileName, Writer error) {
            this.execEnv = execEnv;
            this.error = error;
        }

        protected abstract void work() throws JSchException, SftpException, IOException, CancellationException, InterruptedException, ExecutionException;

        protected abstract String getTraceName();

        @Override
        public Integer call() throws Exception {
            int rc = -1;
            try {
                this.work();
                rc = 0;
            }
            catch (JSchException ex) {
                if (ex.getMessage().contains("Received message is too long: ")) {
                    if (isUnitTest) {
                        this.logException((Exception)((Object)ex));
                    } else {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SftpSupport.class, (String)"SftpConnectionReceivedMessageIsTooLong.error.text"), 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
                    }
                    rc = 7;
                } else {
                    this.logException((Exception)((Object)ex));
                    rc = 1;
                }
            }
            catch (SftpException ex) {
                this.logException((Exception)((Object)ex));
                rc = 2;
            }
            catch (ConnectException ex) {
                this.logException(ex);
                rc = 3;
            }
            catch (InterruptedIOException ex) {
                this.logException(ex);
                rc = 4;
            }
            catch (IOException ex) {
                this.logException(ex);
                rc = 5;
            }
            catch (CancellationException ex) {
                rc = 6;
            }
            catch (ExecutionException ex) {
                this.logException(ex);
                rc = 7;
            }
            LOG.log(Level.FINE, "{0}{1}", new Object[]{this.getTraceName(), rc == 0 ? " OK" : " FAILED"});
            return rc;
        }

        protected void logException(Exception ex) {
            LOG.log(Level.INFO, "Error " + this.getTraceName(), ex);
        }
    }
}

