/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.ui.ComponentDecorator;
import org.netbeans.validation.api.ui.GroupSpecificValidationUI;
import org.netbeans.validation.api.ui.MulticastValidationUI;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationStrategy;
import org.netbeans.validation.api.ui.ValidationUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValidationGroupImpl {
    private final MulticastValidationUI ui;
    private int suspendCount;
    private final List<ValidationListener> all = new LinkedList<ValidationListener>();
    private ComponentDecorator decorator = new ComponentDecorator();
    private ValidationGroupImpl parent;

    ValidationGroupImpl(ValidationUI ... ui) {
        if (ui == null) {
            throw new NullPointerException("UI null");
        }
        this.ui = new MulticastValidationUI(new ValidationUI[0]);
        for (ValidationUI uis : ui) {
            this.ui.add(uis);
        }
    }

    ValidationGroupImpl() {
        this(new ValidationUI[0]);
    }

    ValidationUI getUI() {
        return this.ui;
    }

    boolean isSuspended() {
        return this.suspendCount > 0 || this.parent != null && this.parent.isSuspended();
    }

    void addUI(ValidationUI real) {
        if (!this.contains(real)) {
            this.ui.add(real);
        }
    }

    void removeUI(ValidationUI ui) {
        if (this.contains(ui)) {
            this.ui.remove(ui);
        }
    }

    boolean contains(ValidationUI ui) {
        return this.ui == ui || this.ui.contains(ui);
    }

    void setParent(ValidationGroupImpl group) {
        if (this.parent != null && group != null) {
            throw new IllegalStateException("Already has parent " + this.parent);
        }
        this.parent = group;
    }

    ComponentDecorator getComponentDecorator() {
        return this.decorator;
    }

    public void setComponentDecorator(ComponentDecorator decorator) {
        assert (EventQueue.isDispatchThread()) : "Not on event thread";
        if (decorator == null) {
            throw new NullPointerException("Null decorator");
        }
        this.decorator = decorator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void modifyComponents(Runnable run) {
        if (this.parent != null) {
            this.parent.modifyComponents(run);
        } else {
            ++this.suspendCount;
            try {
                run.run();
            }
            finally {
                --this.suspendCount;
                if (!this.isSuspended()) {
                    this.validateAll();
                }
            }
        }
    }

    static ValidationGroupImpl create(ValidationUI[] ui) {
        if (ui == null) {
            throw new NullPointerException();
        }
        return new ValidationGroupImpl(ui);
    }

    public final void add(JTextComponent comp, Validator<Document> validator) {
        this.add(comp, ValidationStrategy.DEFAULT, validator);
    }

    public final void add(JTextComponent comp, Validator<String> ... builtIns) {
        this.add(comp, ValidationStrategy.DEFAULT, builtIns);
    }

    public final void add(JComboBox box, Validator<ComboBoxModel> validator) {
        this.add(box, ValidationStrategy.DEFAULT, validator);
    }

    public final void add(JComboBox box, Validator<String> ... builtIns) {
        this.add(box, ValidationStrategy.DEFAULT, builtIns);
    }

    public final void add(JTextComponent comp, ValidationStrategy strategy, Validator<String> ... builtIns) {
        Validator<Document> v = Validators.forDocument(true, builtIns);
        this.add(comp, strategy, v);
    }

    public final void add(JComboBox box, ValidationStrategy strategy, Validator<String> ... builtIns) {
        Validator<ComboBoxModel> v = Validators.forComboBox(true, builtIns);
        this.add(box, strategy, v);
    }

    public final void add(AbstractButton[] buttons, Validator<ButtonModel[]> validator) {
        ButtonModel[] mdls = new ButtonModel[buttons.length];
        for (int i = 0; i < mdls.length; ++i) {
            mdls[i] = buttons[i].getModel();
        }
        this.add(mdls, validator);
    }

    public void add(ValidationListener listener) {
        if (this.parent != null) {
            this.parent.add(listener);
        } else {
            listener.setValidationGroup(this);
        }
        this.all.add(listener);
    }

    public void add(final ButtonModel[] buttons, final Validator<ButtonModel[]> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class V
        extends ValidationListener
        implements ItemListener {
            V() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                this.validate();
            }

            @Override
            public boolean validate(Problems problems) {
                if (!this.enabled(buttons)) {
                    return true;
                }
                return validator.validate(problems, null, buttons);
            }

            private boolean enabled(ButtonModel[] b) {
                ButtonModel m;
                boolean result = true;
                ButtonModel[] arr$ = b;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (result = (m = arr$[i$]).isEnabled()); ++i$) {
                }
                return result;
            }
        }
        V v = new V();
        this.add(v);
    }

    public void add(final JComboBox box, ValidationStrategy strategy, final Validator<ComboBoxModel> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        final ValidationUI problemUI = this.decorator.createDecorator(box);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class V
        extends ValidationListener
        implements ItemListener,
        FocusListener,
        PropertyChangeListener {
            V() {
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.validate();
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                this.validate();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public boolean validate(Problems globalProblems) {
                if (!box.isEnabled()) {
                    problemUI.clearProblem();
                    return true;
                }
                Problem p = Problem.NO_PROBLEM;
                Problems myProblems = new Problems();
                if (!validator.validate(myProblems, V.nameForComponent(box), box.getModel())) {
                    p = myProblems.getLeadProblem();
                    problemUI.setProblem(p);
                    globalProblems.putAll(myProblems);
                    return false;
                }
                problemUI.clearProblem();
                return true;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.validate();
            }
        }
        V v = new V();
        this.add(v);
        box.addPropertyChangeListener("enabled", v);
        switch (strategy) {
            case DEFAULT: 
            case ON_CHANGE_OR_ACTION: {
                box.addItemListener(v);
                break;
            }
            case ON_FOCUS_LOSS: {
                box.addFocusListener(v);
                break;
            }
            case INPUT_VERIFIER: {
                box.setInputVerifier(v);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void add(final JTextComponent field, ValidationStrategy strategy, final Validator<Document> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        final ValidationUI problemUI = this.decorator.createDecorator(field);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class V
        extends ValidationListener
        implements DocumentListener,
        FocusListener,
        Runnable,
        PropertyChangeListener {
            V() {
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.validate();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.removeUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(this);
                } else {
                    this.validate();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.removeUpdate(e);
            }

            @Override
            public void run() {
                this.validate();
            }

            @Override
            public boolean validate(Problems globalProblems) {
                assert (field != null) : "Field null";
                assert (ValidationGroupImpl.this.decorator != null) : "Decorator null";
                if (!field.isEnabled()) {
                    problemUI.clearProblem();
                    return true;
                }
                Problem p = Problem.NO_PROBLEM;
                Problems myProblems = new Problems();
                if (!validator.validate(myProblems, V.nameForComponent(field), field.getDocument())) {
                    p = myProblems.getLeadProblem();
                    assert (p != null) : "Problem null";
                    assert (p != Problem.NO_PROBLEM) : "A validator has returned false from validate(), but no validator has added anyproblems to the problem set.";
                    globalProblems.putAll(myProblems);
                    problemUI.setProblem(p);
                    return false;
                }
                problemUI.clearProblem();
                return true;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.validate();
            }
        }
        V v = new V();
        this.add(v);
        field.addPropertyChangeListener("enabled", v);
        switch (strategy) {
            case DEFAULT: 
            case ON_CHANGE_OR_ACTION: {
                field.getDocument().addDocumentListener(v);
                break;
            }
            case INPUT_VERIFIER: {
                field.setInputVerifier(v);
                break;
            }
            case ON_FOCUS_LOSS: {
                field.addFocusListener(v);
            }
        }
    }

    public Problem validateAll() {
        if (this.parent != null) {
            return this.parent.validateAll();
        }
        if (this.isSuspended()) {
            return null;
        }
        Problems ps = new Problems();
        for (ValidationListener vl : this.all) {
            vl.validate(ps);
        }
        Problem leadProblem = ps.getLeadProblem();
        if (leadProblem.equals(Problem.NO_PROBLEM)) {
            this.getUI().clearProblem();
        } else {
            this.getUI().setProblem(leadProblem);
        }
        return leadProblem;
    }

    Problem validationTriggered(ValidationListener trigger) {
        Problem leadProblem;
        assert (trigger != null);
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        if (this.parent != null) {
            return this.parent.validationTriggered(trigger);
        }
        if (this.isSuspended()) {
            return null;
        }
        this.all.remove(trigger);
        this.all.add(0, trigger);
        Problems groupProblems = new Problems();
        for (ValidationListener a : this.all) {
            Problem p = a.getCurrentLeadProblem();
            groupProblems.add(p);
            if (!p.isFatal()) continue;
            break;
        }
        if ((leadProblem = groupProblems.getLeadProblem()).equals(Problem.NO_PROBLEM)) {
            this.getUI().clearProblem();
        } else {
            this.getUI().setProblem(leadProblem);
        }
        return leadProblem;
    }

    public void addValidationGroup(ValidationGroupImpl group, boolean useUI) {
        assert (EventQueue.isDispatchThread()) : "Not in event thread";
        assert (this.noOverlap(this.all, group.all));
        if (group.parent != null) {
            throw new IllegalStateException("Cannot add to a group that has already been added to another group");
        }
        this.all.addAll(group.all);
        for (ValidationListener l : this.all) {
            l.setValidationGroup(this);
        }
        if (useUI) {
            this.addUI(new GroupSpecificValidationUI(group, group.ui));
        } else {
            group.ui.clearProblem();
        }
        group.setParent(this);
        this.validateAll();
    }

    public void removeValidationGroup(ValidationGroupImpl group) {
        assert (EventQueue.isDispatchThread()) : "Not in event thread";
        if (group == this) {
            throw new IllegalArgumentException("Removing from self");
        }
        this.all.removeAll(group.all);
        for (ValidationListener l : group.all) {
            l.setValidationGroup(group);
        }
        this.ui.removeUI(group);
        group.setParent(null);
        this.validateAll();
    }

    private boolean noOverlap(List<ValidationListener> all, List<ValidationListener> all0) {
        HashSet<ValidationListener> s = new HashSet<ValidationListener>();
        s.addAll(all);
        s.addAll(all0);
        return s.size() == all.size() + all0.size();
    }
}

