/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.debugger.common2.utils.Catalog;
import org.netbeans.modules.cnd.debugger.common2.utils.ItemSelectorResult;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public final class ItemSelectorDialog
extends JPanel
implements ActionListener {
    private int nitems = 0;
    private boolean multiple_selections;
    private JButton selectAllButton = null;
    private JButton clearButton = null;
    private JButton invertButton = null;
    private JList list = null;
    private JButton okButton;
    private JButton cancelButton;
    private boolean okPressed = false;
    private int[] selected_indices = null;
    private boolean cancelled = false;

    public ItemSelectorResult getResult() {
        if (this.cancelled) {
            return ItemSelectorResult.cancelled();
        }
        return ItemSelectorResult.select(this.selected_indices);
    }

    public void showWindow(String title, int nitems, String[] item, boolean cancelable, boolean multiple_selections) {
        this.nitems = nitems;
        this.multiple_selections = multiple_selections;
        this.setPreferredSize(new Dimension(600, 300));
        this.setBorder(new EmptyBorder(10, 10, 0, 10));
        this.setLayout(new BorderLayout());
        this.list = new JList<String>(item);
        this.list.setSelectionMode(multiple_selections ? 2 : 0);
        Catalog.setAccessibleName(this.list, "ACSN_OverloadList");
        Catalog.setAccessibleDescription(this.list, "ACSD_OverloadList");
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ItemSelectorDialog.this.doubleClicked(evt);
            }
        });
        JScrollPane scroll_pane = new JScrollPane(this.list);
        this.add((Component)scroll_pane, "Center");
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        JLabel jl = new JLabel(title);
        jl.setBorder(new EmptyBorder(5, 5, 5, 5));
        topPanel.add((Component)jl, "North");
        JPanel selControls = new JPanel();
        selControls.setBorder(new EmptyBorder(0, 0, 5, 0));
        topPanel.add((Component)selControls, "South");
        this.selectAllButton = new JButton();
        this.selectAllButton.setText(Catalog.get("CTL_SelectAll"));
        this.selectAllButton.setMnemonic(Catalog.getMnemonic("MNEM_SelectAll"));
        Catalog.setAccessibleDescription(this.selectAllButton, "ACSD_SelectAll");
        this.selectAllButton.addActionListener(this);
        selControls.add(this.selectAllButton);
        this.clearButton = new JButton();
        this.clearButton.setText(Catalog.get("CTL_Clear"));
        this.clearButton.setMnemonic(Catalog.getMnemonic("MNEM_Clear"));
        Catalog.setAccessibleDescription(this.clearButton, "ACSD_Clear");
        this.clearButton.addActionListener(this);
        selControls.add(this.clearButton);
        this.invertButton = new JButton();
        this.invertButton.setText(Catalog.get("CTL_Invert"));
        this.invertButton.setMnemonic(Catalog.getMnemonic("MNEM_Invert"));
        Catalog.setAccessibleDescription(this.invertButton, "ACSD_Invert");
        this.invertButton.addActionListener(this);
        selControls.add(this.invertButton);
        this.add((Component)topPanel, "North");
        DialogDescriptor dlg = new DialogDescriptor((Object)this, Catalog.get("TTL_OverloadDialog"), true, (ActionListener)this);
        this.okButton = new JButton(Catalog.get("CTL_OK"));
        Catalog.setAccessibleDescription(this.okButton, "ACSD_OK");
        this.cancelButton = new JButton(Catalog.get("CTL_Cancel"));
        Catalog.setAccessibleDescription(this.cancelButton, "ACSD_Cancel");
        dlg.setOptions((Object[])new JButton[]{this.okButton, this.cancelButton});
        dlg.setClosingOptions(dlg.getOptions());
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ItemSelectorDialog.this.sensitizeButtons();
            }
        });
        this.sensitizeButtons();
        if (!multiple_selections) {
            this.list.setSelectedIndex(0);
        }
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        Catalog.setAccessibleDescription(dialog, "ACSD_Overload");
        dialog.setVisible(true);
        int selected_item = this.list.getSelectedIndex();
        if (!cancelable && selected_item == -1) {
            this.showWindow(title, nitems, item, cancelable, multiple_selections);
            return;
        }
        if (this.okPressed) {
            this.selected_indices = this.list.getSelectedIndices();
            this.cancelled = false;
        } else {
            this.selected_indices = null;
            this.cancelled = true;
        }
    }

    private void doubleClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.selected_indices = this.list.getSelectedIndices();
            this.okPressed = true;
            this.cancelled = false;
            for (Container c = this; c != null; c = c.getParent()) {
                if (!(c instanceof JDialog)) continue;
                JDialog d = (JDialog)c;
                d.setVisible(false);
                d.dispose();
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.okPressed = true;
        } else if (actionEvent.getSource() == this.selectAllButton) {
            int[] indices = new int[this.nitems];
            for (int i = 0; i < this.nitems; ++i) {
                indices[i] = i;
            }
            this.list.setSelectedIndices(indices);
        } else if (actionEvent.getSource() == this.clearButton) {
            this.list.setSelectedIndices(new int[0]);
            this.selectAllButton.requestFocusInWindow();
        } else if (actionEvent.getSource() == this.invertButton) {
            int[] selected = this.list.getSelectedIndices();
            int numSelected = selected.length;
            int[] indices = new int[this.nitems - numSelected];
            int next = 0;
            for (int i = 0; i < this.nitems; ++i) {
                boolean isSelected = false;
                for (int j = 0; j < numSelected; ++j) {
                    if (selected[j] != i) continue;
                    isSelected = true;
                    break;
                }
                if (isSelected) continue;
                indices[next++] = i;
            }
            assert (next == this.nitems - numSelected);
            this.list.setSelectedIndices(indices);
        }
    }

    private void sensitizeButtons() {
        int[] selected = this.list.getSelectedIndices();
        this.okButton.setEnabled(selected.length > 0);
        if (!this.multiple_selections) {
            this.selectAllButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.invertButton.setEnabled(false);
            return;
        }
        if (selected.length == 0) {
            this.selectAllButton.setEnabled(true);
            this.clearButton.setEnabled(false);
            this.invertButton.setEnabled(false);
        } else if (selected.length == this.nitems) {
            this.selectAllButton.setEnabled(false);
            this.clearButton.setEnabled(true);
            this.invertButton.setEnabled(false);
        } else {
            this.selectAllButton.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.invertButton.setEnabled(true);
        }
    }
}

