/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.remote;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHost;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.DetailView;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.DummyPropertySheet;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostPanel
extends DetailView<CustomizableHost> {
    private CustomizableHost original;
    private CustomizableHost editable;
    private final JPanel execControlsPanel = new JPanel();
    private final DummyPropertySheet.Listener listener = new DummyPropertySheet.Listener(){

        public void propertyChanged() {
            HostPanel.this.setDirty(true);
        }
    };
    private final DummyPropertySheet propertySheet = new DummyPropertySheet(Catalog.get("REMOTE_DIALOG_GUIDANCE_TXT"), this.listener);
    private boolean dirty;
    private boolean updating;
    private GridBagConstraints gridBagConstraints;

    public HostPanel(CustomizableHost host) {
        if (host != null) {
            this.original = host;
            PasswordManager pm = PasswordManager.getInstance();
            this.original.setRememberPassword(pm.isRememberPassword(this.original.executionEnvironment()));
        } else {
            this.original = new CustomizableHost();
        }
        this.editable = this.original.cloneRecord();
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 0));
        this.execControlsPanel.setLayout(new GridBagLayout());
        this.execControlsPanel.setPreferredSize(new Dimension(600, 300));
        this.execControlsPanel.setBorder(new EtchedBorder());
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.gridwidth = 3;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.insets = new Insets(0, 4, 8, 12);
        this.execControlsPanel.add((Component)((Object)this.propertySheet), this.gridBagConstraints);
        this.add((Component)this.execControlsPanel, "Center");
    }

    @Override
    public void setRecord(CustomizableHost newhost) {
        this.original = newhost;
        if (this.original != null) {
            PasswordManager pm = PasswordManager.getInstance();
            this.original.setRememberPassword(pm.isRememberPassword(this.original.executionEnvironment()));
            this.editable = this.original.cloneRecord();
        } else {
            this.editable = new CustomizableHost();
        }
        this.updateView();
        this.setDirty(false);
    }

    @Override
    public void commit() {
        if (this.original != null) {
            this.original.assign(this.editable);
            PasswordManager pm = PasswordManager.getInstance();
            pm.setRememberPassword(this.original.executionEnvironment(), this.original.isRememberPassword());
        }
        this.setDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateView() {
        this.updating = true;
        try {
            this.propertySheet.update(this.editable.getSheet());
        }
        finally {
            this.updating = false;
        }
    }

    public void validateFields(DocumentEvent documentEvent) {
        this.setDirty(true);
    }

    @Override
    public boolean isRecordValid() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty || this.editable.getOptions().isDirty();
    }

    private void setDirty(boolean dirty) {
        if (this.updating) {
            return;
        }
        if (!dirty) {
            this.editable.getOptions().clearDirty();
        }
        this.dirty = dirty;
        this.fireChanged();
    }

    protected HelpCtx getHelpCtx() {
        return new HelpCtx("RemoteHost");
    }

    public class ModifiedValidateDocumentListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            HostPanel.this.validateFields(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            HostPanel.this.validateFields(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            HostPanel.this.validateFields(documentEvent);
        }
    }
}

