/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.assembly;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Catalog;
import org.netbeans.spi.viewmodel.Models;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryWindow
extends TopComponent
implements ActionListener {
    static final String preferredID = "MemoryWindow";
    static MemoryWindow DEFAULT;
    private transient JComponent tree = null;
    private String name;
    private String view_name;
    private NativeDebugger debugger = null;
    private JMenuItem menuItemFollowSelectedPointer;
    private JPopupMenu popup;
    private JTextArea ta;
    private JScrollPane ta_sp;
    private JPanel controlPanel;
    private ArrayList<String> current_addrs;
    private PopupListener popupListener;
    private String memory_start;
    private String memory_length;
    private JTextField controlLengthText;
    private String[] memory_formats = new String[]{Catalog.get("L_Hexadecimal"), Catalog.get("l_Hexadecimal"), Catalog.get("w_Hexadecimal"), Catalog.get("l_Decimal"), Catalog.get("l_Octal"), Catalog.get("L_Float"), Catalog.get("l_Float"), Catalog.get("L_Instructions"), Catalog.get("L_Characters"), Catalog.get("L_WideCharacters")};
    private String[] short_memory_formats = new String[]{"lX", "X", "x", "D", "O", "F", "f", "i", "c", "w"};
    private JComboBox controlFormatCombo;
    private FormatListener format_listener;
    private int memory_format = 1;
    private boolean needInitData = true;
    private JComboBox controlAddressCombo;
    private String selected_text = null;

    public static TopComponent getDefault() {
        MemoryWindow tc;
        if (DEFAULT == null && (tc = (MemoryWindow)WindowManager.getDefault().findTopComponent(preferredID)) == null) {
            new MemoryWindow();
        }
        return DEFAULT;
    }

    public MemoryWindow() {
        this.name = Catalog.get("TITLE_MemoryWindow");
        this.view_name = Catalog.get("TITLE_MemoryView");
        super.setName(this.name);
        DEFAULT = this;
        String iconDir = "org/netbeans/modules/cnd/debugger/common2/icons/";
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/debugger/common2/icons/memory_browser.png"));
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.connectToDebugger(DebuggerManager.get().currentDebugger());
        this.needInitData = true;
        this.updateWindow();
    }

    protected void componentHidden() {
        if (this.debugger != null) {
            this.debugger.registerMemoryWindow(null);
        }
        super.componentHidden();
    }

    protected void componentClosed() {
        if (this.debugger != null) {
            this.debugger.registerMemoryWindow(null);
        }
        super.componentClosed();
    }

    public void requestActive() {
        super.requestActive();
        this.controlAddressCombo.requestFocusInWindow();
    }

    public void setControlPanelData(String start, String length, int index) {
        this.memory_start = start;
        this.memory_length = length;
        this.memory_format = index;
        this.controlAddressCombo.getEditor().setItem(start);
        this.controlLengthText.setText(length);
        this.controlFormatCombo.setSelectedIndex(index);
    }

    public void setDebugger(NativeDebugger debugger) {
        this.debugger = debugger;
    }

    protected void connectToDebugger(NativeDebugger debugger) {
        this.debugger = debugger;
        if (debugger == null) {
            return;
        }
        debugger.registerMemoryWindow(this);
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return this.view_name;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String ac = actionEvent.getActionCommand();
        if (ac.equals("comboBoxChanged")) {
            JComboBox cb = (JComboBox)actionEvent.getSource();
            this.memory_start = (String)cb.getSelectedItem();
        }
        this.updateMems();
    }

    boolean validate(String length) {
        if (this.memory_start == null) {
            return false;
        }
        if (length == null) {
            return false;
        }
        return this.memory_start.length() != 0 && length.length() != 0;
    }

    private void updateMems() {
        this.memory_length = this.controlLengthText.getText();
        this.memory_format = this.controlFormatCombo.getSelectedIndex();
        if (this.validate(this.memory_length) && this.debugger != null) {
            this.debugger.requestMems(this.memory_start, this.memory_length, this.short_memory_formats[this.memory_format], this.memory_format);
        }
    }

    private int addrMap(String addr) {
        for (int i = 0; i < this.controlAddressCombo.getItemCount(); ++i) {
            if (!addr.equals((String)this.controlAddressCombo.getItemAt(i))) continue;
            return i;
        }
        return -1;
    }

    public void updateData(List<String> memLines) {
        if (memLines == null || memLines.isEmpty()) {
            return;
        }
        int index = this.addrMap(this.memory_start);
        if (index == -1) {
            this.controlAddressCombo.addItem(this.memory_start);
        }
        this.current_addrs.clear();
        this.current_addrs.addAll(memLines);
        this.updateWindow();
    }

    public String align_memvalue(String memvalue) {
        if (this.memory_format == 3 || this.memory_format == 4) {
            int total_len = memvalue.length();
            int j = memvalue.indexOf(58, 0);
            String new_memvalue = "";
            if (j >= 0) {
                new_memvalue = memvalue.substring(0, ++j);
            } else {
                j = 0;
            }
            for (int i = 0; i < 4; ++i) {
                char c;
                while (j < total_len && ((c = memvalue.charAt(j)) == ' ' || c == '\t')) {
                    new_memvalue = new_memvalue + " ";
                    ++j;
                }
                if (total_len <= j) break;
                String value = "";
                int valuelen = 0;
                int maxvaluelen = 12;
                if (this.memory_format == 3) {
                    if (memvalue.charAt(j) == '-') {
                        value = "-";
                        ++j;
                    } else {
                        value = "+";
                    }
                    valuelen = 1;
                    maxvaluelen = 11;
                }
                while (j < total_len && (c = memvalue.charAt(j)) >= '0' && c <= '9') {
                    value = value + c;
                    ++valuelen;
                    ++j;
                }
                if (valuelen > maxvaluelen) {
                    return memvalue;
                }
                while (valuelen < maxvaluelen) {
                    value = " " + value;
                    ++valuelen;
                }
                new_memvalue = new_memvalue + value;
            }
            return new_memvalue;
        }
        return memvalue;
    }

    private void updateWindow() {
        if (this.tree == null) {
            this.ta = new JTextArea();
            this.ta_sp = new JScrollPane(this.ta);
            this.current_addrs = new ArrayList();
            this.setLayout(new BorderLayout());
            this.tree = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
            this.tree.setName(this.view_name);
            this.ta.setEditable(false);
            this.ta.setWrapStyleWord(false);
            Font f = this.ta.getFont();
            this.ta.setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
            this.memory_start = "main";
            this.memory_length = "80";
            this.memory_format = 1;
            this.controlPanel = new JPanel(new GridBagLayout());
            this.controlPanel.setToolTipText(Catalog.get("TIP_MemControlPanel"));
            this.controlAddressCombo = new JComboBox();
            this.controlAddressCombo.addItem(this.memory_start);
            this.controlAddressCombo.setEditable(true);
            this.controlAddressCombo.addActionListener(this);
            JLabel controlAddressLabel = new JLabel(Catalog.get("Mem_LBL_Address"));
            controlAddressLabel.setToolTipText(Catalog.get("TIP_MemAddress"));
            JLabel controlLengthLabel = new JLabel(Catalog.get("Mem_LBL_Length"));
            controlLengthLabel.setToolTipText(Catalog.get("TIP_MemLength"));
            this.controlLengthText = new JTextField(6);
            this.controlLengthText.setText(this.memory_length);
            this.controlLengthText.addActionListener(this);
            JLabel controlFormatLabel = new JLabel(Catalog.get("Mem_LBL_Format"));
            controlFormatLabel.setToolTipText(Catalog.get("TIP_MemFormat"));
            this.format_listener = new FormatListener();
            this.controlFormatCombo = new JComboBox<String>(this.memory_formats);
            this.controlFormatCombo.setSelectedIndex(this.memory_format);
            this.controlFormatCombo.addActionListener(this.format_listener);
            int gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 0, 8, 0);
            this.controlPanel.add((Component)controlAddressLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            gridBagConstraints.weightx = 1.0;
            this.controlPanel.add((Component)this.controlAddressCombo, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.controlPanel.add((Component)controlLengthLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.controlPanel.add((Component)this.controlLengthText, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.controlPanel.add((Component)controlFormatLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.controlPanel.add((Component)this.controlFormatCombo, gridBagConstraints);
            this.tree.add((Component)this.ta_sp, "Center");
            this.tree.add((Component)this.controlPanel, "South");
            AccessibleContext ac = this.tree.getAccessibleContext();
            ac.setAccessibleDescription(Catalog.get("ACSD_MemoryView"));
            ac.setAccessibleName(Catalog.get("TITLE_MemoryView"));
            this.add(this.tree, "Center");
            this.popup = new JPopupMenu();
            this.popupListener = new PopupListener(this.popup);
            this.menuItemFollowSelectedPointer = new JMenuItem(new FollowSelectedPointerAction());
            this.popup.add(this.menuItemFollowSelectedPointer);
            this.popup.add(new RefreshMemoryAction());
            this.ta.addMouseListener(this.popupListener);
            this.ta.setText(null);
            this.ta.setCaretPosition(0);
        }
        if (this.needInitData) {
            this.needInitData = false;
            this.updateMems();
        }
        int carpos = this.ta.getCaretPosition();
        this.ta.setText(null);
        this.ta.setCaretPosition(0);
        for (String line : this.current_addrs) {
            this.ta.append(line);
        }
        try {
            this.ta.setCaretPosition(carpos);
        }
        catch (IllegalArgumentException e) {
            this.ta.setCaretPosition(0);
        }
        this.invalidate();
    }

    protected void FollowSelectedPointer(String s) {
        int i;
        for (i = 0; i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t'); ++i) {
        }
        if (i > 0 && i < s.length()) {
            s = s.substring(i);
        }
        for (i = 0; i < s.length() && s.charAt(i) != ':' && s.charAt(i) != ';' && s.charAt(i) != ' ' && s.charAt(i) != '\t'; ++i) {
        }
        if (i > 0 && i < s.length()) {
            s = s.substring(0, i);
        }
        if (s.length() > 0) {
            this.memory_start = s;
        }
        this.updateMems();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("MemoryBrowserWindow");
    }

    class RefreshMemoryAction
    extends AbstractAction {
        public RefreshMemoryAction() {
            super(Catalog.get("Mem_ACT_Refresh"), new ImageIcon("paste.gif"));
        }

        public void actionPerformed(ActionEvent ev) {
            String s = (String)MemoryWindow.this.controlAddressCombo.getEditor().getItem();
            if (s.length() > 0) {
                MemoryWindow.this.memory_start = s;
            }
            MemoryWindow.this.updateMems();
        }
    }

    class FollowSelectedPointerAction
    extends AbstractAction {
        public FollowSelectedPointerAction() {
            super(Catalog.get("Mem_ACT_Follow_Selected_Pointer"), new ImageIcon("paste.gif"));
        }

        public void actionPerformed(ActionEvent ev) {
            MemoryWindow.this.FollowSelectedPointer(MemoryWindow.this.selected_text);
        }
    }

    class PopupListener
    extends MouseAdapter
    implements ActionListener,
    PopupMenuListener {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MemoryWindow.this.selected_text = MemoryWindow.this.ta.getSelectedText();
                if (MemoryWindow.this.selected_text == null) {
                    MemoryWindow.this.menuItemFollowSelectedPointer.setEnabled(false);
                } else {
                    MemoryWindow.this.menuItemFollowSelectedPointer.setEnabled(true);
                }
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void actionPerformed(ActionEvent ev) {
            JMenuItem source = (JMenuItem)ev.getSource();
            String s = source.getText();
            for (int i = 0; i < MemoryWindow.this.memory_formats.length; ++i) {
                if (!MemoryWindow.this.memory_formats[i].equals(s)) continue;
                MemoryWindow.this.memory_format = i;
                MemoryWindow.this.controlFormatCombo.setSelectedIndex(i);
                MemoryWindow.this.updateMems();
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private class FormatListener
    implements ActionListener {
        private FormatListener() {
        }

        public void actionPerformed(ActionEvent ev) {
            String ac = ev.getActionCommand();
            if (ac.equals("comboBoxChanged")) {
                JComboBox cb = (JComboBox)ev.getSource();
                String s = (String)cb.getSelectedItem();
                for (int i = 0; i < MemoryWindow.this.memory_formats.length; ++i) {
                    if (!MemoryWindow.this.memory_formats[i].equals(s)) continue;
                    MemoryWindow.this.memory_format = i;
                    MemoryWindow.this.controlFormatCombo.setSelectedIndex(i);
                    MemoryWindow.this.updateMems();
                }
            }
        }
    }
}

