/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class EditorBridge {
    private static JEditorPane lastEditorPane = null;

    private static TopComponent getActiveEditor() {
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated instanceof CloneableEditorSupport.Pane && activated.isShowing()) {
            return activated;
        }
        return null;
    }

    private static TopComponent getActiveEditorSafe() {
        if (SwingUtilities.isEventDispatchThread()) {
            return EditorBridge.getActiveEditor();
        }
        final TopComponent[] tc = new TopComponent[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    tc[0] = EditorBridge.getActiveEditor();
                }
            });
        }
        catch (Exception e) {
            return null;
        }
        return tc[0];
    }

    private static DataObject getDataObject() {
        TopComponent tc = EditorBridge.getActiveEditorSafe();
        if (tc == null) {
            return null;
        }
        DataObject dobj = (DataObject)tc.getLookup().lookup(DataObject.class);
        if (dobj != null && dobj.isValid()) {
            return dobj;
        }
        return null;
    }

    private static EditorCookie getCurrentEditorCookie() {
        DataObject dao = EditorBridge.getDataObject();
        if (dao == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)dao.getCookie(EditorCookie.class);
        return ec;
    }

    private static JEditorPane getCurrentEditor(EditorCookie e) {
        if (e == null) {
            e = EditorBridge.getCurrentEditorCookie();
        }
        if (e == null) {
            return null;
        }
        JEditorPane[] op = e.getOpenedPanes();
        if (op == null || op.length < 1) {
            return null;
        }
        return op[0];
    }

    private static DataObject dataObjectForLine(Line l) {
        if (l == null) {
            return null;
        }
        Lookup lineLookup = l.getLookup();
        DataObject dao = (DataObject)lineLookup.lookup(DataObject.class);
        if (dao == null) {
            return null;
        }
        if (dao instanceof DataShadow) {
            dao = ((DataShadow)dao).getOriginal();
        }
        return dao;
    }

    public static String filenameFor(Line l) {
        DataObject dao = EditorBridge.dataObjectForLine(l);
        if (dao == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)dao.getPrimaryFile()).getPath();
    }

    public static Line getCurrentLine() {
        EditorCookie e = EditorBridge.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane ep = EditorBridge.getCurrentEditor(e);
        if (ep == null) {
            return null;
        }
        StyledDocument d = e.getDocument();
        if (d == null) {
            return null;
        }
        int lineNo = NbDocument.findLineNumber((StyledDocument)d, (int)ep.getCaret().getDot());
        Line l = null;
        try {
            l = e.getLineSet().getCurrent(lineNo + 1);
        }
        catch (IndexOutOfBoundsException x) {
            // empty catch block
        }
        return l;
    }

    public static String getCurrentSelection() {
        JEditorPane ep = EditorBridge.getCurrentEditor(null);
        if (ep == null) {
            return null;
        }
        String s = ep.getSelectedText();
        if (s == null) {
            return null;
        }
        return s;
    }

    private static DataObject dataObjectFor(FileObject fo) {
        if (fo == null) {
            return null;
        }
        DataObject dao = null;
        try {
            dao = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return dao;
    }

    public static Line lineNumberToLine(DataObject dao, int lineNumber) throws Exception {
        Line l;
        Line.Set ls;
        LineCookie lc = (LineCookie)dao.getCookie(LineCookie.class);
        if (lc != null && (ls = lc.getLineSet()) != null && (l = ls.getCurrent(lineNumber - 1)) != null) {
            return l;
        }
        throw new Exception();
    }

    public static Line getLine(String fileName, int lineNumber) {
        FileObject fo;
        DataObject dao;
        if (Log.Editor.debug) {
            System.out.printf("getline(\"%s\", %d)\n", fileName, lineNumber);
        }
        if ((dao = EditorBridge.dataObjectFor(fo = IpeUtils.findFileObject(fileName))) == null) {
            if (Log.Editor.debug) {
                System.out.printf("\tno DAO\n", new Object[0]);
            }
            return null;
        }
        try {
            return EditorBridge.lineNumberToLine(dao, lineNumber);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void showInEditor(Line line) {
        if (line == null) {
            return;
        }
        try {
            line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FRONT);
            if (DebuggerOption.FRONT_IDE.isEnabled(DebuggerManager.get().globalOptions())) {
                WindowManager.getDefault().getMainWindow().toFront();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showInEditor(String fileName, int lineNumber) {
        if (Log.Editor.debug) {
            System.out.printf("showInEditor(\"%s\", %d)\n", fileName, lineNumber);
        }
        EditorBridge.showInEditor(EditorBridge.getLine(fileName, lineNumber));
    }

    public static boolean saveFile(String fileName) {
        FileObject fo = IpeUtils.findFileObject(fileName);
        DataObject dao = EditorBridge.dataObjectFor(fo);
        if (dao == null) {
            return false;
        }
        EditorCookie ec = (EditorCookie)dao.getCookie(EditorCookie.class);
        if (ec == null) {
            return false;
        }
        try {
            ec.saveDocument();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static Date lastModified(Line line) {
        DataObject dao = EditorBridge.dataObjectForLine(line);
        if (dao == null) {
            return new Date();
        }
        FileObject fo = dao.getPrimaryFile();
        if (fo == null) {
            return new Date();
        }
        return fo.lastModified();
    }

    public static void setStatus(String msg) {
        EditorUI ui;
        JEditorPane ep = EditorBridge.getCurrentEditor(null);
        if (lastEditorPane != null && lastEditorPane != ep && (ui = Utilities.getEditorUI((JTextComponent)lastEditorPane)) != null) {
            Utilities.clearStatusText((JTextComponent)lastEditorPane);
        }
        lastEditorPane = ep;
        if (ep == null) {
            return;
        }
        if (msg != null) {
            Coloring coloring = new Coloring();
            coloring = Coloring.changeForeColor((Coloring)coloring, (Color)new Color(1.0f, 0.0f, 0.0f));
            Utilities.setStatusText((JTextComponent)ep, (String)msg, (Coloring)coloring);
        } else {
            Utilities.clearStatusText((JTextComponent)ep);
        }
    }

    public static StyledDocument documentFor(String pathname) {
        if (IpeUtils.isEmpty(pathname)) {
            return null;
        }
        File docFile = new File(pathname);
        if (!docFile.exists()) {
            return null;
        }
        FileObject fo = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)docFile));
        if (fo == null || !fo.isValid()) {
            return null;
        }
        DataObject dob = null;
        try {
            dob = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (dob == null || !dob.isValid()) {
            return null;
        }
        EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        StyledDocument document = ec.getDocument();
        return document;
    }
}

