/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.openide.util.Exceptions;

public class BackwardCompatibilityWithMevenideChecker
implements PrerequisitesChecker {
    private static Logger LOG = Logger.getLogger(BackwardCompatibilityWithMevenideChecker.class.getName());

    @Override
    public boolean checkRunConfig(RunConfig config) {
        String[] gls = config.getGoals().toArray(new String[0]);
        boolean changed = false;
        for (int i = 0; i < gls.length; ++i) {
            if (gls[i].startsWith("org.codehaus.mevenide:netbeans-deploy-plugin")) {
                gls[i] = null;
                config.setProperty("netbeans.deploy", "true");
                changed = true;
                LOG.info("Dynamically removing netbeans-deploy-plugin goal from execution. No longer supported.");
                continue;
            }
            if (gls[i].startsWith("org.codehaus.mevenide:netbeans-nbmreload-plugin")) {
                gls[i] = null;
                LOG.info("Dynamically removing netbeans-nbmreload-plugin goal from execution. No longer supported.");
                changed = true;
                continue;
            }
            if (gls[i].startsWith("org.codehaus.mevenide:netbeans-run-plugin")) {
                gls[i] = null;
                LOG.info("Dynamically removing netbeans-run-plugin goal from execution. No longer supported.");
                changed = true;
                continue;
            }
            if (!gls[i].startsWith("org.codehaus.mevenide:netbeans-debugger-plugin")) continue;
            gls[i] = null;
            LOG.info("Dynamically removing netbeans-debugger-plugin goal from execution. No longer supported.");
            changed = true;
        }
        if (changed) {
            List<String> lst = config.getGoals();
            try {
                lst.clear();
                lst.addAll(Arrays.asList(gls));
                lst.remove(null);
            }
            catch (UnsupportedOperationException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        return true;
    }
}

