/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public final class EndorsedClassPathImpl
implements ClassPathImplementation,
FileChangeListener {
    private List<? extends PathResourceImplementation> resourcesCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final NbMavenProjectImpl project;
    private BootClassPathImpl bcp;
    private String[] current;
    private final File endorsed;
    private final Set<URL> djpbcp = new HashSet<URL>();

    EndorsedClassPathImpl(NbMavenProjectImpl project) {
        this.project = project;
        this.endorsed = new File(project.getPOMFile().getParentFile(), "target/endorsed");
        FileUtil.addFileChangeListener((FileChangeListener)this, (File)this.endorsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends PathResourceImplementation> getResources() {
        assert (this.bcp != null);
        Object object = this.bcp.LOCK;
        synchronized (object) {
            if (this.resourcesCache == null) {
                File[] jars;
                ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
                String[] boot = this.getBootClasspath();
                if (boot != null) {
                    for (URL u : this.stripDefaultJavaPlatform(boot)) {
                        result.add(ClassPathSupport.createResource((URL)u));
                    }
                }
                if ((jars = this.endorsed.listFiles()) != null) {
                    for (File jar : jars) {
                        result.add(ClassPathSupport.createResource((URL)FileUtil.urlForArchiveOrDir((File)jar)));
                    }
                }
                this.current = boot;
                this.resourcesCache = Collections.unmodifiableList(result);
            }
            return this.resourcesCache;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private String[] getBootClasspath() {
        String carg2;
        Properties cargs;
        String carg = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArgument", "compile");
        if (carg != null) {
            // empty if block
        }
        if ((cargs = PluginPropertyUtils.getPluginPropertyParameter(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArguments", "compile")) != null && (carg2 = cargs.getProperty("bootclasspath")) != null) {
            return StringUtils.split((String)carg2, (String)File.pathSeparator);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resetCache() {
        Object[] newones = this.getBootClasspath();
        boolean fire = false;
        assert (this.bcp != null);
        Object object = this.bcp.LOCK;
        synchronized (object) {
            if (!Arrays.equals(newones, this.current)) {
                this.resourcesCache = null;
                fire = true;
            }
        }
        if (fire) {
            this.support.firePropertyChange("resources", null, null);
        }
        return fire;
    }

    void setBCP(BootClassPathImpl aThis) {
        this.bcp = aThis;
    }

    private List<URL> stripDefaultJavaPlatform(String[] boot) {
        ArrayList<URL> toRet = new ArrayList<URL>();
        Set<URL> defs = this.getDefJavaPlatBCP();
        for (String s : boot) {
            File f = FileUtilities.convertStringToFile(s);
            URL entry = FileUtil.urlForArchiveOrDir((File)f);
            if (entry == null || defs.contains(entry)) continue;
            toRet.add(entry);
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<URL> getDefJavaPlatBCP() {
        Set<URL> set = this.djpbcp;
        synchronized (set) {
            if (this.djpbcp.size() == 0) {
                JavaPlatformManager mngr = JavaPlatformManager.getDefault();
                JavaPlatform jp = mngr.getDefaultPlatform();
                ClassPath cp = jp.getBootstrapLibraries();
                for (ClassPath.Entry ent : cp.entries()) {
                    this.djpbcp.add(ent.getURL());
                }
            }
            return Collections.unmodifiableSet(this.djpbcp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileChange() {
        assert (this.bcp != null);
        Object object = this.bcp.LOCK;
        synchronized (object) {
            this.resourcesCache = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }

    public void fileFolderCreated(FileEvent fe) {
        this.fileChange();
    }

    public void fileDataCreated(FileEvent fe) {
        this.fileChange();
    }

    public void fileChanged(FileEvent fe) {
        this.fileChange();
    }

    public void fileDeleted(FileEvent fe) {
        this.fileChange();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.fileChange();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }
}

