/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class CPExtender
extends ProjectClassPathModifierImplementation
implements ProjectClassPathExtender {
    private NbMavenProjectImpl project;
    private static final String POM_XML = "pom.xml";
    public static final String CLASSPATH_COMPILE_ONLY = "classpath/compile_only";

    public CPExtender(NbMavenProjectImpl project) {
        this.project = project;
    }

    public boolean addLibrary(final Library library) throws IOException {
        final Boolean[] added = new Boolean[1];
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                try {
                    added[0] = CPExtender.this.addLibrary(library, model, null);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    added[0] = Boolean.FALSE;
                }
            }
        };
        FileObject pom = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
        if (added[0].booleanValue()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
        return added[0];
    }

    public boolean addArchiveFile(FileObject arch) throws IOException {
        final FileObject file = FileUtil.getArchiveFile((FileObject)arch);
        if (file.isFolder()) {
            throw new IOException("Cannot add folders to Maven projects as dependencies: " + file.getURL());
        }
        final Boolean[] added = new Boolean[1];
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                try {
                    added[0] = CPExtender.this.addArchiveFile(file, model, null);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    added[0] = Boolean.FALSE;
                }
            }
        };
        FileObject pom = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
        if (added[0].booleanValue()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
        return added[0];
    }

    private boolean addLibrary(Library library, POMModel model, String scope) throws IOException {
        boolean added = this.checkLibraryForPoms(library, model, scope);
        if (!added) {
            List urls = library.getContent("classpath");
            boolean bl = added = urls.size() > 0;
            assert (model != null);
            for (URL url : urls) {
                FileObject fo = URLMapper.findFileObject((URL)FileUtil.getArchiveFile((URL)url));
                if (fo == null) {
                    throw new IOException("Could find no file corresponding to " + url);
                }
                if (fo.isFolder()) {
                    throw new IOException("Cannot add folders to Maven projects as dependencies: " + fo.getURL());
                }
                added = added && this.addArchiveFile(fo, model, scope);
            }
        }
        return added;
    }

    private boolean addArchiveFile(FileObject file, POMModel mdl, String scope) throws IOException {
        String[] dep = this.checkRepositoryIndices(FileUtil.toFile((FileObject)file));
        if (dep == null || "unknown.binary".equals(dep[0])) {
            dep = new String[]{"unknown.binary", file.getName(), "SNAPSHOT"};
            this.addJarToPrivateRepo(file, mdl, dep);
        }
        if (dep != null) {
            Dependency dependency = ModelUtils.checkModelDependency(mdl, dep[0], dep[1], true);
            dependency.setVersion(dep[2]);
            if (scope != null) {
                dependency.setScope(scope);
            }
            return true;
        }
        return false;
    }

    private String[] checkRepositoryIndices(File file) {
        List lst = RepositoryQueries.findBySHA1((File)file, (RepositoryInfo[])new RepositoryInfo[0]);
        Iterator i$ = lst.iterator();
        if (i$.hasNext()) {
            NBVersionInfo elem = (NBVersionInfo)i$.next();
            String[] dep = new String[]{elem.getGroupId(), elem.getArtifactId(), elem.getVersion()};
            return dep;
        }
        return null;
    }

    private boolean checkLibraryForPoms(Library library, POMModel model, String scope) {
        if (!"j2se".equals(library.getType())) {
            return false;
        }
        List poms = library.getContent("maven-pom");
        boolean added = false;
        if (poms != null && poms.size() > 0) {
            for (URL pom : poms) {
                Repository reposit;
                ModelUtils.LibraryDescriptor result = ModelUtils.checkLibrary(pom);
                if (result == null) continue;
                added = true;
                Dependency dep = ModelUtils.checkModelDependency(model, result.getGroupId(), result.getArtifactId(), true);
                dep.setVersion(result.getVersion());
                if (scope != null) {
                    dep.setScope(scope);
                }
                if (result.getClassifier() != null) {
                    dep.setClassifier(result.getClassifier());
                }
                if ((reposit = ModelUtils.addModelRepository(this.project.getOriginalMavenProject(), model, result.getRepoRoot())) == null) continue;
                reposit.setId(library.getName());
                reposit.setLayout(result.getRepoType());
                reposit.setName("Repository for library " + library);
            }
        }
        return added;
    }

    public boolean addAntArtifact(AntArtifact arg0, URI arg1) throws IOException {
        throw new IOException("Cannot add Ant based projects as subprojecs to Maven projects.");
    }

    public SourceGroup[] getExtensibleSourceGroups() {
        SourceGroup[] web;
        SourceGroup[] res;
        Sources s = (Sources)this.project.getLookup().lookup(Sources.class);
        assert (s != null);
        ArrayList<SourceGroup> grps = new ArrayList<SourceGroup>();
        SourceGroup[] java = s.getSourceGroups("java");
        if (java != null) {
            grps.addAll(Arrays.asList(java));
        }
        if ((res = s.getSourceGroups("resources")) != null) {
            grps.addAll(Arrays.asList(res));
        }
        if ((web = s.getSourceGroups("doc_root")) != null) {
            grps.addAll(Arrays.asList(web));
        }
        return grps.toArray(new SourceGroup[0]);
    }

    public String[] getExtensibleClassPathTypes(SourceGroup arg0) {
        return new String[]{"classpath/compile", "classpath/execute", CLASSPATH_COMPILE_ONLY, "classpath/processor"};
    }

    public boolean addLibraries(final Library[] libraries, SourceGroup grp, String type) throws IOException {
        final Boolean[] added = new Boolean[]{libraries.length > 0};
        String scope = "classpath/execute".equals(type) ? "runtime" : null;
        String name = grp.getName();
        if ("2TestSourceRoot".equals(name)) {
            scope = "test";
        }
        if (scope == null && (CLASSPATH_COMPILE_ONLY.equals(type) || "classpath/processor".equals(type))) {
            scope = "provided";
        }
        final String fScope = scope;
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                for (Library library : libraries) {
                    try {
                        added[0] = added[0] != false && CPExtender.this.addLibrary(library, model, fScope);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        added[0] = Boolean.FALSE;
                    }
                }
            }
        };
        FileObject pom = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
        if (added[0].booleanValue()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
        return added[0];
    }

    public boolean removeLibraries(Library[] arg0, SourceGroup arg1, String arg2) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported in maven projects.");
    }

    public boolean addRoots(final URL[] urls, SourceGroup grp, String type) throws IOException {
        final Boolean[] added = new Boolean[]{urls.length > 0};
        String scope = "classpath/execute".equals(type) ? "runtime" : null;
        String name = grp.getName();
        if ("2TestSourceRoot".equals(name)) {
            scope = "test";
        }
        if (scope == null && "classpath/processor".equals(type)) {
            scope = "provided";
        }
        final String fScope = scope;
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                for (URL url : urls) {
                    URL fileUrl = FileUtil.getArchiveFile((URL)url);
                    if (fileUrl != null) {
                        FileObject fo = URLMapper.findFileObject((URL)fileUrl);
                        assert (fo != null);
                        try {
                            added[0] = added[0] != false && CPExtender.this.addArchiveFile(fo, model, fScope);
                        }
                        catch (IOException ex) {
                            added[0] = Boolean.FALSE;
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        continue;
                    }
                    Logger.getLogger(CPExtender.class.getName()).info("Adding non-jar root to Maven projects makes no sense. (" + url + ")");
                }
            }
        };
        FileObject pom = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
        if (added[0].booleanValue()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
        return added[0];
    }

    protected boolean addProjects(final Project[] projects, SourceGroup sg, String classPathType) throws IOException, UnsupportedOperationException {
        final Boolean[] added = new Boolean[]{false, false};
        String scope = "classpath/execute".equals(classPathType) ? "runtime" : null;
        String name = sg.getName();
        if ("2TestSourceRoot".equals(name)) {
            scope = "test";
        }
        if (scope == null && "classpath/processor".equals(classPathType)) {
            scope = "provided";
        }
        final String fScope = scope;
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                Set arts = CPExtender.this.project.getOriginalMavenProject().getArtifacts();
                for (Project prj : projects) {
                    NbMavenProject nbprj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
                    if (nbprj != null) {
                        MavenProject mp = nbprj.getMavenProject();
                        String id = mp.getArtifact().getId();
                        for (Artifact a : arts) {
                            if (!a.getId().equals(id)) continue;
                        }
                        Dependency dependency = ModelUtils.checkModelDependency(model, mp.getGroupId(), mp.getArtifactId(), true);
                        dependency.setVersion(mp.getVersion());
                        if (fScope != null) {
                            dependency.setScope(fScope);
                        } else if ("ejb".equals(nbprj.getPackagingType()) || "war".equals(nbprj.getPackagingType())) {
                            dependency.setScope("provided");
                        }
                        added[0] = true;
                        continue;
                    }
                    added[1] = true;
                }
            }
        };
        FileObject pom = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
        if (added[1].booleanValue()) {
            throw new UnsupportedOperationException("Attempting to add a non-Maven project dependency to a Maven project, not supported.");
        }
        return added[0];
    }

    public boolean removeRoots(URL[] arg0, SourceGroup arg1, String arg2) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing binary dependencies is not supported by Maven projects.");
    }

    public boolean addAntArtifacts(AntArtifact[] arg0, URI[] arg1, SourceGroup arg2, String arg3) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add Ant based projects as subprojects to Maven projects.");
    }

    public boolean removeAntArtifacts(AntArtifact[] arg0, URI[] arg1, SourceGroup arg2, String arg3) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove Ant based projects as subprojects from Maven projects.");
    }

    private void addJarToPrivateRepo(FileObject file, POMModel mdl, String[] dep) throws IOException {
        String name;
        List repos = mdl.getProject().getRepositories();
        boolean found = false;
        String path = null;
        if (repos != null) {
            for (Repository repo : repos) {
                if (!"unknown-jars-temp-repo".equals(repo.getId())) continue;
                found = true;
                String url = repo.getUrl();
                if (url.startsWith("file:${project.basedir}/")) {
                    path = url.substring("file:${project.basedir}/".length());
                    break;
                }
                path = "lib";
                break;
            }
        }
        if (!found) {
            Repository repo = mdl.getFactory().createRepository();
            repo.setId("unknown-jars-temp-repo");
            repo.setName("A temporary repository created by NetBeans for libraries and jars it could not identify. Please replace the dependencies in this repository with correct ones and delete this repository.");
            repo.setUrl("file:${project.basedir}/lib");
            mdl.getProject().addRepository(repo);
            path = "lib";
        }
        assert (path != null);
        FileObject root = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), path);
        FileObject grp = FileUtil.createFolder((FileObject)root, (String)dep[0].replace('.', '/'));
        FileObject art = FileUtil.createFolder((FileObject)grp, (String)dep[1]);
        FileObject ver = FileUtil.createFolder((FileObject)art, (String)dep[2]);
        if (ver.getFileObject(name = dep[1] + "-" + dep[2], file.getExt()) == null) {
            FileUtil.copyFile((FileObject)file, (FileObject)ver, (String)(dep[1] + "-" + dep[2]), (String)file.getExt());
        }
    }
}

