/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.netbeans.modules.web.beans.impl.model.Checker;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

class AssignabilityChecker
implements Checker {
    private ReferenceType myVarType;
    private WebBeansModelImplementation myImpl;
    private ReferenceType myType;
    private boolean isEventAssignability;

    AssignabilityChecker(boolean eventCase) {
        this.isEventAssignability = eventCase;
    }

    static AssignabilityChecker get(boolean eventAssignability) {
        return new AssignabilityChecker(eventAssignability);
    }

    void init(ReferenceType varType, ReferenceType checkedType, WebBeansModelImplementation impl) {
        this.myVarType = varType;
        this.myType = checkedType;
        this.myImpl = impl;
    }

    @Override
    public boolean check() {
        boolean check = this.checkAssignability(this.getVarType(), this.getType());
        return check;
    }

    public boolean checkAssignability(ReferenceType variableType, ReferenceType refType) {
        boolean isDeclaredType = variableType instanceof DeclaredType;
        if (!isDeclaredType) {
            return this.checkParameter(refType, variableType);
        }
        Element variableElement = ((DeclaredType)variableType).asElement();
        if (!(variableElement instanceof TypeElement)) {
            return false;
        }
        if (((DeclaredType)variableType).getTypeArguments().size() == 0) {
            return this.getImplementation().getHelper().getCompilationController().getTypes().isAssignable(refType, variableType);
        }
        if (!(refType instanceof DeclaredType)) {
            return false;
        }
        DeclaredType type = (DeclaredType)refType;
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.size() == 0) {
            List<? extends TypeMirror> interfaces = ((TypeElement)type.asElement()).getInterfaces();
            for (TypeMirror typeMirror : interfaces) {
                if (!(typeMirror instanceof DeclaredType) || !this.checkAssignability(variableType, (DeclaredType)typeMirror)) continue;
                return true;
            }
            DeclaredType superClass = type;
            do {
                TypeMirror typeMirror;
                if ((typeMirror = ((TypeElement)superClass.asElement()).getSuperclass()) instanceof DeclaredType) {
                    superClass = (DeclaredType)typeMirror;
                    if (!this.checkAssignability(variableType, superClass)) continue;
                    return true;
                }
                superClass = null;
            } while (superClass != null);
            return false;
        }
        TypeElement objectElement = this.getImplementation().getHelper().getCompilationController().getElements().getTypeElement(Object.class.getCanonicalName());
        Types types = this.getImplementation().getHelper().getCompilationController().getTypes();
        if (!types.isSameType(types.erasure(variableType), types.erasure(type))) {
            return false;
        }
        List<? extends TypeMirror> list = ((DeclaredType)variableType).getTypeArguments();
        if (list.size() == 0 || types.isSameType(variableType, types.erasure(variableType))) {
            for (TypeMirror typeMirror : typeArguments) {
                if (typeMirror.getKind() == TypeKind.DECLARED) {
                    if (((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().contentEquals(Object.class.getCanonicalName())) continue;
                    return false;
                }
                if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                    TypeMirror lowerBound = ((TypeVariable)typeMirror).getLowerBound();
                    if (lowerBound != null && lowerBound.getKind() != TypeKind.NULL) {
                        return false;
                    }
                    TypeMirror upperBound = ((TypeVariable)typeMirror).getUpperBound();
                    if (upperBound == null || upperBound.getKind() == TypeKind.NULL) continue;
                    return types.isSameType(upperBound, objectElement.asType());
                }
                return false;
            }
            return true;
        }
        if (list.size() != typeArguments.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            TypeMirror typeMirror = typeArguments.get(i);
            if (this.checkParameter(typeMirror, list.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean checkParameter(TypeMirror argType, TypeMirror varTypeArg) {
        if (this.isEventAssignability && varTypeArg.getKind() == TypeKind.TYPEVAR) {
            TypeMirror upperBound = ((TypeVariable)varTypeArg).getUpperBound();
            if (upperBound == null || upperBound.getKind() == TypeKind.NULL) {
                return true;
            }
            return this.getImplementation().getHelper().getCompilationController().getTypes().isAssignable(argType, upperBound);
        }
        Types types = this.getImplementation().getHelper().getCompilationController().getTypes();
        if (argType.getKind() != TypeKind.TYPEVAR && varTypeArg.getKind() != TypeKind.TYPEVAR && argType instanceof ReferenceType && varTypeArg instanceof ReferenceType) {
            if (this.isAssignable(argType, varTypeArg, types)) {
                return true;
            }
            if (varTypeArg instanceof DeclaredType) {
                return this.checkAssignability((DeclaredType)varTypeArg, (ReferenceType)argType);
            }
            return false;
        }
        if (varTypeArg.getKind() == TypeKind.WILDCARD) {
            return this.handleWildCard(argType, (WildcardType)varTypeArg, types);
        }
        if (argType.getKind() == TypeKind.TYPEVAR && varTypeArg.getKind() == TypeKind.TYPEVAR) {
            TypeMirror upper = ((TypeVariable)argType).getUpperBound();
            TypeMirror upperVar = ((TypeVariable)varTypeArg).getUpperBound();
            if (upper == null || upper.getKind() == TypeKind.NULL) {
                return true;
            }
            if (upperVar == null || upperVar.getKind() == TypeKind.NULL) {
                return false;
            }
            if (this.isAssignable(upper, upperVar, this.getImplementation().getHelper().getCompilationController().getTypes())) {
                return true;
            }
            if (upperVar instanceof DeclaredType) {
                return this.checkAssignability((DeclaredType)upperVar, (ReferenceType)upper);
            }
            return false;
        }
        if (varTypeArg.getKind() != TypeKind.TYPEVAR && argType.getKind() == TypeKind.TYPEVAR) {
            TypeMirror upper = ((TypeVariable)argType).getUpperBound();
            if (upper == null || upper.getKind() == TypeKind.NULL || this.isAssignable(varTypeArg, upper, this.getImplementation().getHelper().getCompilationController().getTypes())) {
                return true;
            }
            if (upper instanceof DeclaredType) {
                this.checkAssignability((DeclaredType)upper, (ReferenceType)varTypeArg);
            } else {
                return false;
            }
        }
        return false;
    }

    private boolean handleWildCard(TypeMirror argType, WildcardType varTypeArg, Types types) {
        TypeMirror upperBound = varTypeArg.getExtendsBound();
        TypeMirror lowerBound = varTypeArg.getSuperBound();
        if (argType instanceof ReferenceType && argType.getKind() != TypeKind.TYPEVAR) {
            if (upperBound == null || upperBound.getKind() == TypeKind.NULL) {
                if (lowerBound == null || lowerBound.getKind() == TypeKind.NULL) {
                    return true;
                }
                if (this.isAssignable(lowerBound, argType, types)) {
                    return true;
                }
                if (argType instanceof DeclaredType) {
                    return this.checkAssignability((DeclaredType)argType, (ReferenceType)lowerBound);
                }
                return false;
            }
            if (lowerBound == null || lowerBound.getKind() == TypeKind.NULL) {
                if (this.isAssignable(argType, upperBound, types)) {
                    return true;
                }
                if (upperBound instanceof DeclaredType) {
                    return this.checkAssignability((DeclaredType)upperBound, (ReferenceType)argType);
                }
                return false;
            }
            if (this.isAssignable(argType, upperBound, types) && this.isAssignable(lowerBound, argType, types)) {
                return true;
            }
            if (argType instanceof DeclaredType && lowerBound instanceof DeclaredType) {
                return this.checkAssignability((DeclaredType)upperBound, (ReferenceType)argType) && this.checkAssignability((DeclaredType)argType, (ReferenceType)lowerBound);
            }
            return false;
        }
        if (this.isEventAssignability) {
            return false;
        }
        if (argType.getKind() == TypeKind.TYPEVAR) {
            TypeMirror typeUpper = ((TypeVariable)argType).getUpperBound();
            if (typeUpper == null || typeUpper.getKind() == TypeKind.NULL) {
                return upperBound == null || upperBound.getKind() == TypeKind.NULL;
            }
            if (upperBound == null || upperBound.getKind() == TypeKind.NULL) {
                if (lowerBound == null || lowerBound.getKind() == TypeKind.NULL) {
                    return true;
                }
                if (this.isAssignable(lowerBound, typeUpper, types)) {
                    return true;
                }
                if (typeUpper instanceof DeclaredType) {
                    return this.checkAssignability((DeclaredType)typeUpper, (ReferenceType)lowerBound);
                }
                return false;
            }
            if (lowerBound == null || lowerBound.getKind() == TypeKind.NULL) {
                if (this.isAssignable(typeUpper, upperBound, types)) {
                    return true;
                }
                if (upperBound instanceof DeclaredType) {
                    return this.checkAssignability((DeclaredType)upperBound, (ReferenceType)typeUpper);
                }
                return false;
            }
            if (this.isAssignable(typeUpper, upperBound, types) && this.isAssignable(lowerBound, typeUpper, types)) {
                return true;
            }
            if (typeUpper instanceof DeclaredType && lowerBound instanceof DeclaredType) {
                return this.checkAssignability((DeclaredType)upperBound, (ReferenceType)typeUpper) && this.checkAssignability((DeclaredType)typeUpper, (ReferenceType)lowerBound);
            }
            return false;
        }
        return false;
    }

    private boolean isAssignable(TypeMirror from, TypeMirror to, Types types) {
        boolean isGeneric;
        Element element = types.asElement(to);
        boolean bl = isGeneric = element instanceof TypeElement && ((TypeElement)element).getTypeParameters().size() != 0;
        if (isGeneric) {
            return false;
        }
        return types.isAssignable(from, to);
    }

    private ReferenceType getVarType() {
        return this.myVarType;
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }

    private ReferenceType getType() {
        return this.myType;
    }
}

