/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.junit.Bundle;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class DownloadLibraryTask
implements Runnable {
    private static final String LIB_NAME = "junit_4";
    private static final String KEY = "tried.to.download.junit";

    @Override
    public void run() {
        Preferences p = NbPreferences.forModule(DownloadLibraryTask.class);
        if (p.getBoolean(KEY, false)) {
            return;
        }
        p.putBoolean(KEY, true);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.download_question(), Bundle.download_title(), 2)) == NotifyDescriptor.OK_OPTION) {
            DownloadLibraryTask.perhapsDownload();
        }
    }

    public static void perhapsDownload() {
        if (LibraryManager.getDefault().getLibrary(LIB_NAME) == null) {
            for (BrokenReferencesSupport.LibraryDefiner definer : Lookup.getDefault().lookupAll(BrokenReferencesSupport.LibraryDefiner.class)) {
                Callable c = definer.missingLibrary(LIB_NAME);
                if (c == null) continue;
                try {
                    c.call();
                }
                catch (Exception x) {
                    Logger.getLogger(DownloadLibraryTask.class.getName()).log(Level.INFO, "Could not install JUnit library", x);
                }
            }
        }
    }
}

