/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.fold;

import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.modules.editor.fold.FoldChildren;
import org.netbeans.modules.editor.fold.FoldOperationImpl;
import org.netbeans.modules.editor.fold.FoldUtilitiesImpl;
import org.openide.ErrorManager;

public final class Fold {
    private static final Fold[] EMPTY_FOLD_ARRAY = new Fold[0];
    private static final String DEFAULT_DESCRIPTION = "...";
    private final FoldOperationImpl operation;
    private final FoldType type;
    private boolean collapsed;
    private String description;
    private Fold parent;
    private FoldChildren children;
    private int rawIndex;
    private int startGuardedLength;
    private int endGuardedLength;
    private Position startPos;
    private Position endPos;
    private Position guardedEndPos;
    private Position guardedStartPos;
    private Object extraInfo;

    Fold(FoldOperationImpl operation, FoldType type, String description, boolean collapsed, Document doc, int startOffset, int endOffset, int startGuardedLength, int endGuardedLength, Object extraInfo) throws BadLocationException {
        if (startGuardedLength < 0) {
            throw new IllegalArgumentException("startGuardedLength=" + startGuardedLength + " < 0");
        }
        if (endGuardedLength < 0) {
            throw new IllegalArgumentException("endGuardedLength=" + endGuardedLength + " < 0");
        }
        if (startOffset >= endOffset) {
            throw new IllegalArgumentException("startOffset=" + startOffset + " >= endOffset=" + endOffset);
        }
        if (endOffset - startOffset < startGuardedLength + endGuardedLength) {
            throw new IllegalArgumentException("(endOffset=" + endOffset + " - startOffset=" + startOffset + ") < " + "(startGuardedLength=" + startGuardedLength + " + endGuardedLength=" + endGuardedLength + ")");
        }
        this.operation = operation;
        this.type = type;
        this.collapsed = collapsed;
        this.description = description;
        this.startPos = doc.createPosition(startOffset);
        this.endPos = doc.createPosition(endOffset);
        this.startGuardedLength = startGuardedLength;
        this.endGuardedLength = endGuardedLength;
        this.extraInfo = extraInfo;
        this.updateGuardedStartPos(doc, startOffset);
        this.updateGuardedEndPos(doc, endOffset);
    }

    public FoldType getType() {
        return this.type;
    }

    public Fold getParent() {
        return this.parent;
    }

    void setParent(Fold parent) {
        if (this.isRootFold()) {
            throw new IllegalArgumentException("Cannot set parent on root");
        }
        this.parent = parent;
    }

    public FoldHierarchy getHierarchy() {
        return this.operation.getHierarchy();
    }

    FoldOperationImpl getOperation() {
        return this.operation;
    }

    boolean isRootFold() {
        return this.operation.getManager() == null;
    }

    public int getStartOffset() {
        return this.isRootFold() ? 0 : this.startPos.getOffset();
    }

    void setStartOffset(Document doc, int startOffset) throws BadLocationException {
        if (this.isRootFold()) {
            throw new IllegalStateException("Cannot set endOffset of root fold");
        }
        this.startPos = doc.createPosition(startOffset);
        this.updateGuardedStartPos(doc, startOffset);
    }

    public int getEndOffset() {
        return this.isRootFold() ? this.operation.getHierarchy().getComponent().getDocument().getLength() : this.endPos.getOffset();
    }

    void setEndOffset(Document doc, int endOffset) throws BadLocationException {
        if (this.isRootFold()) {
            throw new IllegalStateException("Cannot set endOffset of root fold");
        }
        this.endPos = doc.createPosition(endOffset);
        this.updateGuardedEndPos(doc, endOffset);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    void setCollapsed(boolean collapsed) {
        if (this.isRootFold()) {
            throw new IllegalStateException("Cannot set collapsed flag on root fold.");
        }
        this.collapsed = collapsed;
    }

    public String getDescription() {
        return this.description != null ? this.description : DEFAULT_DESCRIPTION;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public int getFoldCount() {
        return this.children != null ? this.children.getFoldCount() : 0;
    }

    public Fold getFold(int index) {
        if (this.children != null) {
            return this.children.getFold(index);
        }
        throw new IndexOutOfBoundsException("index=" + index + " but no children exist.");
    }

    Fold[] foldsToArray(int index, int count) {
        if (this.children != null) {
            return this.children.foldsToArray(index, count);
        }
        if (count == 0) {
            return EMPTY_FOLD_ARRAY;
        }
        throw new IndexOutOfBoundsException("No children but count=" + count);
    }

    void extractToChildren(int index, int length, Fold fold) {
        if (fold.getFoldCount() != 0 || fold.getParent() != null) {
            throw new IllegalStateException();
        }
        if (length != 0) {
            fold.setChildren(this.children.extractToChildren(index, length, fold));
        } else {
            if (this.children == null) {
                this.children = new FoldChildren(this);
            }
            this.children.insert(index, fold);
        }
    }

    Fold replaceByChildren(int index) {
        Fold fold = this.getFold(index);
        FoldChildren foldChildren = fold.getChildren();
        fold.setChildren(null);
        this.children.replaceByChildren(index, foldChildren);
        return fold;
    }

    private FoldChildren getChildren() {
        return this.children;
    }

    private void setChildren(FoldChildren children) {
        this.children = children;
    }

    Object getExtraInfo() {
        return this.extraInfo;
    }

    public int getFoldIndex(Fold child) {
        return this.children != null ? this.children.getFoldIndex(child) : -1;
    }

    private void updateGuardedStartPos(Document doc, int startOffset) throws BadLocationException {
        if (!this.isRootFold()) {
            int guardedStartOffset = this.isZeroStartGuardedLength() ? startOffset + 1 : startOffset + this.startGuardedLength;
            this.guardedStartPos = doc.createPosition(guardedStartOffset);
        }
    }

    private void updateGuardedEndPos(Document doc, int endOffset) throws BadLocationException {
        if (!this.isRootFold()) {
            int guardedEndOffset = this.isZeroEndGuardedLength() ? endOffset - 1 : endOffset - this.endGuardedLength;
            this.guardedEndPos = doc.createPosition(guardedEndOffset);
        }
    }

    private boolean isZeroStartGuardedLength() {
        return this.startGuardedLength == 0;
    }

    private boolean isZeroEndGuardedLength() {
        return this.endGuardedLength == 0;
    }

    private int getGuardedStartOffset() {
        return this.isRootFold() ? this.getStartOffset() : this.guardedStartPos.getOffset();
    }

    private int getGuardedEndOffset() {
        return this.isRootFold() ? this.getEndOffset() : this.guardedEndPos.getOffset();
    }

    void insertUpdate(DocumentEvent evt) {
        if (evt.getOffset() + evt.getLength() == this.getGuardedStartOffset()) {
            try {
                this.updateGuardedStartPos(evt.getDocument(), this.getStartOffset());
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    void removeUpdate(DocumentEvent evt) {
        try {
            if (this.getStartOffset() == this.getGuardedStartOffset()) {
                this.updateGuardedStartPos(evt.getDocument(), this.getStartOffset());
            }
            if (this.getEndOffset() == this.getGuardedEndOffset()) {
                this.updateGuardedEndPos(evt.getDocument(), this.getEndOffset());
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    boolean isStartDamaged() {
        return !this.isZeroStartGuardedLength() && this.getInnerStartOffset() - this.getStartOffset() != this.startGuardedLength;
    }

    boolean isEndDamaged() {
        return !this.isZeroEndGuardedLength() && this.getEndOffset() - this.getInnerEndOffset() != this.endGuardedLength;
    }

    boolean isExpandNecessary() {
        return this.isZeroStartGuardedLength() && this.getStartOffset() == this.getGuardedStartOffset() || this.isZeroEndGuardedLength() && this.getEndOffset() == this.getGuardedEndOffset();
    }

    private int getInnerStartOffset() {
        return this.isZeroStartGuardedLength() ? this.getStartOffset() : this.getGuardedStartOffset();
    }

    private int getInnerEndOffset() {
        return this.isZeroEndGuardedLength() ? this.getEndOffset() : this.getGuardedEndOffset();
    }

    int getRawIndex() {
        return this.rawIndex;
    }

    void setRawIndex(int rawIndex) {
        this.rawIndex = rawIndex;
    }

    void updateRawIndex(int rawIndexDelta) {
        this.rawIndex += rawIndexDelta;
    }

    public String toString() {
        return FoldUtilitiesImpl.foldToString(this) + ", [" + this.getInnerStartOffset() + ", " + this.getInnerEndOffset() + "] {" + this.getGuardedStartOffset() + ", " + this.getGuardedEndOffset() + '}';
    }
}

