/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ConfigureUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewProjectWizardUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModeDescriptorPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.ui.DocumentAdapter;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SelectModePanel
extends JPanel {
    private final SelectModeDescriptorPanel controller;
    private volatile boolean initialized = false;
    private static final byte noMessage = 0;
    private static final byte notFolder = 1;
    private static final byte cannotReadFolder = 2;
    private static final byte cannotWriteFolder = 3;
    private static final byte alreadyNbPoject = 4;
    private static final byte notFoundMakeAndConfigure = 5;
    private static final byte notRoot = 6;
    private byte messageKind = 0;
    private JRadioButton advancedMode;
    private ButtonGroup buttonGroup1;
    private JComboBox hostComboBox;
    private JLabel hostLabel;
    private JPanel instructionPanel;
    private JTextPane instructions;
    private JScrollPane jScrollPane1;
    private JLabel modeLabel;
    private JButton projectBrowseButton;
    private JTextField projectFolder;
    private JLabel projectFolderLabel;
    private JRadioButton simpleMode;
    private JButton sourceBrowseButton;
    private JTextField sourceFolder;
    private JLabel sourceFolderLabel;
    private JComboBox toolchainComboBox;
    private JLabel toolchainLabel;

    public SelectModePanel(SelectModeDescriptorPanel controller) {
        this.controller = controller;
        this.initComponents();
        this.sourceFolderLabel.setVisible(controller.isFullRemote());
        this.sourceFolder.setVisible(controller.isFullRemote());
        this.sourceBrowseButton.setVisible(controller.isFullRemote());
        if (!controller.isFullRemote()) {
            this.projectFolderLabel.setText(this.sourceFolderLabel.getText());
        }
        this.instructions.setEditorKit(new HTMLEditorKit());
        this.instructions.setBackground(this.instructionPanel.getBackground());
        this.disableHostSensitiveComponents();
        this.addListeners();
    }

    private void addListeners() {
        this.projectFolder.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void update(DocumentEvent e) {
                String path = SelectModePanel.this.projectFolder.getText();
                SelectModePanel.this.controller.getWizardStorage().setProjectPath(path);
                if (!SelectModePanel.this.controller.isFullRemote() && !path.isEmpty()) {
                    String normalizedPath = CndFileUtils.normalizeAbsolutePath((String)path);
                    SelectModePanel.this.controller.getWizardStorage().setSourcesFileObject(CndFileUtils.toFileObject((CharSequence)normalizedPath));
                }
                SelectModePanel.this.updateInstruction();
            }
        });
        this.sourceFolder.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void update(DocumentEvent e) {
                FileObject fileObject;
                String path = SelectModePanel.this.sourceFolder.getText();
                String projectName = null;
                if (path.isEmpty()) {
                    fileObject = null;
                } else {
                    ExecutionEnvironment env = SelectModePanel.this.getSelectedExecutionEnvironment();
                    fileObject = RemoteFileUtil.getFileObject((String)path, (ExecutionEnvironment)env, (RemoteProject.Mode)RemoteProject.Mode.REMOTE_SOURCES);
                    projectName = fileObject == null ? null : fileObject.getNameExt();
                }
                SelectModePanel.this.controller.getWizardStorage().setSourcesFileObject(fileObject);
                if (SelectModePanel.this.projectFolder.getText().isEmpty() && projectName != null && !projectName.isEmpty()) {
                    File projectLocation = ProjectChooser.getProjectsFolder();
                    File projectFile = CndFileUtils.createLocalFile((File)projectLocation, (String)projectName);
                    SelectModePanel.this.projectFolder.setText(projectFile.getAbsolutePath());
                }
                SelectModePanel.this.updateInstruction();
            }
        });
        this.simpleMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectModePanel.this.controller.getWizardStorage().setMode(SelectModePanel.this.simpleMode.isSelected());
                SelectModePanel.this.updateInstruction();
            }
        });
        this.advancedMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectModePanel.this.controller.getWizardStorage().setMode(SelectModePanel.this.simpleMode.isSelected());
                SelectModePanel.this.updateInstruction();
            }
        });
        this.updateInstruction();
    }

    private void updateInstruction() {
        if (this.simpleMode.isSelected()) {
            String tool = "Makefile";
            String toolsInfo = NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionExtraText_Make");
            if (this.controller.getWizardStorage() != null) {
                String configure = this.controller.getWizardStorage().getConfigure();
                if (configure != null) {
                    toolsInfo = NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionExtraText_Configure");
                    tool = configure;
                    String normalizedPath = CndFileUtils.normalizeAbsolutePath((String)configure);
                    FileObject fo = CndFileUtils.toFileObject((CharSequence)normalizedPath);
                    if (fo != null && fo.isValid()) {
                        String mimeType = fo.getMIMEType();
                        if ("text/x-cmake".equals(mimeType)) {
                            toolsInfo = NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionExtraText_CMake");
                            tool = "cmake";
                        } else if ("text/x-qtproject".equals(mimeType)) {
                            toolsInfo = NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionExtraText_QMake");
                            tool = "qmake";
                        }
                    }
                } else {
                    String makefile = this.controller.getWizardStorage().getMake();
                    if (makefile != null) {
                        tool = makefile;
                    }
                }
            }
            String modeInfo = NbBundle.getMessage(SelectModePanel.class, (String)"SimpleModeButtonText", (Object)tool);
            Mnemonics.setLocalizedText((AbstractButton)this.simpleMode, (String)modeInfo);
            this.instructions.setText(NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionText", (Object)toolsInfo));
        } else {
            this.instructions.setText(NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeAdvancedInstructionText"));
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.instructionPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.instructions = new JTextPane();
        this.simpleMode = new JRadioButton();
        this.advancedMode = new JRadioButton();
        this.modeLabel = new JLabel();
        this.projectFolderLabel = new JLabel();
        this.projectFolder = new JTextField();
        this.projectBrowseButton = new JButton();
        this.toolchainComboBox = new JComboBox();
        this.toolchainLabel = new JLabel();
        this.hostComboBox = new JComboBox();
        this.hostLabel = new JLabel();
        this.sourceFolderLabel = new JLabel();
        this.sourceFolder = new JTextField();
        this.sourceBrowseButton = new JButton();
        this.setPreferredSize(new Dimension(450, 350));
        this.setLayout(new GridBagLayout());
        this.instructionPanel.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 200));
        this.instructions.setBorder(null);
        this.instructions.setEditable(false);
        this.instructions.setFocusable(false);
        this.instructions.setOpaque(false);
        this.jScrollPane1.setViewportView(this.instructions);
        this.instructionPanel.add((Component)this.jScrollPane1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.buttonGroup1.add(this.simpleMode);
        this.simpleMode.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.simpleMode, (String)bundle.getString("SimpleModeButtonText"));
        this.simpleMode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.simpleMode.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.simpleMode, gridBagConstraints);
        this.buttonGroup1.add(this.advancedMode);
        Mnemonics.setLocalizedText((AbstractButton)this.advancedMode, (String)bundle.getString("AdvancedModeButtonText"));
        this.advancedMode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.advancedMode.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.advancedMode, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.modeLabel, (String)bundle.getString("SelectModeLabelText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.modeLabel, gridBagConstraints);
        this.projectFolderLabel.setLabelFor(this.projectFolder);
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)NbBundle.getMessage(SelectModePanel.class, (String)"SELECT_MODE_PROJECT_FOLDER"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.projectFolderLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.projectFolder, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.projectBrowseButton, (String)NbBundle.getMessage(SelectModePanel.class, (String)"SELECT_MODE_BROWSE_PROJECT_FOLDER"));
        this.projectBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectModePanel.this.projectBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.projectBrowseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.toolchainComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.toolchainLabel, (String)NbBundle.getMessage(SelectModePanel.class, (String)"LBL_TOOLCHAIN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 8, 0);
        this.add((Component)this.toolchainLabel, gridBagConstraints);
        this.hostComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SelectModePanel.this.hostComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.hostComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(SelectModePanel.class, (String)"LBL_HOST"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 8, 0);
        this.add((Component)this.hostLabel, gridBagConstraints);
        this.sourceFolderLabel.setLabelFor(this.projectFolder);
        Mnemonics.setLocalizedText((JLabel)this.sourceFolderLabel, (String)NbBundle.getMessage(SelectModePanel.class, (String)"SELECT_MODE_SOURCES_FOLDER"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceFolderLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.sourceFolder, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.sourceBrowseButton, (String)NbBundle.getMessage(SelectModePanel.class, (String)"SELECT_MODE_BROWSE_PROJECT_FOLDER"));
        this.sourceBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectModePanel.this.sourceBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.sourceBrowseButton, gridBagConstraints);
    }

    private void projectBrowseButtonActionPerformed(ActionEvent evt) {
        String seed = this.projectFolder.getText();
        String approveButtonText = NbBundle.getMessage(SelectModePanel.class, (String)"PROJECT_DIR_BUTTON_TXT");
        FileChooser fileChooser = new FileChooser(NbBundle.getMessage(SelectModePanel.class, (String)"PROJECT_DIR_CHOOSER_TITLE_TXT"), approveButtonText, 1, null, seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile != null) {
            String path = selectedFile.getPath();
            this.projectFolder.setText(path);
        }
    }

    private void hostComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.initialized) {
            return;
        }
        if (evt.getStateChange() == 1) {
            ServerRecord newItem = (ServerRecord)evt.getItem();
            PanelProjectLocationVisual.updateToolchains(this.toolchainComboBox, newItem);
            this.controller.fireChangeEvent();
        }
    }

    private void sourceBrowseButtonActionPerformed(ActionEvent evt) {
        CndUtils.assertTrue((boolean)this.controller.isFullRemote());
        String seed = this.sourceFolder.getText();
        String approveButtonText = NbBundle.getMessage(SelectModePanel.class, (String)"SOURCES_DIR_BUTTON_TXT");
        String title = NbBundle.getMessage(SelectModePanel.class, (String)"SOURCES_DIR_CHOOSER_TITLE_TXT");
        JFileChooser fileChooser = NewProjectWizardUtils.createFileChooser(this.controller.getWizardDescriptor(), title, approveButtonText, 1, null, seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile != null) {
            String path = selectedFile.getPath();
            this.sourceFolder.setText(path);
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.initialized = false;
        this.updateControls();
        String hostUID = (String)wizardDescriptor.getProperty("hostUID");
        CompilerSet cs = (CompilerSet)wizardDescriptor.getProperty("toolchain");
        RequestProcessor.getDefault().post((Runnable)new PanelProjectLocationVisual.DevHostsInitializer(hostUID, cs, false, (ToolsCacheManager)wizardDescriptor.getProperty("ToolsCacheManager")){

            @Override
            public void updateComponents(Collection<ServerRecord> records, ServerRecord srToSelect, CompilerSet csToSelect, boolean enabled) {
                boolean enableHost = enabled;
                if (SelectModePanel.this.controller.isFullRemote()) {
                    enableHost = false;
                }
                SelectModePanel.this.enableHostSensitiveComponents(records, srToSelect, csToSelect, enableHost, enabled);
            }
        });
    }

    void updateControls() {
        this.updateInstruction();
    }

    void enableControls(boolean enable) {
        this.advancedMode.setEnabled(enable);
        this.simpleMode.setEnabled(enable);
    }

    private ExecutionEnvironment getSelectedExecutionEnvironment() {
        Object obj = this.hostComboBox.getSelectedItem();
        if (obj != null && obj instanceof ServerRecord) {
            ServerRecord sr = (ServerRecord)obj;
            return sr.getExecutionEnvironment();
        }
        return ServerList.getDefaultRecord().getExecutionEnvironment();
    }

    void store(WizardDescriptor wizardDescriptor) {
        if (this.simpleMode.isSelected()) {
            wizardDescriptor.putProperty("simpleMode", (Object)Boolean.TRUE);
            wizardDescriptor.putProperty("setAsMain", (Object)Boolean.TRUE);
        } else {
            wizardDescriptor.putProperty("simpleMode", (Object)Boolean.FALSE);
        }
        wizardDescriptor.putProperty("simpleModeFolder", (Object)this.projectFolder.getText().trim());
        String folderPath = this.projectFolder.getText().trim();
        if (CndPathUtilitities.isPathAbsolute((CharSequence)folderPath)) {
            File file = CndFileUtils.createLocalFile((String)folderPath);
            file = FileUtil.normalizeFile((File)file);
            wizardDescriptor.putProperty("projdir", (Object)file);
        }
        wizardDescriptor.putProperty("readOnlyToolchain", (Object)Boolean.TRUE);
        ExecutionEnvironment ee = this.getSelectedExecutionEnvironment();
        wizardDescriptor.putProperty("hostUID", (Object)ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)ee));
        this.controller.getWizardStorage().setExecutionEnvironment(ee);
        Object tc = this.toolchainComboBox.getSelectedItem();
        if (tc != null && tc instanceof PanelProjectLocationVisual.ToolCollectionItem) {
            PanelProjectLocationVisual.ToolCollectionItem item = (PanelProjectLocationVisual.ToolCollectionItem)tc;
            wizardDescriptor.putProperty("toolchain", (Object)item.getCompilerSet());
            wizardDescriptor.putProperty("toolchainDefault", (Object)item.isDefaultCompilerSet());
            this.controller.getWizardStorage().setCompilerSet(item.getCompilerSet());
            this.controller.getWizardStorage().setDefaultCompilerSet(item.isDefaultCompilerSet());
        }
        wizardDescriptor.putProperty("nativeProjFO", (Object)this.controller.getWizardStorage().getSourcesFileObject());
        FileObject fo = this.controller.getWizardStorage().getSourcesFileObject();
        wizardDescriptor.putProperty("nativeProjDir", (Object)(fo == null ? null : fo.getPath()));
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean valid() {
        this.messageKind = 0;
        String path = this.projectFolder.getText().trim();
        try {
            File fileToCheck;
            if (path.length() == 0) {
                boolean bl = false;
                return bl;
            }
            if (!CndPathUtilitities.isPathAbsolute((CharSequence)path)) {
                this.messageKind = 1;
                boolean bl = false;
                return bl;
            }
            File projectDirFile = FileUtil.normalizeFile((File)CndFileUtils.createLocalFile((String)path));
            File projectDirParent = projectDirFile.getParentFile();
            File file = fileToCheck = this.controller.isFullRemote() ? projectDirParent : projectDirFile;
            if (fileToCheck == null || !fileToCheck.isDirectory() || !fileToCheck.canRead()) {
                this.messageKind = fileToCheck == null ? (byte)6 : (fileToCheck.isDirectory() ? (byte)2 : (byte)1);
                path = fileToCheck == null ? "" : fileToCheck.getAbsolutePath();
                boolean bl = false;
                return bl;
            }
            if (this.simpleMode.isSelected()) {
                FileObject fo;
                if (!fileToCheck.canWrite()) {
                    this.messageKind = (byte)3;
                    path = fileToCheck.getAbsolutePath();
                    boolean bl = false;
                    return bl;
                }
                File nbFile = CndFileUtils.createLocalFile((File)CndFileUtils.createLocalFile((String)path, (String)"nbproject"), (String)"project.xml");
                if (nbFile.exists()) {
                    this.messageKind = (byte)4;
                    boolean bl = false;
                    return bl;
                }
                if (projectDirFile.isDirectory() && (fo = CndFileUtils.toFileObject((File)projectDirFile)) != null && fo.isValid()) {
                    try {
                        if (ProjectManager.getDefault().findProject(fo) != null) {
                            this.messageKind = (byte)4;
                            boolean bl = false;
                            return bl;
                        }
                    }
                    catch (IOException ex) {
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                }
            }
            if (ConfigureUtils.findConfigureScript(this.controller.getWizardStorage().getSourcesFileObject()) != null) {
                boolean nbFile = true;
                return nbFile;
            }
            FileObject makeFO = ConfigureUtils.findMakefile(this.controller.getWizardStorage().getSourcesFileObject());
            if (makeFO != null) {
                this.controller.getWizardStorage().setMake(makeFO);
                boolean bl = true;
                return bl;
            }
            if (this.simpleMode.isSelected()) {
                this.messageKind = (byte)5;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.messageKind > 0) {
                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)("SelectModeError" + this.messageKind), (Object)path));
            } else {
                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                if (this.simpleMode.isSelected()) {
                    this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)"CleanInfoMessageSimpleMode"));
                } else {
                    this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", null);
                }
            }
        }
    }

    private void disableHostSensitiveComponents() {
        PanelProjectLocationVisual.disableHostsInfo(this.hostComboBox, this.toolchainComboBox);
        this.advancedMode.setEnabled(false);
        this.simpleMode.setEnabled(false);
    }

    private void enableHostSensitiveComponents(Collection<ServerRecord> records, ServerRecord srToSelect, CompilerSet csToSelect, boolean enableHost, boolean enableToolchain) {
        PanelProjectLocationVisual.updateToolchainsComponents(this.hostComboBox, this.toolchainComboBox, records, srToSelect, csToSelect, enableHost, enableToolchain);
        this.advancedMode.setEnabled(true);
        this.simpleMode.setEnabled(true);
        this.updateInstruction();
        this.initialized = true;
        this.controller.fireChangeEvent();
    }
}

