/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.io.File;
import org.netbeans.modules.cnd.actions.AbstractExecutorRunAction;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

public final class ConfigureUtils {
    private static final String PREDEFINED_FLAGS_GNU = "\"-g3 -gdwarf-2\"";
    private static final String PREDEFINED_FLAGS_SUN = "-g";

    private ConfigureUtils() {
    }

    public static String findConfigureScript(String path) {
        return ConfigureUtils.findConfigureScript(FileUtil.toFileObject((File)new File(path)));
    }

    public static String findConfigureScript(FileObject folder) {
        if (folder == null) {
            return null;
        }
        String[] pattern = new String[]{"configure"};
        if (!folder.isFolder() || !folder.canRead()) {
            return null;
        }
        for (String name : pattern) {
            FileObject child = folder.getFileObject(name);
            if (!ConfigureUtils.isRunnable(child)) continue;
            return child.getPath();
        }
        String res = ConfigureUtils.detectQTProject(folder);
        if (res != null) {
            return res;
        }
        res = ConfigureUtils.detectCMake(folder);
        if (res != null) {
            return res;
        }
        return null;
    }

    private static String detectQTProject(FileObject folder) {
        if (folder == null) {
            return null;
        }
        FileObject[] listFiles = folder.getChildren();
        if (listFiles == null) {
            return null;
        }
        for (FileObject file : listFiles) {
            if (!file.getExt().equals("pro")) continue;
            if (AbstractExecutorRunAction.findTools((String)"qmake") == null) break;
            return file.getPath();
        }
        return null;
    }

    private static String detectCMake(FileObject folder) {
        if (folder == null) {
            return null;
        }
        FileObject configure = folder.getFileObject("CMakeLists.txt");
        if (configure != null && configure.isValid() && AbstractExecutorRunAction.findTools((String)"cmake") != null) {
            return configure.getPath();
        }
        return null;
    }

    public static boolean isRunnable(FileObject fileObject) {
        if (fileObject != null && fileObject.isValid()) {
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file != null) {
                return ConfigureUtils.isRunnable(file);
            }
            return true;
        }
        return false;
    }

    public static boolean isRunnable(File file) {
        if (file.exists() && file.isFile() && (file.canRead() || file.canExecute())) {
            DataObject dObj;
            FileObject configureFileObject = CndFileUtils.toFileObject((File)file);
            if (configureFileObject == null || !configureFileObject.isValid()) {
                return false;
            }
            try {
                dObj = DataObject.find((FileObject)configureFileObject);
            }
            catch (DataObjectNotFoundException ex) {
                return false;
            }
            if (dObj == null) {
                return false;
            }
            Node node = dObj.getNodeDelegate();
            if (node == null) {
                return false;
            }
            ShellExecSupport ses = (ShellExecSupport)node.getCookie(ShellExecSupport.class);
            if (ses != null) {
                return true;
            }
            if (file.getAbsolutePath().endsWith("CMakeLists.txt")) {
                return AbstractExecutorRunAction.findTools((String)"cmake") != null;
            }
            if (file.getAbsolutePath().endsWith(".pro")) {
                return AbstractExecutorRunAction.findTools((String)"qmake") != null;
            }
        }
        return false;
    }

    public static FileObject findMakefile(FileObject projDirFo) {
        String[] pattern = new String[]{"GNUmakefile", "makefile", "Makefile"};
        if (projDirFo == null || !projDirFo.isFolder() || !projDirFo.canRead()) {
            return null;
        }
        for (String name : pattern) {
            FileObject makeFO = projDirFo.getFileObject(name);
            if (makeFO == null || !makeFO.isValid() || !makeFO.isData() || !makeFO.canRead()) continue;
            return makeFO;
        }
        return null;
    }

    public static String getConfigureArguments(ExecutionEnvironment ee, CompilerSet def, String configure, String flags) {
        ee = ee != null ? ee : ServerList.getDefaultRecord().getExecutionEnvironment();
        def = def != null ? def : CompilerSetManager.get((ExecutionEnvironment)ee).getDefaultCompilerSet();
        String cCompiler = ConfigureUtils.getDefaultC(def);
        String cppCompiler = ConfigureUtils.getDefaultCpp(def);
        StringBuilder buf = new StringBuilder(flags);
        String cCompilerFlags = ConfigureUtils.getCompilerFlags(def);
        String cppCompilerFlags = ConfigureUtils.getCompilerFlags(def);
        if (configure.endsWith("CMakeLists.txt")) {
            ConfigureUtils.appendIfNeed("-G ", flags, buf, "\"Unix Makefiles\"");
            ConfigureUtils.appendIfNeed("-DCMAKE_BUILD_TYPE=", flags, buf, "Debug");
            ConfigureUtils.appendIfNeed("-DCMAKE_C_COMPILER=", flags, buf, cCompiler);
            ConfigureUtils.appendIfNeed("-DCMAKE_CXX_COMPILER=", flags, buf, cppCompiler);
            ConfigureUtils.appendIfNeed("-DCMAKE_C_FLAGS_DEBUG=", flags, buf, cCompilerFlags);
            ConfigureUtils.appendIfNeed("-DCMAKE_CXX_FLAGS_DEBUG=", flags, buf, cppCompilerFlags);
        } else if (configure.endsWith(".pro")) {
            int platform = ConfigureUtils.getPlatform(ee);
            if (ConfigureUtils.isSunStudio(def) && (platform == 1 || platform == 0)) {
                ConfigureUtils.appendIfNeed("-spec ", flags, buf, "solaris-cc");
            }
            if (platform == 4) {
                buf.append("-spec macx-g++");
            }
            ConfigureUtils.appendIfNeed("QMAKE_CC=", flags, buf, cCompiler);
            ConfigureUtils.appendIfNeed("QMAKE_CXX=", flags, buf, cppCompiler);
            ConfigureUtils.appendIfNeed("QMAKE_CFLAGS=", flags, buf, cCompilerFlags);
            ConfigureUtils.appendIfNeed("QMAKE_CXXFLAGS=", flags, buf, cppCompilerFlags);
        } else {
            ConfigureUtils.appendIfNeed("CC=", flags, buf, cCompiler);
            ConfigureUtils.appendIfNeed("CXX=", flags, buf, cppCompiler);
            ConfigureUtils.appendIfNeed("CFLAGS=", flags, buf, cCompilerFlags);
            ConfigureUtils.appendIfNeed("CXXFLAGS=", flags, buf, cppCompilerFlags);
        }
        return buf.toString();
    }

    private static void appendIfNeed(String key, String flags, StringBuilder buf, String flag) {
        if (flags.indexOf(key) < 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(key).append(flag);
        }
    }

    private static int getPlatform(ExecutionEnvironment ee) {
        return CompilerSetManager.get((ExecutionEnvironment)ee).getPlatform();
    }

    private static boolean isSunStudio(CompilerSet def) {
        CompilerFlavor flavor;
        return def != null && (flavor = def.getCompilerFlavor()).isSunStudioCompiler();
    }

    private static String getDefaultC(CompilerSet def) {
        CompilerFlavor flavor;
        String cCompiler = ConfigureUtils.getToolPath(def, PredefinedToolKind.CCompiler);
        if (cCompiler != null) {
            return cCompiler;
        }
        cCompiler = "gcc";
        if (def != null && (flavor = def.getCompilerFlavor()).isSunStudioCompiler()) {
            cCompiler = "cc";
        }
        return cCompiler;
    }

    private static String getDefaultCpp(CompilerSet def) {
        CompilerFlavor flavor;
        String cppCompiler = ConfigureUtils.getToolPath(def, PredefinedToolKind.CCCompiler);
        if (cppCompiler != null) {
            return cppCompiler;
        }
        cppCompiler = "g++";
        if (def != null && (flavor = def.getCompilerFlavor()).isSunStudioCompiler()) {
            cppCompiler = "CC";
        }
        return cppCompiler;
    }

    private static String getToolPath(CompilerSet compilerSet, PredefinedToolKind tool) {
        if (compilerSet == null) {
            return null;
        }
        Tool compiler = compilerSet.findTool((ToolKind)tool);
        if (compiler == null) {
            return null;
        }
        return ConfigureUtils.escapeFlags(compiler.getPath());
    }

    private static String escapeFlags(String flags) {
        if (!(flags.indexOf(32) <= 0 && flags.indexOf(61) <= 0 || flags.startsWith("\""))) {
            flags = "\"" + flags + "\"";
        }
        return flags;
    }

    private static String getCompilerFlags(CompilerSet def) {
        CompilerFlavor flavor;
        if (def != null && (flavor = def.getCompilerFlavor()).isSunStudioCompiler()) {
            return PREDEFINED_FLAGS_SUN;
        }
        return PREDEFINED_FLAGS_GNU;
    }
}

