/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.spi.configurations.PkgConfigManager;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class PkgConfigLibrary
extends JPanel {
    private final MyListCellRenderer myListCellRenderer = new MyListCellRenderer();
    private final List<PkgConfigManager.PackageConfiguration> avaliablePkgConfigs;
    private JTextField filter;
    private JLabel filterLabel;
    private JLabel label;
    private JList list;
    private JScrollPane scrollPane;

    public PkgConfigLibrary(MakeConfiguration makeConfiguration) {
        this.initComponents();
        this.list.setCellRenderer(this.myListCellRenderer);
        PkgConfigManager.PkgConfig pkgConfig = PkgConfigManager.getDefault().getPkgConfig(makeConfiguration);
        TreeMap<String, PkgConfigManager.PackageConfiguration> map = new TreeMap<String, PkgConfigManager.PackageConfiguration>();
        for (PkgConfigManager.PackageConfiguration conf : pkgConfig.getAvaliablePkgConfigs()) {
            map.put(conf.getName(), conf);
        }
        this.avaliablePkgConfigs = new ArrayList(map.values());
        this.list.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return PkgConfigLibrary.this.avaliablePkgConfigs.size();
            }

            @Override
            public Object getElementAt(int i) {
                return PkgConfigLibrary.this.avaliablePkgConfigs.get(i);
            }
        });
        this.filter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PkgConfigLibrary.this.updateModel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PkgConfigLibrary.this.updateModel();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PkgConfigLibrary.this.updateModel();
            }
        });
    }

    private void updateModel() {
        String pattern = this.filter.getText().trim().toLowerCase();
        final ArrayList<PkgConfigManager.PackageConfiguration> res = new ArrayList<PkgConfigManager.PackageConfiguration>();
        for (PkgConfigManager.PackageConfiguration conf : this.avaliablePkgConfigs) {
            if (conf.getName().toLowerCase().contains(pattern)) {
                res.add(conf);
                continue;
            }
            if (!conf.getDisplayName().toLowerCase().contains(pattern)) continue;
            res.add(conf);
        }
        this.list.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return res.size();
            }

            @Override
            public Object getElementAt(int i) {
                return res.get(i);
            }
        });
    }

    public PkgConfigManager.PackageConfiguration[] getPkgConfigLibs() {
        Object[] selectedValues = this.list.getSelectedValues();
        PkgConfigManager.PackageConfiguration[] selectedLibs = new PkgConfigManager.PackageConfiguration[selectedValues.length];
        for (int i = 0; i < selectedValues.length; ++i) {
            selectedLibs[i] = (PkgConfigManager.PackageConfiguration)selectedValues[i];
        }
        return selectedLibs;
    }

    private void initComponents() {
        this.label = new JLabel();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.filterLabel = new JLabel();
        this.filter = new JTextField();
        this.setLayout(new GridBagLayout());
        this.label.setLabelFor(this.scrollPane);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(PkgConfigLibrary.class, (String)"PkgConfigLibrary.label.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.label, gridBagConstraints);
        this.scrollPane.setPreferredSize(new Dimension(300, 300));
        this.scrollPane.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.filterLabel.setLabelFor(this.filter);
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getMessage(PkgConfigLibrary.class, (String)"PkgConfigLibrary.filterLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.filterLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.add((Component)this.filter, gridBagConstraints);
    }

    private static final class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            PkgConfigManager.PackageConfiguration libraryItem = (PkgConfigManager.PackageConfiguration)value;
            label.setIcon(this.getLibraryIcon());
            label.setText(libraryItem.getName());
            String message = NbBundle.getMessage(PkgConfigLibrary.class, (String)"PkgConfigLibrary.tooltip.text", (Object)libraryItem.getDisplayName(), (Object)libraryItem.getVersion(), (Object)libraryItem.getLibs());
            label.setToolTipText(message);
            return label;
        }

        private ImageIcon getLibraryIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/resources/stdLibrary.gif", (boolean)false);
        }
    }
}

