/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeProjectConfigurationProvider;
import org.netbeans.modules.cnd.makeproject.MakeSharabilityQuery;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.MoveOrRenameOperationImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MakeProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation,
MoveOrRenameOperationImplementation {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private MakeProject project;

    public MakeProjectOperations(MakeProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeProjectOperations.addFile(projectDirectory, "nbproject", files);
        if (!pdp.getConfigurationDescriptor().getProjectMakefileName().isEmpty()) {
            MakeProjectOperations.addFile(projectDirectory, pdp.getConfigurationDescriptor().getProjectMakefileName(), files);
        }
        return files;
    }

    public List<FileObject> getDataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        FileObject[] children = projectDirectory.getChildren();
        List<FileObject> metadataFiles = this.getMetadataFiles();
        for (int i = 0; i < children.length; ++i) {
            if (metadataFiles.indexOf(children[i]) >= 0) continue;
            files.add(children[i]);
        }
        if (files.isEmpty()) {
            files.add(projectDirectory);
        }
        return files;
    }

    public void notifyDeleting() throws IOException {
        LOGGER.log(Level.FINE, "notify Deleting MakeProject@{0}", new Object[]{System.identityHashCode(this.project)});
        this.project.setDeleted();
    }

    public void notifyDeleted() throws IOException {
        MakeProjectConfigurationProvider makeProjectConfigurationProvider;
        LOGGER.log(Level.FINE, "notify Deleted MakeProject@{0}", new Object[]{System.identityHashCode(this.project)});
        this.project.getAntProjectHelper().notifyDeleted();
        NativeProject nativeProject = (NativeProject)this.project.getLookup().lookup(NativeProject.class);
        if (nativeProject instanceof NativeProjectProvider) {
            ((NativeProjectProvider)nativeProject).fireProjectDeleted();
        }
        if ((makeProjectConfigurationProvider = (MakeProjectConfigurationProvider)this.project.getLookup().lookup(MakeProjectConfigurationProvider.class)) != null) {
            makeProjectConfigurationProvider.propertyChange(null);
        }
    }

    public void notifyCopying() {
        LOGGER.log(Level.FINE, "notify Copying MakeProject@{0}", new Object[]{System.identityHashCode(this.project)});
        MakeSharabilityQuery makeSharabilityQuery = (MakeSharabilityQuery)this.project.getLookup().lookup(MakeSharabilityQuery.class);
        makeSharabilityQuery.setPrivateShared(true);
    }

    public void notifyCopied(Project original, File originalPath, String nueName) {
        String newFilePath;
        if (original == null) {
            return;
        }
        String originalFilePath = originalPath.getPath();
        if (!originalFilePath.equals(newFilePath = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getPath())) {
            String fromNewToOriginal = CndPathUtilitities.getRelativePath((String)newFilePath, (String)originalFilePath) + "/";
            fromNewToOriginal = CndPathUtilitities.normalizeSlashes((String)fromNewToOriginal);
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            pdp.setRelativeOffset(fromNewToOriginal);
        }
        MakeProject.InfoInterface info = (MakeProject.InfoInterface)this.project.getLookup().lookup(ProjectInformation.class);
        info.setName(nueName);
        MakeSharabilityQuery makeSharabilityQuery = (MakeSharabilityQuery)original.getLookup().lookup(MakeSharabilityQuery.class);
        makeSharabilityQuery.setPrivateShared(false);
    }

    public void notifyMoving() throws IOException {
        LOGGER.log(Level.FINE, "notify Moving MakeProject@{0}", new Object[]{System.identityHashCode(this.project)});
        this.project.markDeleted();
        MakeSharabilityQuery makeSharabilityQuery = (MakeSharabilityQuery)this.project.getLookup().lookup(MakeSharabilityQuery.class);
        makeSharabilityQuery.setPrivateShared(true);
    }

    public void notifyMoved(Project original, File originalPath, String nueName) {
        ConfigurationDescriptorProvider pdp;
        String newFilePath;
        if (original == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        String originalFilePath = originalPath.getPath();
        if (!originalFilePath.equals(newFilePath = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getPath())) {
            String fromNewToOriginal = CndPathUtilitities.getRelativePath((String)newFilePath, (String)originalFilePath) + "/";
            fromNewToOriginal = CndPathUtilitities.normalizeSlashes((String)fromNewToOriginal);
            pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            pdp.setRelativeOffset(fromNewToOriginal);
        }
        MakeProject.InfoInterface info = (MakeProject.InfoInterface)this.project.getLookup().lookup(ProjectInformation.class);
        info.setName(nueName);
        pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor configurationDescriptor = pdp.getConfigurationDescriptor();
        ((ConfigurationDescriptor)configurationDescriptor).setModified();
    }

    public void notifyRenaming() throws IOException {
        LOGGER.log(Level.FINE, "notify Renaming MakeProject@{0}", new Object[]{System.identityHashCode(this.project)});
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor configurationDescriptor = pdp.getConfigurationDescriptor();
        ((ConfigurationDescriptor)configurationDescriptor).setModified();
    }

    public void notifyRenamed(String nueName) throws IOException {
        MakeProject.InfoInterface info = (MakeProject.InfoInterface)this.project.getLookup().lookup(ProjectInformation.class);
        info.setName(nueName);
        info.firePropertyChange("name");
        info.firePropertyChange("displayName");
    }
}

