/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.repository;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.repository.ChangesetPanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ChangesetPickerPanel
extends JPanel {
    private File repository;
    private File[] roots;
    private RequestProcessor.Task refreshViewTask;
    private static final RequestProcessor rp = new RequestProcessor("ChangesetPicker", 1, true);
    private HgLogMessage[] messages;
    private int fetchRevisionLimit = 7;
    private boolean bGettingRevisions = false;
    private Set<String> revisions;
    private static final String HG_TIP = "tip";
    private final MessageInfoFetcher defaultMessageInfoFetcher;
    private MessageInfoFetcher messageInfofetcher;
    private HgProgressSupport hgProgressSupport;
    private ChangesetPanel changesetPanel1;
    protected final JLabel jLabel1 = new JLabel();
    protected final JLabel jLabel2 = new JLabel();
    private JPanel jPanel1;
    private JComboBox revisionsComboBox;
    protected JLabel revisionsLabel;

    public ChangesetPickerPanel(File repo, File[] files) {
        this.repository = repo;
        this.roots = files;
        this.refreshViewTask = rp.create((Runnable)new RefreshViewTask());
        this.initComponents();
        this.jPanel1.setVisible(false);
        this.revisionsComboBox.setMaximumRowCount(10);
        this.defaultMessageInfoFetcher = new MessageInfoFetcher();
    }

    public File[] getRootFiles() {
        return this.roots;
    }

    public String[] getSelectedRevision() {
        String revStr = (String)this.revisionsComboBox.getSelectedItem();
        String changesetStr = new String();
        if (revStr != null) {
            if (revStr.equals(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Revision_Default")) || revStr.equals(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetch_20_Revisions")) || revStr.equals(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetch_50_Revisions")) || revStr.equals(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetch_All_Revisions")) || revStr.equals(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Tip_Revision"))) {
                revStr = HG_TIP;
            } else {
                revStr = revStr.substring(0, revStr.indexOf(" "));
                changesetStr = this.messages == null ? "" : this.messages[this.revisionsComboBox.getSelectedIndex()].getCSetShortID();
            }
        }
        return new String[]{revStr, changesetStr};
    }

    protected String getRefreshLabel() {
        return NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Refreshing_Revisions");
    }

    protected RepositoryRevision getDisplayedRevision() {
        return null;
    }

    protected void loadRevisions() {
        assert (this.revisions == null) : "Revisions already loaded";
        this.refreshViewTask.schedule(0);
    }

    protected void setOptionsPanel(JPanel optionsPanel, Border parentPanelBorder) {
        if (optionsPanel == null) {
            this.jPanel1.setVisible(false);
        } else {
            if (parentPanelBorder != null) {
                this.jPanel1.setBorder(parentPanelBorder);
            }
            this.jPanel1.removeAll();
            this.jPanel1.add((Component)optionsPanel, "North");
            this.jPanel1.setVisible(true);
        }
    }

    protected String getRevisionLabel(RepositoryRevision rev) {
        return rev.getLog().getRevisionNumber() + " (" + rev.getLog().getCSetShortID() + ")";
    }

    protected void setInitMessageInfoFetcher(MessageInfoFetcher fetcher) {
        this.messageInfofetcher = fetcher;
    }

    @Override
    public void removeNotify() {
        this.refreshViewTask.cancel();
        HgProgressSupport supp = this.hgProgressSupport;
        if (supp != null) {
            supp.cancel();
        }
        super.removeNotify();
    }

    private void initComponents() {
        this.revisionsLabel = new JLabel();
        this.revisionsComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.changesetPanel1 = new ChangesetPanel();
        this.revisionsLabel.setLabelFor(this.revisionsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.revisionsLabel, (String)NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.revisionsLabel.text"));
        this.revisionsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangesetPickerPanel.this.revisionsComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, null);
        this.jLabel2.setForeground(new Color(153, 153, 153));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, null);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.options")));
        this.jPanel1.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(41, 41, 41).add((Component)this.revisionsLabel).addPreferredGap(0).add((Component)this.revisionsComboBox, 0, 286, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel1, -1, 492, Short.MAX_VALUE))).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, 492, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.changesetPanel1, -1, 492, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1, -2, 25, -2).add(4, 4, 4).add((Component)this.jLabel2).add(17, 17, 17).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.revisionsLabel).add((Component)this.revisionsComboBox, -2, 28, -2)).addPreferredGap(0).add((Component)this.changesetPanel1, -2, 152, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2)));
    }

    private void revisionsComboBoxActionPerformed(ActionEvent evt) {
        int index = this.revisionsComboBox.getSelectedIndex();
        if (this.getMore((String)this.revisionsComboBox.getSelectedItem())) {
            return;
        }
        if (this.messages != null && index >= 0 && index < this.messages.length) {
            this.changesetPanel1.setInfo(this.messages[index]);
        }
    }

    private boolean getMore(String revStr) {
        if (this.bGettingRevisions) {
            return false;
        }
        boolean bGetMore = false;
        int limit = -1;
        if (revStr != null && revStr.equals(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetch_20_Revisions"))) {
            bGetMore = true;
            limit = 20;
        } else if (revStr != null && revStr.equals(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetch_50_Revisions"))) {
            bGetMore = true;
            limit = 50;
        } else if (revStr != null && revStr.equals(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetch_All_Revisions"))) {
            bGetMore = true;
            limit = -1;
        }
        if (bGetMore && !this.bGettingRevisions) {
            this.messageInfofetcher = this.defaultMessageInfoFetcher;
            this.fetchRevisionLimit = limit;
            this.hgProgressSupport = new HgProgressSupport(){

                @Override
                public void perform() {
                    ChangesetPickerPanel.this.refreshRevisions();
                    ChangesetPickerPanel.this.hgProgressSupport = null;
                }
            };
            this.hgProgressSupport.start(rp, this.repository, NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetching_Revisions"));
        }
        return bGetMore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupModels() {
        ProgressHandle ph;
        block5: {
            ph = ProgressHandleFactory.createHandle((String)this.getRefreshLabel());
            try {
                this.revisions = new LinkedHashSet<String>();
                RepositoryRevision displayedRevision = this.getDisplayedRevision();
                if (displayedRevision == null) {
                    this.revisions.add(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Tip_Revision"));
                } else {
                    this.revisions.add(this.getRevisionLabel(displayedRevision));
                }
                DefaultComboBoxModel<String> targetsModel = new DefaultComboBoxModel<String>(new Vector<String>(this.revisions));
                this.revisionsComboBox.setModel(targetsModel);
                Thread.interrupted();
                ph.start();
                if (displayedRevision == null) {
                    this.refreshRevisions();
                    break block5;
                }
                this.revisionsComboBox.setEditable(false);
                this.changesetPanel1.setInfo(displayedRevision.getLog());
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(ph){
                    final /* synthetic */ ProgressHandle val$ph;
                    {
                        this.val$ph = progressHandle;
                    }

                    @Override
                    public void run() {
                        this.val$ph.finish();
                    }
                });
                throw throwable;
            }
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void refreshRevisions() {
        this.bGettingRevisions = true;
        this.revisions.remove(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetch_20_Revisions"));
        this.revisions.remove(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetch_50_Revisions"));
        this.revisions.remove(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetch_All_Revisions"));
        DefaultComboBoxModel<String> targetsModel = new DefaultComboBoxModel<String>(new Vector<String>(this.revisions));
        this.revisionsComboBox.setModel(targetsModel);
        this.revisionsComboBox.setSelectedIndex(0);
        this.changesetPanel1.clearInfo();
        OutputLogger logger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
        MessageInfoFetcher fetcher = this.getMessageInfoFetcher();
        this.messages = fetcher.getMessageInfo(this.repository, (Set<File>)(this.roots == null ? null : new HashSet<File>(Arrays.asList(this.roots))), this.fetchRevisionLimit, logger);
        HgLogMessage.HgRevision parentRevision = null;
        if (this.messages.length > 0) {
            try {
                parentRevision = HgCommand.getParent(this.repository, null, null);
            }
            catch (HgException ex) {
                Mercurial.LOG.log(Level.FINE, null, ex);
            }
        }
        LinkedHashSet<String> targetRevsSet = new LinkedHashSet<String>();
        if (this.messages == null || this.messages.length == 0) {
            boolean size = false;
            targetRevsSet.add(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Revision_Default"));
        } else {
            int size = this.messages.length;
            for (int i = 0; i < size; ++i) {
                StringBuilder sb = new StringBuilder().append(this.messages[i].getRevisionNumber()).append(" (").append(this.messages[i].getCSetShortID());
                if (parentRevision != null && parentRevision.getRevisionNumber().equals(this.messages[i].getRevisionNumber())) {
                    sb.append(" - ").append(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_ChangesetPickerPanel.currentHead"));
                }
                sb.append(")");
                targetRevsSet.add(sb.toString());
            }
        }
        if (targetRevsSet.size() > 0) {
            targetRevsSet.add(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetch_20_Revisions"));
            targetRevsSet.add(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetch_50_Revisions"));
            targetRevsSet.add(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetch_All_Revisions"));
        }
        targetsModel = new DefaultComboBoxModel(new Vector(targetRevsSet));
        this.revisionsComboBox.setModel(targetsModel);
        if (targetRevsSet.size() > 0) {
            this.revisionsComboBox.setSelectedIndex(0);
        }
        this.revisions = targetRevsSet;
        this.bGettingRevisions = false;
    }

    private MessageInfoFetcher getMessageInfoFetcher() {
        MessageInfoFetcher f = this.messageInfofetcher;
        if (f == null) {
            f = this.defaultMessageInfoFetcher;
        }
        return f;
    }

    protected static class MessageInfoFetcher {
        protected MessageInfoFetcher() {
        }

        protected HgLogMessage[] getMessageInfo(File repository, Set<File> setRoots, int fetchRevisionLimit, OutputLogger logger) {
            return HgCommand.getLogMessagesNoFileInfo(repository, setRoots, fetchRevisionLimit, logger);
        }
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        @Override
        public void run() {
            ChangesetPickerPanel.this.setupModels();
        }
    }
}

