/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.CallStackTopComponent;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.CustomTimeLineViewport;
import org.netbeans.modules.dlight.visualizers.threadmap.DataManagerListener;
import org.netbeans.modules.dlight.visualizers.threadmap.JExtendedTable;
import org.netbeans.modules.dlight.visualizers.threadmap.OrderedEnumStateIterator;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadNameCellRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadNameHeaderRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStackActionsProvider;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateCellRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateHeaderRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateIcon;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadSummaryCellRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadSummaryColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsDataManager;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLine;
import org.netbeans.modules.dlight.visualizers.threadmap.UIUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class ThreadsPanel
extends JPanel
implements AdjustmentListener,
ActionListener,
TableColumnModelListener,
DataManagerListener,
ThreadStackActionsProvider {
    private static final String QUERY_STATE_ACTION_COMMAND = "query_state";
    private static final RequestProcessor RP = new RequestProcessor(ThreadsPanel.class.getName(), 1);
    private static final ResourceBundle messages = NbBundle.getBundle(ThreadsPanel.class);
    private static final String VIEW_THREADS_ALL = messages.getString("ThreadsPanel_ViewThreadsAll");
    private static final String VIEW_THREADS_LIVE = messages.getString("ThreadsPanel_ViewThreadsLive");
    private static final String VIEW_THREADS_FINISHED = messages.getString("ThreadsPanel_ViewThreadsFinished");
    private static final String VIEW_THREADS_SELECTION = messages.getString("ThreadsPanel_ViewThreadsSelection");
    private static final String THREADS_TABLE = messages.getString("ThreadsPanel_ThreadsTable");
    private static final String ENABLE_THREADS_PROFILING = messages.getString("ThreadsPanel_EnableThreadsProfiling");
    private static final String ZOOM_IN_TOOLTIP = messages.getString("ThreadsPanel_ZoomInToolTip");
    private static final String ZOOM_OUT_TOOLTIP = messages.getString("ThreadsPanel_ZoomOutToolTip");
    private static final String FIXED_SCALE_TOOLTIP = messages.getString("ThreadsPanel_FixedScaleToolTip");
    private static final String SCALE_TO_FIT_TOOLTIP = messages.getString("ThreadsPanel_ScaleToFitToolTip");
    private static final String THREADS_COLUMN_NAME = messages.getString("ThreadsPanel_ThreadsColumnName");
    private static final String TIMELINE_COLUMN_NAME = messages.getString("ThreadsPanel_TimelineColumnName");
    private static final String SUMMARY_COLUMN_NAME = messages.getString("ThreadsPanel_SummaryColumnName");
    private static final String SELECTED_THREADS_ITEM = messages.getString("ThreadsPanel_SelectedThreadsItem");
    private static final String SHOW_LEGEND = messages.getString("ThreadsPanel_ShowLegend");
    private static final String HIDE_LEGEND = messages.getString("ThreadsPanel_HideLegend");
    private static final String SELECT_THREAD_NAME = messages.getString("ThreadsPanel_SelectThreadName");
    static final String THREAD_NAME_ID = messages.getString("ThreadsPanel_ThreadNameId");
    static final String THREAD_NAME_CALLEE = messages.getString("ThreadsPanel_ThreadNameCallee");
    static final String THREAD_NAME_CALLEE_CALLEE = messages.getString("ThreadsPanel_ThreadNameCalleeCallee");
    static final String THREAD_NAME_FORMAT_TOOL_TIP = messages.getString("ThreadsPanel_ChangeThreadNameFormatToolTip");
    private static final String NAVIGATE = messages.getString("ThreadsPanel_Navigate");
    private static final String NAVIGATE_CARET_LEFT = messages.getString("ThreadsPanel_NavigateCaretLeft");
    private static final String NAVIGATE_CARET_RIGHT = messages.getString("ThreadsPanel_NavigateCaretRight");
    private static final String NAVIGATE_SET_CARET = messages.getString("ThreadsPanel_NavigateSetCaret");
    private static final String NAVIGATE_STACK_VIEW = messages.getString("ThreadsPanel_NavigateStackView");
    private static final String CLOSE_LEGEND_TOOLTIP = messages.getString("ThreadsPanel_CloseLegendToolTip");
    private static final String TABLE_ACCESS_NAME = messages.getString("ThreadsPanel_TableAccessName");
    private static final String TABLE_ACCESS_DESCR = messages.getString("ThreadsPanel_TableAccessDescr");
    private static final String COMBO_ACCESS_NAME = messages.getString("ThreadsPanel_ComboAccessName");
    private static final String COMBO_ACCESS_DESCR = messages.getString("ThreadsPanel_ComboAccessDescr");
    private static final String VIEW_MODE_SIMPLE = messages.getString("ThreadsPanel_SimpleViewMode");
    private static final String VIEW_MODE_MSA = messages.getString("ThreadsPanel_SimpleMSAViewMode");
    private static final String VIEW_MODE_MSA_FULL = messages.getString("ThreadsPanel_FulleMSAViewMode");
    private static final String VIEW_MODE_COMBO_ACCESS_NAME = messages.getString("ThreadsPanel_ViewModeComboAccessName");
    private static final String VIEW_MODE_COMBO_ACCESS_DESCR = messages.getString("ThreadsPanel_ViewModeComboAccessDescr");
    private static final String SHOW_LABEL_TEXT = messages.getString("ThreadsPanel_ShowLabelText");
    private static final String VIEW_MODE_LABEL_TEXT = messages.getString("ThreadsPanel_ViewModeLabelText");
    private static final int NAME_COLUMN_INDEX = 0;
    private static final int DISPLAY_COLUMN_INDEX = 1;
    private static final int SUMMARY_COLUMN_INDEX = 2;
    private static final int RIGHT_DISPLAY_MARGIN = 20;
    private static final int LEFT_DISPLAY_MARGIN = 20;
    private static final int NAME_COLUMN_WIDTH = 100;
    private static final int MIN_NAME_COLUMN_WIDTH = 55;
    static final int MIN_SUMMARY_COLUMN_WIDTH = 72;
    static final int TABLE_ROW_HEIGHT = 18;
    static final int THREAD_LINE_TOP_BOTTOM_MARGIN = 3;
    private ArrayList<Integer> filteredDataToDataIndex = new ArrayList();
    private CustomTimeLineViewport viewPort;
    private DefaultComboBoxModel comboModel;
    private DefaultComboBoxModel viewModeComboModel;
    private DefaultComboBoxModel comboModelWithSelection;
    private JButton scaleToFitButton;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JComboBox threadsSelectionCombo;
    private JComboBox viewModeSelectionCombo;
    private JPanel legendPanel;
    private JMenuItem showOnlySelectedThreads;
    private JMenuItem showLegend;
    private JMenuItem hideLegend;
    private JMenu selectThreadName;
    private JRadioButtonMenuItem idThreadName;
    private JRadioButtonMenuItem calleeThreadName;
    private JRadioButtonMenuItem calleeCalleeThreadName;
    private JPanel contentPanel;
    private JPanel notificationPanel;
    private JPopupMenu popupMenu;
    private JScrollBar scrollBar;
    private JScrollPane tableScroll;
    private JTable table;
    private JToolBar buttonsToolBar;
    private ThreadsDataManager manager;
    private ThreadsDetailsCallback detailsCallback;
    private Collection<TimeIntervalDataFilter> timeFilters;
    private boolean internalChange = false;
    private boolean internalScrollbarChange = false;
    private boolean scaleToFit = false;
    private boolean threadsMonitoringEnabled = false;
    private boolean trackingEnd = true;
    private float zoomResolutionPerPixel = 50.0f;
    private long viewEnd;
    private long viewStart = -1L;
    private int sortedColum = -1;
    private int sortedOrder = 0;
    private TimeLine timeLine;
    private String selectedViewMode = VIEW_MODE_SIMPLE;
    private final List<String> fullMSAModeValues = Arrays.asList(VIEW_MODE_MSA_FULL);
    private final List<String> msaModeValues = Arrays.asList(VIEW_MODE_MSA, VIEW_MODE_MSA_FULL);
    private boolean isShowLegend = true;
    private RequestProcessor.Task showStackTask = null;

    public ThreadsPanel(ThreadsDataManager manager, ThreadsDetailsCallback detailsCallback) {
        this.manager = manager;
        this.detailsCallback = detailsCallback;
        this.contentPanel = new JPanel(new CardLayout());
        this.table = this.createViewTable();
        this.table.setGridColor(UIUtils.TABLE_VERTICAL_GRID_COLOR);
        this.table.getAccessibleContext().setAccessibleName(TABLE_ACCESS_NAME);
        this.table.getAccessibleContext().setAccessibleDescription(TABLE_ACCESS_DESCR);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.table.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsPanel.this.performDefaultAction();
            }
        });
        this.scrollBar = new ThreadsScrollBar();
        this.zoomInButton = new JButton(new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/zoomIn.png")));
        this.zoomOutButton = new JButton(new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/zoomOut.png")));
        this.scaleToFitButton = new JButton(new ImageIcon(this.getClass().getResource(this.scaleToFit ? "/org/netbeans/modules/dlight/visualizers/threadmap/resources/zoom.png" : "/org/netbeans/modules/dlight/visualizers/threadmap/resources/scaleToFit.png")));
        this.comboModel = new DefaultComboBoxModel<Object>(new Object[]{VIEW_THREADS_ALL, VIEW_THREADS_LIVE, VIEW_THREADS_FINISHED});
        this.comboModelWithSelection = new DefaultComboBoxModel<Object>(new Object[]{VIEW_THREADS_ALL, VIEW_THREADS_LIVE, VIEW_THREADS_FINISHED, VIEW_THREADS_SELECTION});
        this.threadsSelectionCombo = new JComboBox(this.comboModel){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(120, this.getPreferredSize().height);
            }
        };
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleName(COMBO_ACCESS_NAME);
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleDescription(COMBO_ACCESS_DESCR);
        JLabel showLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)showLabel, (String)SHOW_LABEL_TEXT);
        showLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        showLabel.setLabelFor(this.threadsSelectionCombo);
        this.viewModeComboModel = new DefaultComboBoxModel<Object>(new Object[]{VIEW_MODE_SIMPLE, VIEW_MODE_MSA, VIEW_MODE_MSA_FULL});
        this.viewModeSelectionCombo = new JComboBox(this.viewModeComboModel){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(120, this.getPreferredSize().height);
            }
        };
        this.viewModeSelectionCombo.getAccessibleContext().setAccessibleName(VIEW_MODE_COMBO_ACCESS_NAME);
        this.viewModeSelectionCombo.getAccessibleContext().setAccessibleDescription(VIEW_MODE_COMBO_ACCESS_DESCR);
        JLabel viewModeLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)viewModeLabel, (String)VIEW_MODE_LABEL_TEXT);
        viewModeLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        viewModeLabel.setLabelFor(this.viewModeSelectionCombo);
        this.buttonsToolBar = new JToolBar(0){

            @Override
            public Component add(Component comp) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((JButton)comp);
                }
                return super.add(comp);
            }
        };
        JPanel tablePanel = new JPanel();
        JPanel scrollPanel = new JPanel();
        this.zoomInButton.setEnabled(!this.scaleToFit);
        this.zoomOutButton.setEnabled(!this.scaleToFit);
        this.zoomInButton.setToolTipText(ZOOM_IN_TOOLTIP);
        this.zoomOutButton.setToolTipText(ZOOM_OUT_TOOLTIP);
        this.scaleToFitButton.setToolTipText(this.scaleToFit ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
        this.zoomInButton.getAccessibleContext().setAccessibleName(this.zoomInButton.getToolTipText());
        this.zoomOutButton.getAccessibleContext().setAccessibleName(this.zoomOutButton.getToolTipText());
        this.scaleToFitButton.getAccessibleContext().setAccessibleName(this.scaleToFitButton.getToolTipText());
        this.table.setSelectionMode(2);
        this.table.setSelectionBackground(UIUtils.TABLE_SELECTION_BACKGROUND_COLOR);
        this.table.setSelectionForeground(UIUtils.TABLE_SELECTION_FOREGROUND_COLOR);
        this.table.setShowGrid(false);
        this.table.setRowMargin(0);
        this.table.setRowHeight(18);
        DefaultTableCellRenderer defaultHeaderRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setBackground(Color.WHITE);
                component.setFont(table.getFont().deriveFont(1));
                if (component instanceof JComponent) {
                    ((JComponent)component).setBorder(new EmptyBorder(0, 3, 0, 3));
                    if (component instanceof JLabel) {
                        if (column == ThreadsPanel.this.sortedColum && ThreadsPanel.this.sortedOrder != 0) {
                            ((JLabel)component).setIcon(this.getProperIcon(ThreadsPanel.this.sortedOrder == -1));
                        } else {
                            ((JLabel)component).setIcon(null);
                        }
                    }
                }
                return component;
            }

            private ImageIcon getProperIcon(boolean descending) {
                if (descending) {
                    return new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/columnsSortedDesc.png"));
                }
                return new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/columnsSortedAsc.png"));
            }
        };
        this.table.getTableHeader().setDefaultRenderer(defaultHeaderRenderer);
        this.table.getTableHeader().setReorderingAllowed(false);
        ThreadNameHeaderRenderer nameHeaderRenderer = new ThreadNameHeaderRenderer(this);
        nameHeaderRenderer.setBackground(Color.WHITE);
        this.table.setAutoResizeMode(1);
        this.table.getColumnModel().getColumn(0).setHeaderRenderer(nameHeaderRenderer);
        this.table.getColumnModel().getColumn(0).setMinWidth(55);
        this.table.getColumnModel().getColumn(0).setMaxWidth(1000);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        ThreadStateHeaderRenderer headerRenderer = new ThreadStateHeaderRenderer(this);
        headerRenderer.setBackground(Color.WHITE);
        this.table.getColumnModel().getColumn(1).setHeaderRenderer(headerRenderer);
        this.table.getColumnModel().getColumn(2).setMinWidth(72);
        this.table.getColumnModel().getColumn(2).setMaxWidth(72);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(72);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.setColumnSelectionAllowed(false);
        columnModel.setColumnMargin(0);
        this.table.setDefaultRenderer(ThreadNameCellRenderer.class, new ThreadNameCellRenderer(this));
        this.table.setDefaultRenderer(ThreadStateCellRenderer.class, new ThreadStateCellRenderer(this));
        this.table.setDefaultRenderer(ThreadSummaryCellRenderer.class, new ThreadSummaryCellRenderer(this));
        this.buttonsToolBar.setFloatable(false);
        this.buttonsToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        tablePanel.setLayout(new BorderLayout());
        scrollPanel.setLayout(new BorderLayout());
        scrollPanel.setBackground(Color.WHITE);
        this.buttonsToolBar.add(this.zoomInButton);
        this.buttonsToolBar.add(this.zoomOutButton);
        this.buttonsToolBar.add(this.scaleToFitButton);
        this.buttonsToolBar.addSeparator();
        this.buttonsToolBar.add(showLabel);
        this.buttonsToolBar.add(this.threadsSelectionCombo);
        this.buttonsToolBar.add(viewModeLabel);
        this.buttonsToolBar.add(this.viewModeSelectionCombo);
        scrollPanel.add((Component)this.scrollBar, "Center");
        JPanel filler = new JPanel();
        filler.setBackground(Color.WHITE);
        filler.setPreferredSize(new Dimension(72, 0));
        scrollPanel.add((Component)filler, "East");
        JPanel rest = new JPanel();
        rest.setLayout(new BorderLayout());
        rest.setBackground(Color.WHITE);
        scrollPanel.add((Component)rest, "Center");
        rest.add((Component)this.scrollBar, "East");
        this.legendPanel = new JPanel();
        this.legendPanel.setLayout(new BorderLayout());
        this.legendPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initLegend(this.isFullMode());
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        bottomPanel.add((Component)this.legendPanel, "East");
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout(new BorderLayout());
        dataPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.tableScroll = new JScrollPane();
        this.tableScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.tableScroll.setCorner("UPPER_RIGHT_CORNER", new JPanel());
        this.tableScroll.getCorner("UPPER_RIGHT_CORNER").setBackground(Color.WHITE);
        this.viewPort = new CustomTimeLineViewport(this);
        this.viewPort.setView(this.table);
        this.viewPort.setBackground(this.table.getBackground());
        this.tableScroll.setViewport(this.viewPort);
        this.tableScroll.setHorizontalScrollBarPolicy(31);
        this.tableScroll.setVerticalScrollBarPolicy(20);
        dataPanel.add((Component)this.tableScroll, "Center");
        dataPanel.add((Component)scrollPanel, "South");
        tablePanel.add((Component)dataPanel, "Center");
        tablePanel.add((Component)bottomPanel, "South");
        this.notificationPanel = new JPanel(new FlowLayout(3, 0, 15));
        this.notificationPanel.setBorder(dataPanel.getBorder());
        this.notificationPanel.setBackground(this.table.getBackground());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.notificationPanel, ENABLE_THREADS_PROFILING);
        this.contentPanel.add((Component)tablePanel, THREADS_TABLE);
        this.add((Component)this.buttonsToolBar, "North");
        this.add((Component)this.contentPanel, "Center");
        this.scrollBar.addAdjustmentListener(this);
        this.scrollBar.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int unitsToScroll;
                if (e.getScrollType() == 0 && (unitsToScroll = e.getUnitsToScroll()) != 0) {
                    int direction = unitsToScroll < 0 ? -1 : 1;
                    int increment = ThreadsPanel.this.scrollBar.getUnitIncrement(direction);
                    int oldValue = ThreadsPanel.this.scrollBar.getValue();
                    int newValue = oldValue + increment * unitsToScroll;
                    if (oldValue != (newValue = Math.max(Math.min(newValue, ThreadsPanel.this.scrollBar.getMaximum() - ThreadsPanel.this.scrollBar.getVisibleAmount()), ThreadsPanel.this.scrollBar.getMinimum()))) {
                        ThreadsPanel.this.scrollBar.setValue(newValue);
                    }
                }
            }
        });
        this.zoomInButton.addActionListener(this);
        this.zoomOutButton.addActionListener(this);
        this.scaleToFitButton.addActionListener(this);
        this.threadsSelectionCombo.addActionListener(this);
        this.viewModeSelectionCombo.addActionListener(this);
        this.viewModeSelectionCombo.setSelectedIndex(Math.min(NbPreferences.forModule(this.getClass()).getInt("ViewMode", 0), this.viewModeComboModel.getSize() - 1));
        this.table.getColumnModel().addColumnModelListener(this);
        this.table.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ThreadsPanel.this.refreshViewData();
                ThreadsPanel.this.updateScrollbar();
                ThreadsPanel.this.updateZoomButtonsEnabledState();
                ThreadsPanel.this.revalidate();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int selectedRow;
                if ((e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) && (selectedRow = ThreadsPanel.this.table.getSelectedRow()) != -1) {
                    Rectangle cellRect = ThreadsPanel.this.table.getCellRect(selectedRow, 0, false);
                    ThreadsPanel.this.showLegend.setVisible(!ThreadsPanel.this.isShowLegend);
                    ThreadsPanel.this.hideLegend.setVisible(ThreadsPanel.this.isShowLegend);
                    ThreadsPanel.this.popupMenu.show(e.getComponent(), cellRect.x + ((ThreadsPanel)ThreadsPanel.this).table.getSize().width > 50 ? 50 : 5, cellRect.y);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int line;
                if ((e.getModifiers() & 4) != 0 && (line = ThreadsPanel.this.table.rowAtPoint(e.getPoint())) != -1 && !ThreadsPanel.this.table.isRowSelected(line)) {
                    if (e.isControlDown()) {
                        ThreadsPanel.this.table.addRowSelectionInterval(line, line);
                    } else {
                        ThreadsPanel.this.table.setRowSelectionInterval(line, line);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int clickedLine = ThreadsPanel.this.table.rowAtPoint(e.getPoint());
                if (clickedLine != -1) {
                    if ((e.getModifiers() & 4) != 0) {
                        ThreadsPanel.this.showLegend.setVisible(!ThreadsPanel.this.isShowLegend);
                        ThreadsPanel.this.hideLegend.setVisible(ThreadsPanel.this.isShowLegend);
                        ThreadsPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    } else if (e.getModifiers() == 16) {
                        if (e.getClickCount() == 1) {
                            ThreadsPanel.this.onClickAction(e);
                        } else if (e.getClickCount() == 2) {
                            ThreadsPanel.this.performDefaultAction();
                        }
                    }
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = ThreadsPanel.this.table.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = ThreadsPanel.this.table.convertColumnIndexToModel(viewColumn);
                if (e.getModifiers() == 16) {
                    ThreadNameHeaderRenderer renderer;
                    Rectangle rect;
                    if (column == 0 && (rect = (renderer = (ThreadNameHeaderRenderer)ThreadsPanel.this.table.getColumnModel().getColumn(0).getHeaderRenderer()).getFormatRectangle()) != null && rect.getX() <= (double)e.getX() && (double)e.getX() <= rect.getX() + rect.getWidth()) {
                        ThreadsPanel.this.setThreadNameFormat(ThreadsPanel.this.getThreadNameFormat() + 1);
                        return;
                    }
                    if (e.getClickCount() == 1 && column != -1) {
                        ThreadsPanel.this.sortByColumn(column);
                    }
                }
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && ThreadsPanel.this.isShowing()) {
                    ThreadsPanel.this.dataChanged();
                }
            }
        });
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.table.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.table.setFocusTraversalKeys(0, keys);
        keys = new HashSet<AWTKeyStroke>(this.table.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.table.setFocusTraversalKeys(1, keys);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(49, 8, true), "ascSortFor1");
        this.table.getActionMap().put("ascSortFor1", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsPanel.this.sortByColumn(0);
            }
        });
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(51, 8, true), "ascSortFor3");
        this.table.getActionMap().put("ascSortFor3", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsPanel.this.sortByColumn(2);
            }
        });
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(37, 2, true), "leftTimeLine");
        AbstractAction action = new AbstractAction(NAVIGATE_CARET_LEFT){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsPanel.this.shiftTimeLine(-1);
            }
        };
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 2, true));
        this.table.getActionMap().put("leftTimeLine", action);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(39, 2, true), "rightTimeLine");
        action = new AbstractAction(NAVIGATE_CARET_RIGHT){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsPanel.this.shiftTimeLine(1);
            }
        };
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 2, true));
        this.table.getActionMap().put("rightTimeLine", action);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(40, 2, true), "newTimeLine");
        action = new AbstractAction(NAVIGATE_SET_CARET){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsPanel.this.shiftTimeLine(0);
            }
        };
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 2, true));
        this.table.getActionMap().put("newTimeLine", action);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(40, 8, true), "focuseStack");
        action = new AbstractAction(NAVIGATE_STACK_VIEW){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallStackTopComponent.getDefault().requestFocus(false);
            }
        };
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 8, true));
        this.table.getActionMap().put("focuseStack", action);
        this.scrollBar.setFocusable(true);
        this.popupMenu = this.initPopupMenu();
        this.updateScrollbar();
        this.updateZoomButtonsEnabledState();
        manager.addDataListener(this);
    }

    private void initLegend(boolean isFull) {
        this.legendPanel.removeAll();
        if (!this.isShowLegend) {
            return;
        }
        JButton close = new JButton((Icon)new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/win_close_enabled.png"))){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(12, 12);
            }
        };
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsPanel.this.isShowLegend = false;
                ThreadsPanel.this.initLegend(ThreadsPanel.this.isFullMode());
                ThreadsPanel.this.refreshUI();
                ThreadsPanel.this.viewPort.repaint();
            }
        });
        close.setToolTipText(CLOSE_LEGEND_TOOLTIP);
        this.legendPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 6, 0, 0), 0, 0);
        this.legendPanel.add((Component)close, constraints);
        if (!isFull) {
            JPanel container = new JPanel();
            container.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            container.add(this.createLegendLabel(ThreadState.MSAState.Running, ThreadStateResources.THREAD_RUNNING));
            container.add(this.createLegendLabel(ThreadState.MSAState.Blocked, ThreadStateResources.THREAD_BLOCKED));
            container.add(this.createLegendLabel(ThreadState.MSAState.Waiting, ThreadStateResources.THREAD_WAITING));
            container.add(this.createLegendLabel(ThreadState.MSAState.Sleeping, ThreadStateResources.THREAD_SLEEPING));
            constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.legendPanel.add((Component)container, constraints);
        } else {
            JPanel container = new JPanel();
            container.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            container.add(this.createLegendLabel(ThreadState.MSAState.RunningUser, ThreadStateResources.THREAD_RUNNING_USER));
            container.add(this.createLegendLabel(ThreadState.MSAState.RunningSystemCall, ThreadStateResources.THREAD_RUNNING_SYSTEM));
            container.add(this.createLegendLabel(ThreadState.MSAState.RunningOther, ThreadStateResources.THREAD_RUNNING_OTHER));
            container.add(this.createLegendLabel(ThreadState.MSAState.WaitingCPU, ThreadStateResources.THREAD_WAITING_CPU));
            container.add(this.createLegendLabel(ThreadState.MSAState.SleepingUserLock, ThreadStateResources.THREAD_SLEEP_USE_LOCK));
            constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.legendPanel.add((Component)container, constraints);
            container = new JPanel();
            container.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            container.add(this.createLegendLabel(ThreadState.MSAState.ThreadStopped, ThreadStateResources.THREAD_THREAD_STOPPED));
            container.add(this.createLegendLabel(ThreadState.MSAState.SleepingOther, ThreadStateResources.THREAD_SLEEPING_OTHER));
            container.add(this.createLegendLabel(ThreadState.MSAState.SleepingUserDataPageFault, ThreadStateResources.THREAD_SLEEPING_USER_DATA_PAGE_FAULT));
            container.add(this.createLegendLabel(ThreadState.MSAState.SleepingUserTextPageFault, ThreadStateResources.THREAD_SLEEPING_USER_TEXT_PAGE_FAULT));
            container.add(this.createLegendLabel(ThreadState.MSAState.SleepingKernelPageFault, ThreadStateResources.THREAD_SLEEPING_KERNEL_PAGE_FAULT));
            constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.legendPanel.add((Component)container, constraints);
        }
    }

    private JLabel createLegendLabel(ThreadState.MSAState state, ThreadStateResources resources) {
        ThreadStateIcon icon = new ThreadStateIcon(state, 10, 10);
        JLabel label = new JLabel(resources.name, icon, 10);
        label.setToolTipText(resources.tooltip);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return label;
    }

    private void sortByColumn(int column) {
        if (column == 0 || column == 2) {
            if (this.sortedColum == column) {
                if (this.sortedOrder == 1) {
                    this.sortedOrder = -1;
                } else if (this.sortedOrder == -1) {
                    this.sortedOrder = 0;
                } else if (this.sortedOrder == 0) {
                    this.sortedOrder = 1;
                }
            } else {
                this.sortedColum = column;
                this.sortedOrder = 1;
            }
        }
        this.refreshUI();
    }

    private void shiftTimeLine(int shift) {
        long time2;
        long time1;
        ThreadState state;
        int i;
        int rowIndex = this.table.getSelectedRow();
        if (rowIndex < 0) {
            return;
        }
        int row = this.filteredDataToDataIndex.get(rowIndex);
        ThreadStateColumnImpl threadData = null;
        ThreadState bestCandidate = null;
        if (this.timeLine == null || shift == 0) {
            long middle = (this.getViewStart() + this.getViewEnd()) / 2L;
            if (middle == 0L) {
                return;
            }
            threadData = this.manager.getThreadData(row);
            for (i = 0; i < threadData.size(); ++i) {
                state = threadData.getThreadStateAt(i);
                if (bestCandidate == null) {
                    bestCandidate = state;
                }
                time1 = ThreadStateColumnImpl.timeStampToMilliSeconds(bestCandidate.getTimeStamp());
                time2 = ThreadStateColumnImpl.timeStampToMilliSeconds(state.getTimeStamp());
                if (Math.abs(middle - time1) <= Math.abs(middle - time2)) continue;
                bestCandidate = state;
            }
            if (bestCandidate == null) {
                return;
            }
            this.timeLine = new TimeLine(bestCandidate.getTimeStamp(), this.manager.getStartTime(), (int)bestCandidate.getMSASamplePeriod());
        } else {
            long current = this.timeLine.getTimeStamp();
            if (shift < 0) {
                current -= (long)this.timeLine.getInterval();
            } else if (shift > 0) {
                current += (long)this.timeLine.getInterval();
            }
            threadData = this.manager.getThreadData(row);
            for (i = 0; i < threadData.size(); ++i) {
                state = threadData.getThreadStateAt(i);
                if (bestCandidate == null) {
                    bestCandidate = state;
                }
                time1 = ThreadStateColumnImpl.timeStampToMilliSeconds(bestCandidate.getTimeStamp());
                time2 = ThreadStateColumnImpl.timeStampToMilliSeconds(state.getTimeStamp());
                if (Math.abs(current - time1) <= Math.abs(current - time2)) continue;
                bestCandidate = state;
            }
            if (bestCandidate == null) {
                return;
            }
            this.timeLine = new TimeLine(bestCandidate.getTimeStamp(), this.manager.getStartTime(), (int)bestCandidate.getMSASamplePeriod());
        }
        ThreadState.MSAState prefferedState = null;
        EnumMap<ThreadState.MSAState, AtomicInteger> aMap = new EnumMap<ThreadState.MSAState, AtomicInteger>(ThreadState.MSAState.class);
        ThreadStateColumnImpl.fillMap(this, bestCandidate, aMap);
        ThreadStateColumnImpl.roundMap(aMap);
        int maxValue = 0;
        OrderedEnumStateIterator it = new OrderedEnumStateIterator(aMap);
        while (it.hasNext()) {
            Object e = it.next();
            ThreadState.MSAState msa = (ThreadState.MSAState)e.getKey();
            if (prefferedState == null) {
                prefferedState = msa;
                maxValue = ((AtomicInteger)e.getValue()).intValue();
            }
            if (maxValue >= ((AtomicInteger)e.getValue()).intValue()) continue;
            prefferedState = msa;
            maxValue = ((AtomicInteger)e.getValue()).intValue();
        }
        bestCandidate.getMSAState(rowIndex, this.isFullMode());
        this.showStacksAtTimeLine(threadData, bestCandidate, prefferedState);
    }

    public long getDataEnd() {
        return this.manager.getEndTime();
    }

    public long getDataStart() {
        return this.manager.getStartTime();
    }

    public int getDisplayColumnWidth() {
        return this.table.getTableHeader().getHeaderRect((int)1).width;
    }

    public int getDisplayColumnRest() {
        return this.table.getTableHeader().getHeaderRect((int)2).width;
    }

    public ThreadStateColumnImpl getThreadData(int index) {
        return this.manager.getThreadData(index);
    }

    public ThreadSummaryColumnImpl getThreadSummary(int index) {
        return this.manager.getThreadSummary(index);
    }

    public int getSortedColumn() {
        return this.sortedColum;
    }

    public int getSortedOrder() {
        return this.sortedOrder;
    }

    public String getThreadName(int index) {
        return this.manager.getThreadName(index);
    }

    public long getViewEnd() {
        return this.viewEnd;
    }

    public long getViewStart() {
        return this.viewStart;
    }

    public TimeLine getTimeLine() {
        return this.timeLine;
    }

    private void queryChanged(final ThreadDumpQuery query, final ThreadState state) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ThreadsPanel.this.detailsCallback.showStack(state.getTimeStamp(), query);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem item;
        Object o;
        if (this.internalChange) {
            return;
        }
        if (e.getSource() == this.scaleToFitButton) {
            if (!this.scaleToFit) {
                this.scrollBar.setVisible(true);
                this.scaleToFitButton.setIcon(new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/zoom.png")));
                this.scaleToFit = true;
            } else {
                this.scaleToFit = false;
                this.scaleToFitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/scaleToFit.png")));
                this.scrollBar.setVisible(false);
                this.scrollBar.setValues(0, 0, 0, 0);
            }
            this.refreshViewData();
            this.updateScrollbar();
            this.updateZoomButtonsEnabledState();
            this.table.getTableHeader().repaint();
            this.viewPort.repaint();
        } else if (e.getSource() == this.zoomInButton) {
            this.zoomInButton.setEnabled((double)this.zoomResolutionPerPixel > 0.1);
            this.zoomResolutionPerPixel /= 2.0f;
            this.refreshViewData();
            this.updateScrollbar();
            this.updateZoomButtonsEnabledState();
            this.table.getTableHeader().repaint();
            this.viewPort.repaint();
        } else if (e.getSource() == this.zoomOutButton) {
            this.zoomResolutionPerPixel *= 2.0f;
            this.refreshViewData();
            this.updateScrollbar();
            this.updateZoomButtonsEnabledState();
            this.table.getTableHeader().repaint();
            this.viewPort.repaint();
        } else if (e.getSource() == this.threadsSelectionCombo) {
            if (this.threadsSelectionCombo.getModel() == this.comboModelWithSelection && this.threadsSelectionCombo.getSelectedItem() != VIEW_THREADS_SELECTION) {
                this.internalChange = true;
                Object selectedItem = this.threadsSelectionCombo.getSelectedItem();
                this.threadsSelectionCombo.setModel(this.comboModel);
                this.threadsSelectionCombo.setSelectedItem(selectedItem);
                this.internalChange = false;
            }
            this.table.clearSelection();
            this.dataChanged();
        } else if (e.getSource() == this.showOnlySelectedThreads) {
            for (int i = this.filteredDataToDataIndex.size() - 1; i >= 0; --i) {
                if (this.table.isRowSelected(i)) continue;
                this.filteredDataToDataIndex.remove(i);
            }
            this.threadsSelectionCombo.setModel(this.comboModelWithSelection);
            this.threadsSelectionCombo.setSelectedItem(VIEW_THREADS_SELECTION);
            this.table.clearSelection();
        } else if (e.getSource() == this.showLegend) {
            this.isShowLegend = true;
            this.initLegend(this.isFullMode());
            this.refreshUI();
            this.viewPort.repaint();
        } else if (e.getSource() == this.hideLegend) {
            this.isShowLegend = false;
            this.initLegend(this.isFullMode());
            this.refreshUI();
            this.viewPort.repaint();
        } else if (e.getSource() == this.viewModeSelectionCombo) {
            this.selectedViewMode = this.viewModeSelectionCombo.getSelectedItem() + "";
            NbPreferences.forModule(this.getClass()).putInt("ViewMode", this.viewModeSelectionCombo.getSelectedIndex());
            this.initLegend(this.isFullMode());
            this.refreshUI();
            this.viewPort.repaint();
        } else if (e.getSource() == this.idThreadName) {
            this.setThreadNameFormat(0);
        } else if (e.getSource() == this.calleeThreadName) {
            this.setThreadNameFormat(1);
        } else if (e.getSource() == this.calleeCalleeThreadName) {
            this.setThreadNameFormat(2);
        } else if (e.getSource() instanceof JMenuItem && (o = (item = (JMenuItem)e.getSource()).getClientProperty("query")) instanceof ThreadDumpQuery) {
            ThreadDumpQuery query = (ThreadDumpQuery)o;
            ThreadState state = (ThreadState)item.getClientProperty("state");
            this.queryChanged(query, state);
        }
    }

    public int getThreadNameFormat() {
        return this.manager.getThreadNameFormat();
    }

    public void setThreadNameFormat(int i) {
        switch (i) {
            case 1: {
                NbPreferences.forModule(this.getClass()).putInt("ThreadName", 1);
                this.manager.setThreadNameFormat(1, false);
                this.idThreadName.setSelected(false);
                this.calleeThreadName.setSelected(true);
                this.calleeCalleeThreadName.setSelected(false);
                break;
            }
            case 2: {
                NbPreferences.forModule(this.getClass()).putInt("ThreadName", 2);
                this.manager.setThreadNameFormat(2, false);
                this.idThreadName.setSelected(false);
                this.calleeThreadName.setSelected(false);
                this.calleeCalleeThreadName.setSelected(true);
                break;
            }
            default: {
                NbPreferences.forModule(this.getClass()).putInt("ThreadName", 0);
                this.manager.setThreadNameFormat(0, false);
                this.idThreadName.setSelected(true);
                this.calleeThreadName.setSelected(false);
                this.calleeCalleeThreadName.setSelected(false);
            }
        }
    }

    final boolean isFullMode() {
        return this.fullMSAModeValues.contains(this.selectedViewMode);
    }

    boolean isMSAMode() {
        return this.msaModeValues.contains(this.selectedViewMode);
    }

    public void addSaveViewAction(AbstractAction saveViewAction) {
        JButton actionButton = this.buttonsToolBar.add(saveViewAction);
        this.buttonsToolBar.remove(actionButton);
        this.buttonsToolBar.add((Component)actionButton, 0);
        this.buttonsToolBar.add((Component)new JToolBar.Separator(), 1);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.internalScrollbarChange) {
            if (this.scrollBar.getValue() + this.scrollBar.getVisibleAmount() == this.scrollBar.getMaximum()) {
                this.trackingEnd = true;
            } else {
                this.trackingEnd = false;
                this.viewStart = this.manager.getStartTime() + (long)this.scrollBar.getValue();
                this.viewEnd = this.viewStart + (long)(this.zoomResolutionPerPixel * (float)this.table.getTableHeader().getHeaderRect((int)1).width);
                this.repaint();
            }
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        this.refreshViewData();
        this.updateScrollbar();
        this.updateZoomButtonsEnabledState();
        if (this.viewPort != null) {
            this.viewPort.repaint();
        }
        this.scrollBar.invalidate();
        this.revalidate();
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    @Override
    public void dataChanged() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThreadsPanel.this.refreshUI();
            }
        });
    }

    @Override
    public void dataReset() {
        this.filteredDataToDataIndex.clear();
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThreadsPanel.this.refreshUI();
            }
        });
    }

    public boolean fitsVisibleArea() {
        return !this.tableScroll.getVerticalScrollBar().isVisible();
    }

    public boolean hasView() {
        return !this.notificationPanel.isShowing();
    }

    public void threadsMonitoringDisabled() {
        this.threadsMonitoringEnabled = false;
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, ENABLE_THREADS_PROFILING);
        this.updateZoomButtonsEnabledState();
        this.threadsSelectionCombo.setEnabled(false);
    }

    public void threadsMonitoringEnabled() {
        this.threadsMonitoringEnabled = true;
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, THREADS_TABLE);
        this.updateZoomButtonsEnabledState();
        this.threadsSelectionCombo.setEnabled(true);
    }

    private JTable createViewTable() {
        return new JExtendedTable(new ThreadsTableModel());
    }

    private JPopupMenu initPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.showOnlySelectedThreads = new JMenuItem(SELECTED_THREADS_ITEM);
        this.showLegend = new JMenuItem(SHOW_LEGEND);
        this.hideLegend = new JMenuItem(HIDE_LEGEND);
        this.selectThreadName = new JMenu(SELECT_THREAD_NAME);
        this.idThreadName = new JRadioButtonMenuItem(THREAD_NAME_ID);
        this.calleeThreadName = new JRadioButtonMenuItem(THREAD_NAME_CALLEE);
        this.calleeCalleeThreadName = new JRadioButtonMenuItem(THREAD_NAME_CALLEE_CALLEE);
        this.selectThreadName.add(this.idThreadName);
        this.selectThreadName.add(this.calleeThreadName);
        this.selectThreadName.add(this.calleeCalleeThreadName);
        switch (NbPreferences.forModule(this.getClass()).getInt("ThreadName", 0)) {
            case 1: {
                this.calleeThreadName.setSelected(true);
                this.manager.setThreadNameFormat(1, true);
                break;
            }
            case 2: {
                this.calleeCalleeThreadName.setSelected(true);
                this.manager.setThreadNameFormat(2, true);
                break;
            }
            default: {
                this.idThreadName.setSelected(true);
                this.manager.setThreadNameFormat(0, true);
            }
        }
        popup.add(this.showOnlySelectedThreads);
        popup.add(this.showLegend);
        popup.add(this.hideLegend);
        popup.add(this.selectThreadName);
        JMenu navigate = new JMenu(NAVIGATE);
        navigate.add(this.table.getActionMap().get("leftTimeLine"));
        navigate.add(this.table.getActionMap().get("rightTimeLine"));
        navigate.add(this.table.getActionMap().get("newTimeLine"));
        navigate.add(this.table.getActionMap().get("focuseStack"));
        popup.add(navigate);
        this.showOnlySelectedThreads.addActionListener(this);
        this.showLegend.addActionListener(this);
        this.hideLegend.addActionListener(this);
        this.idThreadName.addActionListener(this);
        this.calleeThreadName.addActionListener(this);
        this.calleeCalleeThreadName.addActionListener(this);
        return popup;
    }

    private void performDefaultAction() {
    }

    @Override
    public Action[] getStackNodeActions(int threadID) {
        ArrayList<StackAction> result = new ArrayList<StackAction>();
        LinkedHashMap<Integer, ThreadState> avaliableStates = this.prepareAllStacks();
        if (avaliableStates.size() == 0) {
            return new Action[0];
        }
        ArrayList<Integer> showThreadsID = new ArrayList<Integer>();
        for (Map.Entry<Integer, ThreadState> entry : avaliableStates.entrySet()) {
            ThreadState state = entry.getValue();
            showThreadsID.add(this.manager.getThreadData(entry.getKey()).getThreadID());
            if (threadID != this.manager.getThreadData(entry.getKey()).getThreadID()) continue;
            EnumMap<ThreadState.MSAState, AtomicInteger> aMap = new EnumMap<ThreadState.MSAState, AtomicInteger>(ThreadState.MSAState.class);
            ThreadStateColumnImpl.fillMap(this, state, aMap);
            ThreadStateColumnImpl.roundMap(aMap);
            OrderedEnumStateIterator it = new OrderedEnumStateIterator(aMap);
            while (it.hasNext()) {
                Object e = it.next();
                ThreadState.MSAState msa = (ThreadState.MSAState)e.getKey();
                ThreadStateResources res = ThreadStateResources.forState(msa);
                if (res == null) continue;
                ThreadDumpQuery query = new ThreadDumpQuery((long)this.manager.getThreadData(entry.getKey()).getThreadID(), state, showThreadsID, msa, this.isMSAMode(), this.isFullMode(), this.manager.getStartTime());
                StackAction action = new StackAction(state, msa, query);
                result.add(action);
            }
        }
        return result.toArray(new Action[0]);
    }

    private LinkedHashMap<Integer, ThreadState> prepareAllStacks() {
        LinkedHashMap<Integer, ThreadState> avaliableStates = new LinkedHashMap<Integer, ThreadState>();
        if (this.timeLine != null) {
            long t = this.timeLine.getTimeStamp() + (long)this.timeLine.getInterval();
            for (Integer i : this.filteredDataToDataIndex) {
                ThreadStateColumnImpl row = this.manager.getThreadData(i);
                ThreadState found = null;
                for (int j = 0; j < row.size(); ++j) {
                    ThreadState state = row.getThreadStateAt(j);
                    long timeStamp = ThreadStateColumnImpl.timeStampToMilliSeconds(state.getTimeStamp());
                    if (j < row.size() - 1) {
                        if (timeStamp > t || t > ThreadStateColumnImpl.timeStampToMilliSeconds(row.getThreadStateAt(j + 1).getTimeStamp())) continue;
                        found = state;
                        break;
                    }
                    if (timeStamp > t || t > timeStamp + (long)ThreadStateColumnImpl.timeInervalToMilliSeconds(state.getMSASamplePeriod())) continue;
                    found = state;
                    break;
                }
                if (found == null) continue;
                avaliableStates.put(i, found);
            }
        }
        return avaliableStates;
    }

    private void onClickAction(MouseEvent e) {
        int rowIndex = this.table.rowAtPoint(e.getPoint());
        if (rowIndex >= 0) {
            int row = this.filteredDataToDataIndex.get(rowIndex);
            TableColumnModel columnModel = this.table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int col = this.table.convertColumnIndexToModel(viewColumn);
            if (col == 1) {
                ThreadState.MSAState prefferedState;
                ThreadStateColumnImpl threadData = this.manager.getThreadData(row);
                Rectangle rect = this.table.getCellRect(rowIndex, viewColumn, false);
                Point point = new Point(e.getPoint().x - rect.x, e.getPoint().y - rect.y);
                int index = ThreadStateColumnImpl.point2index(this.manager, this, threadData, point, rect.width);
                if (index >= 0 && (prefferedState = ThreadStateColumnImpl.point2MSA(this, threadData.getThreadStateAt(index), point)) != null) {
                    ThreadState state = threadData.getThreadStateAt(index);
                    int interval = (int)state.getMSASamplePeriod();
                    this.timeLine = new TimeLine(state.getTimeStamp(), this.manager.getStartTime(), interval);
                    this.showStacksAtTimeLine(threadData, state, prefferedState);
                }
            }
        }
    }

    private void showStacksAtTimeLine(final ThreadStateColumnImpl threadData, final ThreadState state, final ThreadState.MSAState prefferedState) {
        if (this.timeLine != null && (this.getViewStart() > this.timeLine.getTime() || this.timeLine.getTime() > this.getViewEnd()) && this.scrollBar.isVisible()) {
            int oldValue = this.scrollBar.getValue();
            int newValue = (int)(this.timeLine.getTime() - (long)(this.scrollBar.getVisibleAmount() / 2));
            if (oldValue != (newValue = Math.max(Math.min(newValue, this.scrollBar.getMaximum() - this.scrollBar.getVisibleAmount()), this.scrollBar.getMinimum()))) {
                this.scrollBar.setValue(newValue);
            }
        }
        this.refreshUI();
        if (this.detailsCallback != null) {
            if (this.showStackTask != null) {
                this.showStackTask.cancel();
            }
            this.showStackTask = RP.post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LinkedHashMap avaliableStates = ThreadsPanel.this.prepareAllStacks();
                            ArrayList<Integer> showThreadsID = new ArrayList<Integer>();
                            for (Map.Entry entry : avaliableStates.entrySet()) {
                                showThreadsID.add(ThreadsPanel.this.manager.getThreadData((Integer)entry.getKey()).getThreadID());
                            }
                            ThreadDumpQuery query = new ThreadDumpQuery((long)threadData.getThreadID(), state, showThreadsID, prefferedState, ThreadsPanel.this.isMSAMode(), ThreadsPanel.this.isFullMode(), ThreadsPanel.this.manager.getStartTime());
                            ThreadsPanel.this.detailsCallback.showStack(state.getTimeStamp(), query);
                        }
                    });
                }
            }, 1000);
        }
    }

    private void refreshUI() {
        if (!this.isShowing()) {
            return;
        }
        this.updateFilteredData();
        this.refreshViewData();
        this.updateScrollbar();
        this.updateZoomButtonsEnabledState();
        this.table.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void refreshViewData() {
        if (this.scaleToFit) {
            long dataLen = this.manager.getEndTime() - this.manager.getStartTime();
            int viewLen = this.table.getTableHeader().getHeaderRect((int)1).width;
            float currentResolution = (float)dataLen / (float)Math.max(viewLen - 20 - 20, 1);
            this.viewStart = this.manager.getStartTime() - (long)(currentResolution * 20.0f);
            this.viewEnd = this.manager.getEndTime() + (long)(currentResolution * 20.0f);
        } else {
            long rightMarginInTime = (long)(this.zoomResolutionPerPixel * 20.0f);
            long leftMarginInTime = (long)(this.zoomResolutionPerPixel * 20.0f);
            long widthInTime = (long)(this.zoomResolutionPerPixel * (float)this.table.getTableHeader().getHeaderRect((int)1).width);
            if (this.viewStart == -1L) {
                this.viewStart = this.manager.getStartTime() - leftMarginInTime;
                this.viewEnd = this.viewStart + widthInTime;
            }
            if (this.trackingEnd) {
                this.viewEnd = this.manager.getEndTime() + rightMarginInTime;
                this.viewStart = this.viewEnd - widthInTime;
                if (this.viewStart < this.manager.getStartTime() - leftMarginInTime) {
                    this.viewStart = this.manager.getStartTime() - leftMarginInTime;
                    this.viewEnd = this.viewStart + widthInTime;
                }
            } else {
                long prevWidth = this.viewEnd - this.viewStart;
                if (prevWidth != 0L) {
                    long anchor = (this.viewEnd + this.viewStart) / 2L;
                    if (this.timeLine != null && this.viewStart < this.timeLine.getTime() + (long)(this.timeLine.getInterval() / 2) && this.timeLine.getTime() + (long)(this.timeLine.getInterval() / 2) < this.viewEnd) {
                        anchor = this.timeLine.getTime() + (long)(this.timeLine.getInterval() / 2);
                    }
                    this.viewStart = anchor - widthInTime * (anchor - this.viewStart) / prevWidth;
                }
                if (this.viewStart < this.manager.getStartTime()) {
                    this.viewStart = this.manager.getStartTime() - rightMarginInTime;
                }
                this.viewEnd = this.viewStart + widthInTime;
            }
        }
    }

    private void updateFilteredData() {
        if (this.threadsSelectionCombo.getSelectedItem() != VIEW_THREADS_SELECTION) {
            this.filteredDataToDataIndex.clear();
            for (int i = 0; i < this.manager.getThreadsCount(); ++i) {
                ThreadStateColumnImpl threadData;
                if (this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_ALL)) {
                    this.filteredDataToDataIndex.add(i);
                    continue;
                }
                if (this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_LIVE)) {
                    threadData = this.manager.getThreadData(i);
                    if (threadData.size() <= 0 || !threadData.isAlive()) continue;
                    this.filteredDataToDataIndex.add(i);
                    continue;
                }
                if (!this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_FINISHED)) continue;
                threadData = this.manager.getThreadData(i);
                if (threadData.size() > 0) {
                    if (threadData.isAlive()) continue;
                    this.filteredDataToDataIndex.add(i);
                    continue;
                }
                this.filteredDataToDataIndex.add(i);
            }
        }
        if ((this.sortedColum == 0 || this.sortedColum == 2) && this.sortedOrder != 0) {
            TreeMap<Object, Integer> map = new TreeMap<Object, Integer>();
            for (Integer i : this.filteredDataToDataIndex) {
                ThreadStateColumnImpl col = this.manager.getThreadData(i);
                if (this.sortedColum == 0) {
                    map.put(col.getName() + col.getThreadID(), i);
                    continue;
                }
                long l = 0L;
                ThreadSummaryColumnImpl c = this.manager.getThreadSummary(i);
                if (c != null) {
                    l = c.getRunning();
                }
                l = (l << 32) + (long)col.getThreadID();
                map.put(l, i);
            }
            this.filteredDataToDataIndex.clear();
            if (this.sortedOrder == 1) {
                this.filteredDataToDataIndex.addAll(map.values());
            } else {
                LinkedList<Integer> list = new LinkedList<Integer>();
                Iterator i$ = map.values().iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    list.addFirst(i);
                }
                this.filteredDataToDataIndex.addAll(list);
            }
        }
    }

    private void updateScrollbar() {
        this.internalScrollbarChange = true;
        if (this.scrollBar.isVisible() == this.scaleToFit) {
            this.scrollBar.setVisible(!this.scaleToFit);
        }
        if (!this.scaleToFit) {
            int rightMarginInTime = (int)(this.zoomResolutionPerPixel * 20.0f);
            int leftMarginInTime = (int)(this.zoomResolutionPerPixel * 20.0f);
            int value = (int)(this.viewStart - this.manager.getStartTime()) + leftMarginInTime;
            int extent = (int)(this.viewEnd - this.viewStart);
            int intMax = (int)(this.manager.getEndTime() - this.manager.getStartTime()) + rightMarginInTime;
            boolean shouldBeVisible = true;
            if (value == 0 && intMax - (value + extent) <= 0) {
                shouldBeVisible = false;
            }
            if (this.scrollBar.isVisible() != shouldBeVisible) {
                this.scrollBar.setVisible(shouldBeVisible);
            }
            if (shouldBeVisible) {
                this.scrollBar.setValues(value, extent, -leftMarginInTime, intMax);
                this.scrollBar.setBlockIncrement((int)((float)extent * 0.95f));
                this.scrollBar.setUnitIncrement(Math.max((int)(this.zoomResolutionPerPixel * 5.0f), 1));
            }
        }
        this.internalScrollbarChange = false;
    }

    private void updateZoomButtonsEnabledState() {
        if (!this.threadsMonitoringEnabled) {
            this.zoomInButton.setEnabled(false);
            this.zoomOutButton.setEnabled(false);
            this.scaleToFitButton.setEnabled(false);
        } else {
            if (this.scaleToFit) {
                this.zoomInButton.setEnabled(false);
                this.zoomOutButton.setEnabled(false);
            } else {
                this.zoomInButton.setEnabled((double)this.zoomResolutionPerPixel > 0.1);
                int viewWidth = this.table.getTableHeader().getHeaderRect((int)1).width;
                this.zoomOutButton.setEnabled(this.zoomResolutionPerPixel * (float)viewWidth < 2.0f * (float)(this.manager.getEndTime() - this.manager.getStartTime()));
            }
            this.scaleToFitButton.setEnabled(true);
            this.scaleToFitButton.setToolTipText(this.scaleToFit ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
        }
    }

    void setTimeIntervalSelection(Collection<TimeIntervalDataFilter> timeFilters) {
        this.timeFilters = timeFilters;
        UIThread.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                ThreadsPanel.this.updateUI();
            }
        });
    }

    Collection<TimeIntervalDataFilter> getTimeIntervalSelection() {
        return this.timeFilters;
    }

    private class StackAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JMenuItem menuItem;
        private final ThreadDumpQuery query;
        private final ThreadState state;

        public StackAction(ThreadState state, ThreadState.MSAState msa, ThreadDumpQuery query) {
            this.putValue("Name", ThreadStateResources.forState((ThreadState.MSAState)msa).name);
            this.putValue("ShortDescription", ThreadStateResources.forState((ThreadState.MSAState)msa).tooltip);
            this.putValue("SmallIcon", new ThreadStateIcon(msa, 10, 10));
            this.putValue("ActionCommandKey", ThreadsPanel.QUERY_STATE_ACTION_COMMAND);
            this.menuItem = new JMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
            this.query = query;
            this.state = state;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ThreadsPanel.this.queryChanged(this.query, this.state);
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private class ThreadsTableModel
    extends AbstractTableModel {
        private ThreadsTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return ThreadNameCellRenderer.class;
                }
                case 1: {
                    return ThreadStateCellRenderer.class;
                }
                case 2: {
                    return ThreadSummaryCellRenderer.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return THREADS_COLUMN_NAME;
                }
                case 1: {
                    return TIMELINE_COLUMN_NAME;
                }
                case 2: {
                    return SUMMARY_COLUMN_NAME;
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return ThreadsPanel.this.filteredDataToDataIndex.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ThreadsPanel.this.filteredDataToDataIndex.get(rowIndex);
                }
                case 1: {
                    return ThreadsPanel.this.getThreadData((Integer)ThreadsPanel.this.filteredDataToDataIndex.get(rowIndex));
                }
                case 2: {
                    return ThreadsPanel.this.getThreadSummary((Integer)ThreadsPanel.this.filteredDataToDataIndex.get(rowIndex));
                }
            }
            return null;
        }
    }

    private final class ThreadsScrollBar
    extends JScrollBar {
        public ThreadsScrollBar() {
            super(0);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            return new Dimension(((ThreadsPanel)ThreadsPanel.this).table.getTableHeader().getHeaderRect((int)1).width, pref.height);
        }
    }

    public static interface ThreadsDetailsCallback {
        public void showStack(long var1, ThreadDumpQuery var3);
    }
}

