/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.util.List;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.util.CollectionToStringConvertor;

public class Metrics {
    final String mspec;
    final String msort;
    private static final CollectionToStringConvertor<DataTableMetadata.Column> convertor = new CollectionToStringConvertor(":", (CollectionToStringConvertor.Convertor)new CollectionToStringConvertor.Convertor<DataTableMetadata.Column>(){

        public String itemToString(DataTableMetadata.Column item) {
            return item.getColumnName();
        }
    });

    Metrics(String mspec, String msort) {
        this.mspec = mspec;
        this.msort = msort;
    }

    public String getMsort() {
        return this.msort;
    }

    public String getMspec() {
        return this.mspec;
    }

    public static Metrics constructFrom(List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy) {
        String mspecResult = convertor.collectionToString(columns);
        String msortResult = convertor.collectionToString(orderBy);
        if ("".equals(msortResult)) {
            msortResult = columns.get(0).getColumnName();
        }
        return new Metrics(mspecResult, msortResult);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Metrics)) {
            throw new IllegalArgumentException();
        }
        Metrics o = (Metrics)obj;
        return o.msort.equals(this.msort) && o.mspec.equals(this.mspec);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.mspec != null ? this.mspec.hashCode() : 0);
        hash = 89 * hash + (this.msort != null ? this.msort.hashCode() : 0);
        return hash;
    }
}

