/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebugTreeView;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class ClickableIcon
extends JLabel
implements MouseListener {
    public static final int CLICKABLE_ICON_WIDTH = 24;
    public static final int CLICKABLE_ICON_HEIGHT = 16;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_FOCUSED = 1;
    private static final int STATE_PRESSED = 2;
    private ImageIcon resumeIcon;
    private ImageIcon focusedResumeIcon;
    private ImageIcon pressedResumeIcon;
    private ImageIcon suspendIcon;
    private ImageIcon focusedSuspendIcon;
    private ImageIcon pressedSuspendIcon;
    private int state;
    private boolean isThreadSupended;
    private JPDAThread jpdaThread;
    private DebugTreeView tree;

    ClickableIcon(ImageIcon normalR, ImageIcon focusedR, ImageIcon pressedR, ImageIcon normalS, ImageIcon focusedS, ImageIcon pressedS, JPDAThread jpdaThread, DebugTreeView tree) {
        this.tree = tree;
        this.resumeIcon = normalR;
        this.focusedResumeIcon = focusedR;
        this.pressedResumeIcon = pressedR;
        this.suspendIcon = normalS;
        this.focusedSuspendIcon = focusedS;
        this.pressedSuspendIcon = pressedS;
        this.isThreadSupended = jpdaThread.isSuspended();
        this.jpdaThread = jpdaThread;
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setPreferredSize(new Dimension(24, 16));
    }

    void initializeState(Container container, int sx, int sy, int width, int height) {
        Point point = null;
        try {
            point = container.getMousePosition(true);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.state = point != null && sx <= point.x && point.x < sx + width && sy <= point.y && point.y < sy + height ? 1 : 0;
        this.setFocusedThread();
        this.changeIcon();
        this.addMouseListener(this);
    }

    void changeThread(JPDAThread newThread, Container container, int sx, int sy, int width, int height) {
        boolean suspended = newThread.isSuspended();
        if (this.jpdaThread == newThread && suspended == this.isThreadSupended) {
            return;
        }
        this.isThreadSupended = newThread.isSuspended();
        this.jpdaThread = newThread;
        Point point = container.getMousePosition(true);
        this.state = point != null && sx <= point.x && point.x < sx + width && sy <= point.y && point.y < sy + height ? 1 : 0;
        this.setFocusedThread();
        this.changeIcon();
    }

    private void setFocusedThread() {
        if (this.state != 0) {
            if (this.tree != null && this.tree.threadFocuseGained(this.jpdaThread)) {
                this.getParent().repaint();
            }
        } else if (this.tree != null && this.tree.threadFocuseLost(this.jpdaThread)) {
            this.getParent().repaint();
        }
    }

    private ImageIcon computeIcon() {
        ImageIcon icon = null;
        switch (this.state) {
            case 0: {
                icon = this.isThreadSupended ? this.resumeIcon : this.suspendIcon;
                break;
            }
            case 1: {
                icon = this.isThreadSupended ? this.focusedResumeIcon : this.focusedSuspendIcon;
                break;
            }
            case 2: {
                icon = this.isThreadSupended ? this.pressedResumeIcon : this.pressedSuspendIcon;
            }
        }
        return icon;
    }

    private void changeIcon() {
        this.setIcon(this.computeIcon());
        String key = this.isThreadSupended ? "LBL_RESUME_THREAD" : "LBL_SUSPEND_THREAD";
        String text = NbBundle.getMessage(ClickableIcon.class, (String)key, (Object)this.jpdaThread.getName());
        this.setToolTipText(text);
    }

    private void invokeAction() {
        RequestProcessor rp;
        final boolean suspended = this.isThreadSupended;
        try {
            JPDADebugger debugger = (JPDADebugger)this.jpdaThread.getClass().getMethod("getDebugger", new Class[0]).invoke((Object)this.jpdaThread, new Object[0]);
            Session s = (Session)debugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)debugger, new Object[0]);
            rp = (RequestProcessor)s.lookupFirst(null, RequestProcessor.class);
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return;
        }
        if (rp == null) {
            rp = RequestProcessor.getDefault();
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                if (suspended) {
                    ClickableIcon.this.jpdaThread.resume();
                } else {
                    ClickableIcon.this.jpdaThread.suspend();
                }
            }
        });
        this.isThreadSupended = !this.isThreadSupended;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.state = 2;
        this.changeIcon();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.state == 2) {
            this.state = 1;
            this.invokeAction();
            this.changeIcon();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.state = (e.getModifiersEx() & 0x400) != 0 ? 0 : 1;
        this.setFocusedThread();
        this.changeIcon();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.state = 0;
        this.setFocusedThread();
        this.changeIcon();
    }
}

