/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.debugging.KeyboardPopupSwitcher;
import org.netbeans.modules.debugger.jpda.ui.debugging.ThreadsHistoryAction;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class SetCurrentThreadFromHistoryAction
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup {
    public SetCurrentThreadFromHistoryAction() {
        this.putValue("Name", NbBundle.getMessage(ThreadsHistoryAction.class, (String)"CTL_ThreadsHistoryAction"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new ThreadsHistoryAction().actionPerformed(e);
    }

    public JMenuItem getMenuPresenter() {
        final JMenuItem item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)NbBundle.getMessage(SetCurrentThreadFromHistoryAction.class, (String)"CTL_SetCurrentThreadFromHistoryAction"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetCurrentThreadFromHistoryAction.this.showWindow();
            }
        });
        item.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("ancestor".equals(evt.getPropertyName())) {
                    item.setEnabled(ThreadsHistoryAction.getThreads().size() > 0);
                }
            }
        });
        return item;
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenuPresenter();
    }

    private void showWindow() {
        List<JPDAThread> threads = ThreadsHistoryAction.getThreads();
        int threadsCount = threads.size();
        if (threadsCount < 1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int triggerKey = 40;
        int releaseKey = 10;
        KeyboardPopupSwitcher.selectItem(ThreadsHistoryAction.createSwitcherItems(threads), releaseKey, triggerKey, true, true);
    }
}

