/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.actions.Installer;
import org.openide.util.NbBundle;

public class PanelBodyContainer
extends JPanel {
    private String head = null;
    private String message = null;
    private JScrollPane customPanel;
    private JPanel bodyPanel = null;
    private JComponent progressPanel = null;
    private JComponent progress;
    private boolean isWaiting = false;
    private Timer delay;
    private ProgressHandle handle;
    private JPanel pBodyPanel;
    private JScrollPane spPanelHeader;
    private JTextPane tpPanelHeader;

    public PanelBodyContainer(String heading, String msg, JPanel bodyPanel) {
        this.head = heading;
        this.message = msg;
        this.bodyPanel = bodyPanel;
        this.initComponents();
        this.writeToHeader(this.head, this.message);
        this.initBodyPanel();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanelBodyContainer.this.bodyPanel.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
            }
        });
        if (this.isWaiting) {
            this.setWaitingState(true);
        }
    }

    public void setBody(final JPanel newBodyPanel) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.bodyPanel = newBodyPanel;
            this.initBodyPanel();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelBodyContainer.this.bodyPanel = newBodyPanel;
                    PanelBodyContainer.this.initBodyPanel();
                }
            });
        }
    }

    public void setWaitingState(boolean isWaiting) {
        this.setWaitingState(isWaiting, 0L);
    }

    public void setWaitingState(boolean isWaiting, final long estimatedTime) {
        if (this.isWaiting == isWaiting) {
            return;
        }
        this.isWaiting = isWaiting;
        if (isWaiting) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelBodyContainer.this.addProgressLine(estimatedTime);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelBodyContainer.this.removeProgressLine();
                }
            });
        }
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            if (isWaiting) {
                rootPane.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                rootPane.setCursor(null);
            }
        }
    }

    private void addProgressLine(long estimatedTime) {
        this.handle = ProgressHandleFactory.createHandle((String)"PanelBodyContainer_ProgressLine");
        JLabel title = new JLabel(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_PleaseWait"));
        this.progress = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle);
        this.progressPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 12, 0, 12);
        gridBagConstraints.weighty = 1.0;
        this.progressPanel.add((Component)this.progress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 0, 0, 20);
        gridBagConstraints.weightx = 1.0;
        this.progressPanel.add((Component)title, gridBagConstraints);
        this.progressPanel.setVisible(false);
        this.delay = new Timer(900, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelBodyContainer.this.delay.stop();
                PanelBodyContainer.this.adjustProgressWidth();
                PanelBodyContainer.this.progressPanel.setVisible(true);
                PanelBodyContainer.this.initBodyPanel();
            }
        });
        this.delay.setRepeats(false);
        this.delay.start();
        final String progressDisplayName = NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ProgressLine");
        if (estimatedTime == 0L) {
            this.handle.start();
            this.handle.progress(progressDisplayName);
        } else {
            assert (estimatedTime > 0L) : "Estimated time " + estimatedTime;
            final long friendlyEstimatedTime = estimatedTime + 2L;
            this.handle.start((int)friendlyEstimatedTime * 10, friendlyEstimatedTime);
            this.handle.progress(progressDisplayName, 0);
            Installer.RP.post(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (PanelBodyContainer.this.isWaiting) {
                        try {
                            if (friendlyEstimatedTime * 10L <= (long)i++) {
                                PanelBodyContainer.this.handle.switchToIndeterminate();
                                PanelBodyContainer.this.handle.progress(progressDisplayName);
                                return;
                            }
                            PanelBodyContainer.this.handle.progress(progressDisplayName, i);
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
        }
    }

    private void adjustProgressWidth() {
        Dimension min = this.progress.getMinimumSize();
        Dimension preferred = this.progress.getPreferredSize();
        if (min != null && preferred != null && min.width * 2 < preferred.width) {
            int width = preferred.width / 2;
            int height = min.height;
            this.progress.setMinimumSize(new Dimension(width, height));
        }
    }

    private void initBodyPanel() {
        this.pBodyPanel.removeAll();
        this.customPanel = new JScrollPane();
        this.customPanel.setBorder(null);
        this.pBodyPanel.add((Component)this.customPanel, "Center");
        if (this.isWaiting) {
            this.pBodyPanel.add((Component)this.progressPanel, "South");
        }
        this.customPanel.setViewportView(this.bodyPanel);
        this.customPanel.getVerticalScrollBar().setUnitIncrement(10);
        this.customPanel.getHorizontalScrollBar().setUnitIncrement(10);
        this.revalidate();
    }

    private void removeProgressLine() {
        if (this.progressPanel != null) {
            this.pBodyPanel.remove(this.progressPanel);
            if (this.handle != null) {
                this.handle.finish();
            }
            this.revalidate();
        }
    }

    public void setHeadAndContent(final String heading, final String content) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.writeToHeader(heading, content);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelBodyContainer.this.writeToHeader(heading, content);
                }
            });
        }
    }

    private void writeToHeader(String heading, String msg) {
        this.tpPanelHeader.setText(null);
        this.tpPanelHeader.setText("<br><b>" + heading + "</b> <br>" + msg);
    }

    private void initComponents() {
        this.pBodyPanel = new JPanel();
        this.spPanelHeader = new JScrollPane();
        this.tpPanelHeader = new JTextPane();
        this.pBodyPanel.setLayout(new BorderLayout());
        this.tpPanelHeader.setContentType("text/html");
        this.tpPanelHeader.setEditable(false);
        this.spPanelHeader.setViewportView(this.tpPanelHeader);
        this.tpPanelHeader.getAccessibleContext().setAccessibleName(this.head);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pBodyPanel, -1, 24, Short.MAX_VALUE).addComponent(this.spPanelHeader, GroupLayout.Alignment.TRAILING, -1, 24, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.spPanelHeader, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pBodyPanel, -1, -1, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ACN"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ACD"));
    }
}

