/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentUtils {
    private static String TRINIDAD_FORM_FAMILY = "org.apache.myfaces.trinidad.Form";

    public static String getStringValueToRender(FacesContext facesContext, UIComponent component) {
        if (component instanceof ValueHolder) {
            Converter converterForType;
            Class valueType;
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            if (valueHolder.getConverter() != null) {
                return valueHolder.getConverter().getAsString(facesContext, component, value);
            }
            ValueExpression expr = component.getValueExpression("value");
            if (expr != null && (valueType = expr.getType(facesContext.getELContext())) != null && (converterForType = facesContext.getApplication().createConverter(valueType)) != null) {
                return converterForType.getAsString(facesContext, component, value);
            }
            return value.toString();
        }
        String value = component.toString();
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    public static String getStringValueToRender(FacesContext facesContext, UIComponent component, Object value) {
        if (value == null) {
            return null;
        }
        ValueHolder valueHolder = (ValueHolder)component;
        Converter converter = valueHolder.getConverter();
        if (converter != null) {
            return converter.getAsString(facesContext, component, value);
        }
        ValueExpression expr = component.getValueExpression("value");
        if (expr != null) {
            Class valueType = expr.getType(facesContext.getELContext());
            Converter converterForType = facesContext.getApplication().createConverter(valueType);
            if (converterForType != null) {
                return converterForType.getAsString(facesContext, component, value);
            }
        }
        return value.toString();
    }

    public static UIComponent findParentForm(FacesContext context, UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof UIForm) {
                return parent;
            }
            if (!parent.getFamily().equals(TRINIDAD_FORM_FAMILY)) continue;
            return parent;
        }
        return null;
    }

    public static void decorateAttribute(UIComponent component, String attribute, String value) {
        String attributeValue = (String)component.getAttributes().get(attribute);
        if (attributeValue != null) {
            if (attributeValue.indexOf(value) == -1) {
                String decoratedValue = attributeValue + ";" + value;
                component.getAttributes().put(attribute, decoratedValue);
            } else {
                component.getAttributes().put(attribute, attributeValue);
            }
        } else {
            component.getAttributes().put(attribute, value);
        }
    }

    public static List<SelectItem> createSelectItems(UIComponent component) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UISelectItem) {
                UISelectItem selectItem = (UISelectItem)child;
                items.add(new SelectItem(selectItem.getItemValue(), selectItem.getItemLabel()));
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            Object selectItems = ((UISelectItems)child).getValue();
            if (selectItems instanceof SelectItem[]) {
                SelectItem[] itemsArray;
                for (SelectItem item : itemsArray = (SelectItem[])selectItems) {
                    items.add(new SelectItem(item.getValue(), item.getLabel()));
                }
                continue;
            }
            if (!(selectItems instanceof Collection)) continue;
            Collection collection = (Collection)selectItems;
            for (SelectItem item : collection) {
                items.add(new SelectItem(item.getValue(), item.getLabel()));
            }
        }
        return items;
    }

    public static String escapeJQueryId(String id) {
        return "#" + id.replaceAll(":", "\\\\\\\\:");
    }

    public static String formatKeywords(FacesContext facesContext, UIComponent component, String processRequest) {
        String process = processRequest;
        if (process.indexOf("@this") != -1) {
            process = process.replaceFirst("@this", component.getClientId(facesContext));
        }
        if (process.indexOf("@form") != -1) {
            UIComponent form = ComponentUtils.findParentForm(facesContext, component);
            if (form == null) {
                throw new FacesException("Component " + component.getClientId(facesContext) + " needs to be enclosed in a form");
            }
            process = process.replaceFirst("@form", form.getClientId(facesContext));
        }
        if (process.indexOf("@parent") != -1) {
            process = process.replaceFirst("@parent", component.getParent().getClientId(facesContext));
        }
        return process;
    }

    public static String findClientIds(FacesContext facesContext, UIComponent component, String list) {
        if (list == null) {
            return "@none";
        }
        String formattedList = ComponentUtils.formatKeywords(facesContext, component, list);
        String[] ids = formattedList.split("[,\\s]+");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            String id;
            if (i != 0) {
                buffer.append(",");
            }
            if ((id = ids[i].trim()).equals("@all") || id.equals("@none")) {
                buffer.append(id);
                continue;
            }
            UIComponent comp = component.findComponent(id);
            if (comp != null) {
                buffer.append(comp.getClientId(facesContext));
                continue;
            }
            buffer.append(id);
        }
        return buffer.toString();
    }

    public static String findComponentClientId(String id) {
        UIComponent component = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        component = ComponentUtils.findComponent((UIComponent)facesContext.getViewRoot(), id);
        return component.getClientId(facesContext);
    }

    public static UIComponent findComponent(UIComponent base, String id) {
        if (id.equals(base.getId())) {
            return base;
        }
        UIComponent kid = null;
        UIComponent result = null;
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext() && result == null) {
            kid = (UIComponent)kids.next();
            if (id.equals(kid.getId())) {
                result = kid;
                break;
            }
            result = ComponentUtils.findComponent(kid, id);
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static boolean isLiteralText(UIComponent component) {
        return component.getFamily().equalsIgnoreCase("facelets.LiteralText");
    }
}

