/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.touch.component.rowitem;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.touch.component.rowitem.RowItem;
import org.primefaces.util.ComponentUtils;

public class RowItemRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        RowItem rowItem;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.get((rowItem = (RowItem)component).getClientId(facesContext)) != null) {
            rowItem.queueEvent((FacesEvent)new ActionEvent((UIComponent)rowItem));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        RowItem rowItem = (RowItem)component;
        String clientId = rowItem.getClientId(facesContext);
        boolean isNavigation = rowItem.getView() != null;
        boolean isDynamic = rowItem.getUpdate() != null;
        writer.startElement("li", null);
        if (isNavigation) {
            writer.writeAttribute("class", (Object)"arrow", null);
        }
        if (rowItem.getValue() == null) {
            this.renderChildren(facesContext, (UIComponent)rowItem);
        } else {
            String href = isNavigation ? "javascript:void(0)" : (rowItem.getUrl() != null ? rowItem.getUrl() : "#");
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)href, null);
            if (rowItem.getUrl() != null) {
                writer.writeAttribute("target", (Object)"_blank", null);
            }
            if (isNavigation) {
                String onclick = "TouchFaces.goTo('" + rowItem.getView() + "','slide')";
                if (isDynamic) {
                    UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)rowItem);
                    if (form == null) {
                        throw new FacesException("RowItem \"" + clientId + "\" must be inside a form element when using ajax update");
                    }
                    rowItem.setOncomplete(onclick);
                    String request = this.buildAjaxRequest(facesContext, rowItem, form.getClientId(facesContext), clientId);
                    writer.writeAttribute("onclick", (Object)request, null);
                } else {
                    writer.writeAttribute("onclick", (Object)onclick, null);
                }
            }
            if (rowItem.getValue() != null) {
                writer.write(rowItem.getValue().toString());
            }
            writer.endElement("a");
        }
        writer.endElement("li");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

