/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.slider;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.slider.Slider;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class SliderRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Slider slider = (Slider)component;
        this.encodeMarkup(facesContext, slider);
        this.encodeScript(facesContext, slider);
    }

    protected void encodeMarkup(FacesContext facesContext, Slider slider) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = slider.getClientId(facesContext);
        writer.startElement("div", (UIComponent)slider);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (slider.getStyle() != null) {
            writer.writeAttribute("style", (Object)slider.getStyle(), null);
        }
        if (slider.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)slider.getStyleClass(), null);
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext facesContext, Slider slider) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = slider.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)slider);
        String input = this.getTarget(facesContext, slider, slider.getFor());
        String output = this.getTarget(facesContext, slider, slider.getDisplay());
        int value = 0;
        String stringValue = ComponentUtils.getStringValueToRender(facesContext, (UIComponent)slider);
        if (!this.isValueBlank(stringValue)) {
            value = Integer.parseInt(stringValue);
        }
        writer.startElement("script", (UIComponent)slider);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(widgetVar + " = new PrimeFaces.widget.Slider('" + clientId + "', {");
        writer.write("value:" + value);
        writer.write(",input:'" + input + "'");
        writer.write(",min:" + slider.getMinValue());
        writer.write(",max:" + slider.getMaxValue());
        writer.write(",animate:" + slider.isAnimate());
        writer.write(",step:" + slider.getStep());
        writer.write(",orientation:'" + slider.getType() + "'");
        if (slider.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (output != null) {
            writer.write(",output:'" + output + "'");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected String getTarget(FacesContext facesContext, Slider slider, String target) {
        if (target == null) {
            return null;
        }
        UIComponent targetComponent = slider.findComponent(target);
        return targetComponent.getClientId(facesContext);
    }
}

