/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.resource;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.resource.Resource;
import org.primefaces.renderkit.CoreRenderer;

public class ResourceRenderer
extends CoreRenderer {
    private static Logger logger = Logger.getLogger(ResourceRenderer.class.getName());

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Resource resource = (Resource)component;
        String resourcePath = resource.getName();
        if (resourcePath != null) {
            writer.write("\n");
            if (resourcePath.endsWith("css")) {
                this.renderCSSDependency(facesContext, resourcePath);
            } else if (resourcePath.endsWith("js")) {
                this.renderScriptDependency(facesContext, resourcePath);
            } else {
                logger.log(Level.WARNING, "Resource \"{0}\" is queued for inclusion but it's not a supported type, only 'css' and 'js' files can be included.", (Object)resource);
            }
        }
    }
}

