/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.picklist;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.picklist.PickList;
import org.primefaces.model.DualListModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class PickListRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        PickList pickList = (PickList)component;
        String clientId = pickList.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String sourceKey = clientId + "_sourceList";
        String targetKey = clientId + "_targetList";
        if (params.containsKey(sourceKey) && params.containsKey(targetKey)) {
            pickList.setSubmittedValue(new String[]{(String)params.get(sourceKey), (String)params.get(targetKey)});
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        PickList pickList = (PickList)component;
        this.encodeMarkup(facesContext, pickList);
        this.encodeScript(facesContext, pickList);
    }

    private void encodeScript(FacesContext facesContext, PickList pickList) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = pickList.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)pickList);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(widgetVar + " = new PrimeFaces.widget.PickList('" + clientId + "', {});");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, PickList pickList) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = pickList.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)pickList);
        DualListModel model = (DualListModel)pickList.getValue();
        writer.startElement("table", (UIComponent)pickList);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (pickList.getStyle() != null) {
            writer.writeAttribute("style", (Object)pickList.getStyle(), null);
        }
        if (pickList.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)pickList.getStyleClass(), null);
        }
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        writer.startElement("td", null);
        this.encodeList(facesContext, pickList, clientId + "_source", widgetVar, "ui-picklist-source", model.getSource());
        writer.endElement("td");
        writer.startElement("td", null);
        if (pickList.getFacetCount() > 0) {
            this.encodeFacet(facesContext, pickList, widgetVar, "add");
            this.encodeFacet(facesContext, pickList, widgetVar, "addAll");
            this.encodeFacet(facesContext, pickList, widgetVar, "remove");
            this.encodeFacet(facesContext, pickList, widgetVar, "removeAll");
        } else {
            this.encodeDefaultControl(facesContext, pickList, widgetVar, "&gt;", "add");
            this.encodeDefaultControl(facesContext, pickList, widgetVar, "&gt;&gt;", "addAll");
            this.encodeDefaultControl(facesContext, pickList, widgetVar, "&lt;", "remove");
            this.encodeDefaultControl(facesContext, pickList, widgetVar, "&lt;&lt;", "removeAll");
        }
        writer.endElement("td");
        writer.startElement("td", null);
        this.encodeList(facesContext, pickList, clientId + "_target", widgetVar, "ui-picklist-target", model.getTarget());
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    private void encodeDefaultControl(FacesContext facesContext, PickList pickList, String widgetVar, String label, String fn) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-picklist-control", null);
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"push", null);
        writer.writeAttribute("style", (Object)"width:35px;", null);
        writer.writeAttribute("onclick", (Object)(widgetVar + "." + fn + "();return false;"), null);
        writer.write(label);
        writer.endElement("button");
        writer.endElement("div");
    }

    private void encodeFacet(FacesContext facesContext, PickList pickList, String widgetVar, String facet) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent control = pickList.getFacet(facet);
        if (control != null) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-picklist-control", null);
            ComponentUtils.decorateAttribute(control, "onclick", widgetVar + "." + facet + "();return false;");
            this.renderChild(facesContext, control);
            writer.endElement("div");
        }
    }

    private void encodeList(FacesContext facesContext, PickList pickList, String listId, String widgetVar, String styleClass, List model) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String method = styleClass.equals("ui-picklist-source") ? ".add();" : ".remove();";
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)listId, "id");
        writer.writeAttribute("name", (Object)listId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.writeAttribute("ondblclick", (Object)(widgetVar + method), null);
        String state = this.encodeOptions(facesContext, pickList, model);
        writer.endElement("select");
        this.encodeListStateHolder(facesContext, listId + "List", state);
    }

    private String encodeOptions(FacesContext facesContext, PickList pickList, List model) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String var = pickList.getVar();
        Converter converter = pickList.getConverter();
        StringBuffer state = new StringBuffer();
        for (Object item : model) {
            facesContext.getExternalContext().getRequestMap().put(var, item);
            String value = converter != null ? converter.getAsString(facesContext, (UIComponent)pickList, pickList.getItemValue()) : (String)pickList.getItemValue();
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)value, null);
            writer.write(pickList.getItemLabel());
            writer.endElement("option");
            state.append(value);
            state.append(";");
        }
        facesContext.getExternalContext().getRequestMap().remove(var);
        return state.toString();
    }

    private void encodeListStateHolder(FacesContext facesContext, String clientId, String value) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        PickList pickList = (PickList)component;
        String[] value = (String[])submittedValue;
        String[] sourceList = value[0].split(";");
        String[] targetList = value[1].split(";");
        DualListModel model = new DualListModel();
        this.doConvertValue(facesContext, pickList, sourceList, model.getSource());
        this.doConvertValue(facesContext, pickList, targetList, model.getTarget());
        return model;
    }

    private void doConvertValue(FacesContext facesContext, PickList pickList, String[] values, List model) {
        Converter converter = pickList.getConverter();
        for (String value : values) {
            String convertedValue;
            if (this.isValueBlank(value)) continue;
            String val = value.trim();
            String string = convertedValue = converter != null ? converter.getAsObject(facesContext, (UIComponent)pickList, val) : val;
            if (convertedValue == null) continue;
            model.add(convertedValue);
        }
    }
}

