/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inplace;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.inplace.Inplace;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class InplaceRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Inplace inplace = (Inplace)component;
        this.encodeMarkup(facesContext, inplace);
        this.encodeScript(facesContext, inplace);
    }

    private void encodeMarkup(FacesContext facesContext, Inplace inplace) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = inplace.getClientId(facesContext);
        String displayClass = inplace.isDisabled() ? "pf-inplace-display-disabled" : "pf-inplace-display";
        writer.startElement("span", (UIComponent)inplace);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)"pf-inplace", "id");
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_display"), "id");
        writer.writeAttribute("class", (Object)displayClass, null);
        writer.write(this.getLabelToRender(facesContext, inplace));
        writer.endElement("span");
        if (!inplace.isDisabled()) {
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)(clientId + "_content"), "id");
            writer.writeAttribute("class", (Object)"pf-inplace-content", null);
            this.renderChildren(facesContext, (UIComponent)inplace);
            writer.endElement("span");
        }
        writer.endElement("span");
    }

    private String getLabelToRender(FacesContext facesContext, Inplace inplace) {
        if (inplace.getLabel() != null) {
            return inplace.getLabel();
        }
        return ComponentUtils.getStringValueToRender(facesContext, (UIComponent)inplace.getChildren().get(0));
    }

    private void encodeScript(FacesContext facesContext, Inplace inplace) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = inplace.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)inplace);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(var + " = new PrimeFaces.widget.Inplace('" + clientId + "', {");
        writer.write("effect:'" + inplace.getEffect() + "'");
        writer.write(",effectSpeed:'" + inplace.getEffectSpeed() + "'");
        if (inplace.isDisabled()) {
            writer.write(",disabled:true");
        }
        writer.write("});");
        writer.endElement("script");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

