/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.hotkey;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.hotkey.Hotkey;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class HotkeyRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Hotkey hotkey;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey((hotkey = (Hotkey)component).getClientId(facesContext))) {
            hotkey.queueEvent((FacesEvent)new ActionEvent((UIComponent)hotkey));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Hotkey hotkey = (Hotkey)component;
        String clientId = hotkey.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(document).bind('keydown', '" + hotkey.getBind() + "', function(){");
        if (hotkey.getHandler() == null) {
            UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)hotkey);
            if (form == null) {
                throw new FacesException("Hotkey '" + clientId + "' needs to be enclosed in a form when ajax mode is enabled");
            }
            writer.write(this.buildAjaxRequest(facesContext, hotkey, form.getClientId(facesContext), clientId));
        } else {
            writer.write(hotkey.getHandler() + ";");
        }
        writer.write("});");
        writer.endElement("script");
    }
}

