/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.focus;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.focus.Focus;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class FocusRenderer
extends CoreRenderer {
    private static final Map<String, Integer> severityOrdinals = new HashMap<String, Integer>();

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Focus focus = (Focus)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("span", (UIComponent)focus);
        writer.writeAttribute("id", (Object)focus.getClientId(facesContext), "id");
        writer.endElement("span");
        writer.startElement("script", (UIComponent)focus);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        if (focus.getFor() != null) {
            this.encodeExplicitFocus(facesContext, focus);
        } else {
            this.encodeImplicitFocus(facesContext, focus);
        }
        writer.endElement("script");
    }

    protected void encodeExplicitFocus(FacesContext facesContext, Focus focus) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent forComponent = focus.findComponent(focus.getFor());
        if (forComponent == null) {
            throw new FacesException("Cannot find component '" + focus.getFor() + "' in view.");
        }
        String clientId = forComponent.getClientId(facesContext);
        writer.write("jQuery(function(){");
        writer.write("jQuery(PrimeFaces.escapeClientId('" + clientId + "')).focus();");
        writer.write("});");
    }

    protected void encodeImplicitFocus(FacesContext facesContext, Focus focus) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (this.isPostBack()) {
            String clientId = this.findFirstInvalidClientId(facesContext, focus);
            if (clientId != null) {
                writer.write("setTimeout(function() {");
                writer.write("jQuery(PrimeFaces.escapeClientId('" + clientId + "')).focus();");
                writer.write("}, 500);");
            }
        } else {
            writer.write("jQuery(function(){");
            String selector = ":not(:submit):not(:button):input:visible:enabled:first";
            if (focus.getContext() != null) {
                UIComponent context = focus.findComponent(focus.getContext());
                if (context == null) {
                    throw new FacesException("Cannot find component " + focus.getContext() + " in view");
                }
                selector = ComponentUtils.escapeJQueryId(context.getClientId(facesContext)) + " " + selector;
            }
            writer.write("jQuery('" + selector + "').focus();");
            writer.write("});");
        }
    }

    protected String findFirstInvalidClientId(FacesContext facesContext, Focus focus) {
        int minSeverityOrdinal = severityOrdinals.get(focus.getMinSeverity());
        Iterator iterator = facesContext.getClientIdsWithMessages();
        while (iterator.hasNext()) {
            String clientId = (String)iterator.next();
            Iterator messageIter = facesContext.getMessages(clientId);
            while (messageIter.hasNext()) {
                FacesMessage message = (FacesMessage)messageIter.next();
                if (message.getSeverity().getOrdinal() > minSeverityOrdinal) continue;
                return clientId;
            }
        }
        return null;
    }

    static {
        severityOrdinals.put("info", FacesMessage.SEVERITY_INFO.getOrdinal());
        severityOrdinals.put("warn", FacesMessage.SEVERITY_WARN.getOrdinal());
        severityOrdinals.put("error", FacesMessage.SEVERITY_ERROR.getOrdinal());
        severityOrdinals.put("fatal", FacesMessage.SEVERITY_FATAL.getOrdinal());
    }
}

