/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFExporter
extends Exporter {
    @Override
    public void export(FacesContext facesContext, DataTable table, String filename, boolean pageOnly, int[] excludeColumns, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        try {
            Document document = new Document(PageSize.A4.rotate());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            if (preProcessor != null) {
                preProcessor.invoke(facesContext.getELContext(), new Object[]{document});
            }
            PdfPTable pdfTable = this.exportPDFTable(table, pageOnly, excludeColumns, encodingType);
            document.add((Element)pdfTable);
            if (postProcessor != null) {
                postProcessor.invoke(facesContext.getELContext(), new Object[]{document});
            }
            document.close();
            this.writePDFToResponse((HttpServletResponse)facesContext.getExternalContext().getResponse(), baos, filename);
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    private PdfPTable exportPDFTable(UIData table, boolean pageOnly, int[] excludeColumns, String encoding) {
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        int numberOfColumns = columns.size();
        PdfPTable pdfTable = new PdfPTable(numberOfColumns);
        Font font = FontFactory.getFont((String)"Times", (String)encoding);
        Font headerFont = FontFactory.getFont((String)"Times", (String)encoding, (float)12.0f, (int)1);
        int first = pageOnly ? table.getFirst() : 0;
        int size = pageOnly ? first + table.getRows() : table.getRowCount();
        this.addColumnHeaders(pdfTable, columns, headerFont);
        for (int i = first; i < size; ++i) {
            table.setRowIndex(i);
            for (int j = 0; j < numberOfColumns; ++j) {
                UIColumn column = columns.get(j);
                if (!column.isRendered()) continue;
                this.addColumnValue(pdfTable, column.getChildren(), j, font);
            }
        }
        table.setRowIndex(-1);
        return pdfTable;
    }

    private void addColumnHeaders(PdfPTable pdfTable, List<UIColumn> columns, Font font) {
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = columns.get(i);
            if (!column.isRendered()) continue;
            this.addColumnValue(pdfTable, column.getHeader(), i, font);
        }
    }

    private void addColumnValue(PdfPTable pdfTable, UIComponent component, int index, Font font) {
        String value = component == null ? "" : ComponentUtils.getStringValueToRender(FacesContext.getCurrentInstance(), component);
        pdfTable.addCell((Phrase)new Paragraph(value, font));
    }

    private void addColumnValue(PdfPTable pdfTable, List<UIComponent> components, int index, Font font) {
        StringBuffer buffer = new StringBuffer();
        for (UIComponent component : components) {
            String value;
            if (!component.isRendered() || (value = ComponentUtils.getStringValueToRender(FacesContext.getCurrentInstance(), component)) == null) continue;
            buffer.append(value);
        }
        pdfTable.addCell((Phrase)new Paragraph(buffer.toString(), font));
    }

    private void writePDFToResponse(HttpServletResponse response, ByteArrayOutputStream baos, String fileName) throws IOException, DocumentException {
        response.setContentType("application/pdf");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".pdf");
        response.setContentLength(baos.size());
        ServletOutputStream out = response.getOutputStream();
        baos.writeTo((OutputStream)out);
        out.flush();
    }

    public UIComponent findComponentById(FacesContext context, UIComponent root, String id) {
        UIComponent component = null;
        for (int i = 0; i < root.getChildCount() && component == null; ++i) {
            UIComponent child = (UIComponent)root.getChildren().get(i);
            component = this.findComponentById(context, child, id);
        }
        if (root.getId() != null && component == null && root.getId().equals(id)) {
            component = root;
        }
        return component;
    }
}

