/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datalist;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletResponse;
import org.primefaces.component.datalist.DataList;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.util.ComponentUtils;

public class DataListRenderer
extends CoreRenderer
implements PartialRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        DataList list;
        String clientId;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        boolean isAjaxPaging = params.containsKey((clientId = (list = (DataList)component).getClientId()) + "_ajaxPaging");
        if (isAjaxPaging) {
            list.setFirst(Integer.valueOf((String)params.get(clientId + "_first")));
            list.setRows(Integer.valueOf((String)params.get(clientId + "_rows")));
            list.setPage(Integer.valueOf((String)params.get(clientId + "_page")));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        DataList list = (DataList)component;
        this.encodeMarkup(facesContext, list);
        this.encodeScript(facesContext, list);
    }

    protected void encodeMarkup(FacesContext facesContext, DataList list) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = list.getClientId();
        boolean hasPaginator = list.isPaginator();
        String paginatorPosition = list.getPaginatorPosition();
        String styleClass = list.getStyleClass() == null ? "ui-datalist ui-widget" : "ui-datalist ui-widget " + list.getStyleClass();
        writer.startElement("div", (UIComponent)list);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            this.encodePaginatorContainer(facesContext, clientId + "_paginatorTop");
        }
        this.encodeList(facesContext, list, false);
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            this.encodePaginatorContainer(facesContext, clientId + "_paginatorBottom");
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext facesContext, DataList list) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = list.getClientId();
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)list);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(widgetVar + " = new PrimeFaces.widget.DataList('" + clientId + "',{");
        if (list.isPaginator()) {
            UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)list);
            if (form == null) {
                throw new FacesException("DataList : \"" + clientId + "\" must be inside a form element");
            }
            writer.write("url:'" + this.getActionURL(facesContext) + "'");
            writer.write(",formId:'" + form.getClientId() + "'");
            if (list.isEffect()) {
                writer.write(",effect:true");
                writer.write(",effectSpeed:'" + list.getEffectSpeed() + "'");
            }
            writer.write(",paginator:new YAHOO.widget.Paginator({");
            writer.write("rowsPerPage:" + list.getRows());
            writer.write(",totalRecords:" + list.getRowCount());
            writer.write(",initialPage:" + list.getPage());
            if (list.getPageLinks() != 10) {
                writer.write(",pageLinks:" + list.getPageLinks());
            }
            if (list.getPaginatorTemplate() != null) {
                writer.write(",template:'" + list.getPaginatorTemplate() + "'");
            }
            if (list.getRowsPerPageTemplate() != null) {
                writer.write(",rowsPerPageOptions : [" + list.getRowsPerPageTemplate() + "]");
            }
            if (list.getFirstPageLinkLabel() != null) {
                writer.write(",firstPageLinkLabel:'" + list.getFirstPageLinkLabel() + "'");
            }
            if (list.getPreviousPageLinkLabel() != null) {
                writer.write(",previousPageLinkLabel:'" + list.getPreviousPageLinkLabel() + "'");
            }
            if (list.getNextPageLinkLabel() != null) {
                writer.write(",nextPageLinkLabel:'" + list.getNextPageLinkLabel() + "'");
            }
            if (list.getLastPageLinkLabel() != null) {
                writer.write(",lastPageLinkLabel:'" + list.getLastPageLinkLabel() + "'");
            }
            if (list.getCurrentPageReportTemplate() != null) {
                writer.write(",pageReportTemplate:'" + list.getCurrentPageReportTemplate() + "'");
            }
            if (!list.isPaginatorAlwaysVisible()) {
                writer.write(",alwaysVisible:false");
            }
            String paginatorPosition = list.getPaginatorPosition();
            String paginatorContainer = null;
            if (paginatorPosition.equals("both")) {
                paginatorContainer = clientId + "_paginatorTop','" + clientId + "_paginatorBottom";
            } else if (paginatorPosition.equals("top")) {
                paginatorContainer = clientId + "_paginatorTop";
            } else if (paginatorPosition.equals("bottom")) {
                paginatorContainer = clientId + "_paginatorBottom";
            }
            writer.write(",containers:['" + paginatorContainer + "']");
            writer.write("})");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeList(FacesContext facesContext, DataList list, boolean hidden) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = list.getClientId();
        boolean isDefinition = list.isDefinition();
        UIComponent definition = list.getFacet("description");
        String listTag = list.getListTag();
        String listItemTag = isDefinition ? "dt" : "li";
        int first = list.getFirst();
        int rows = list.getRows() == 0 ? list.getRowCount() : list.getRows();
        writer.startElement(listTag, null);
        writer.writeAttribute("id", (Object)(clientId + "_list"), null);
        writer.writeAttribute("class", (Object)"ui-datalist-data ui-widget-content ui-corner-all", null);
        if (list.getItemType() != null) {
            writer.writeAttribute("type", (Object)list.getItemType(), null);
        }
        if (hidden) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        for (int i = first; i < first + rows; ++i) {
            list.setRowIndex(i);
            if (!list.isRowAvailable()) continue;
            writer.startElement(listItemTag, null);
            writer.writeAttribute("class", (Object)"ui-datalist-item", null);
            this.renderChildren(facesContext, (UIComponent)list);
            writer.endElement(listItemTag);
            if (!isDefinition) continue;
            writer.startElement("dd", null);
            definition.encodeAll(facesContext);
            writer.endElement("dd");
        }
        list.setRowIndex(-1);
        writer.endElement(listTag);
    }

    protected void encodePaginatorContainer(FacesContext facesContext, String id) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)id, "id");
        writer.writeAttribute("class", (Object)"ui-paginator ui-widget-header ui-corner-all", null);
        writer.endElement("div");
    }

    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        DataList list = (DataList)component;
        ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("text/xml");
        ResponseWriter writer = facesContext.getResponseWriter();
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"" + response.getCharacterEncoding() + "\"?>");
            writer.write("<partial-response>");
            writer.write("<list>");
            writer.startCDATA();
            this.encodeList(facesContext, list, list.isPaginator() && list.isEffect());
            writer.endCDATA();
            writer.write("</list>");
            writer.write("<state>");
            writer.startCDATA();
            StateManager stateManager = facesContext.getApplication().getStateManager();
            stateManager.writeState(facesContext, stateManager.saveView(facesContext));
            writer.endCDATA();
            writer.write("</state>");
            writer.write("</partial-response>");
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        facesContext.responseComplete();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

