/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datagrid;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletResponse;
import org.primefaces.component.datagrid.DataGrid;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.util.ComponentUtils;

public class DataGridRenderer
extends CoreRenderer
implements PartialRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        DataGrid grid;
        String clientId;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        boolean isAjaxPaging = params.containsKey((clientId = (grid = (DataGrid)component).getClientId()) + "_ajaxPaging");
        if (isAjaxPaging) {
            grid.setFirst(Integer.valueOf((String)params.get(clientId + "_first")));
            grid.setRows(Integer.valueOf((String)params.get(clientId + "_rows")));
            grid.setPage(Integer.valueOf((String)params.get(clientId + "_page")));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        DataGrid grid = (DataGrid)component;
        this.encodeMarkup(facesContext, grid);
        this.encodeScript(facesContext, grid);
    }

    protected void encodeMarkup(FacesContext facesContext, DataGrid grid) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = grid.getClientId();
        boolean hasPaginator = grid.isPaginator();
        String paginatorPosition = grid.getPaginatorPosition();
        String styleClass = grid.getStyleClass() == null ? "ui-datagrid ui-widget" : "ui-datagrid ui-widget " + grid.getStyleClass();
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            this.encodePaginatorContainer(facesContext, clientId + "_paginatorTop");
        }
        this.encodeTable(facesContext, grid, false);
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            this.encodePaginatorContainer(facesContext, clientId + "_paginatorBottom");
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext facesContext, DataGrid grid) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = grid.getClientId();
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)grid);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)grid);
        if (form == null) {
            throw new FacesException("DataGrid : \"" + clientId + "\" must be inside a form element");
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(widgetVar + " = new PrimeFaces.widget.DataGrid('" + clientId + "',{");
        writer.write("url:'" + this.getActionURL(facesContext) + "'");
        writer.write(",formId:'" + form.getClientId() + "'");
        if (grid.isPaginator()) {
            writer.write(",paginator:new YAHOO.widget.Paginator({");
            writer.write("rowsPerPage:" + grid.getRows());
            writer.write(",totalRecords:" + grid.getRowCount());
            writer.write(",initialPage:" + grid.getPage());
            if (grid.getPageLinks() != 10) {
                writer.write(",pageLinks:" + grid.getPageLinks());
            }
            if (grid.getPaginatorTemplate() != null) {
                writer.write(",template:'" + grid.getPaginatorTemplate() + "'");
            }
            if (grid.getRowsPerPageTemplate() != null) {
                writer.write(",rowsPerPageOptions : [" + grid.getRowsPerPageTemplate() + "]");
            }
            if (grid.getFirstPageLinkLabel() != null) {
                writer.write(",firstPageLinkLabel:'" + grid.getFirstPageLinkLabel() + "'");
            }
            if (grid.getPreviousPageLinkLabel() != null) {
                writer.write(",previousPageLinkLabel:'" + grid.getPreviousPageLinkLabel() + "'");
            }
            if (grid.getNextPageLinkLabel() != null) {
                writer.write(",nextPageLinkLabel:'" + grid.getNextPageLinkLabel() + "'");
            }
            if (grid.getLastPageLinkLabel() != null) {
                writer.write(",lastPageLinkLabel:'" + grid.getLastPageLinkLabel() + "'");
            }
            if (grid.getCurrentPageReportTemplate() != null) {
                writer.write(",pageReportTemplate:'" + grid.getCurrentPageReportTemplate() + "'");
            }
            if (!grid.isPaginatorAlwaysVisible()) {
                writer.write(",alwaysVisible:false");
            }
            String paginatorPosition = grid.getPaginatorPosition();
            String paginatorContainer = null;
            if (paginatorPosition.equals("both")) {
                paginatorContainer = clientId + "_paginatorTop','" + clientId + "_paginatorBottom";
            } else if (paginatorPosition.equals("top")) {
                paginatorContainer = clientId + "_paginatorTop";
            } else if (paginatorPosition.equals("bottom")) {
                paginatorContainer = clientId + "_paginatorBottom";
            }
            writer.write(",containers:['" + paginatorContainer + "']");
            writer.write("})");
            if (grid.isEffect()) {
                writer.write(",effect:true");
                writer.write(",effectSpeed:'" + grid.getEffectSpeed() + "'");
            }
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeTable(FacesContext facesContext, DataGrid grid, boolean hidden) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = grid.getClientId();
        int columns = grid.getColumns();
        int rowIndex = grid.getFirst();
        int numberOfRowsToRender = (grid.getRows() != 0 ? grid.getRows() : grid.getRowCount()) / columns;
        writer.startElement("table", (UIComponent)grid);
        writer.writeAttribute("id", (Object)(clientId + "_table"), "id");
        writer.writeAttribute("class", (Object)"ui-datagrid-data", null);
        if (hidden) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        writer.startElement("tbody", null);
        for (int i = 0; i < numberOfRowsToRender; ++i) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-datagrid-row", null);
            for (int j = 0; j < columns; ++j) {
                grid.setRowIndex(rowIndex);
                writer.startElement("td", null);
                writer.writeAttribute("class", (Object)"ui-datagrid-column", null);
                if (grid.isRowAvailable()) {
                    this.renderChildren(facesContext, (UIComponent)grid);
                    ++rowIndex;
                }
                writer.endElement("td");
            }
            writer.endElement("tr");
            if (!grid.isRowAvailable()) break;
        }
        grid.setRowIndex(-1);
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodePaginatorContainer(FacesContext facesContext, String id) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)id, "id");
        writer.writeAttribute("class", (Object)"ui-paginator ui-widget-header ui-corner-all", null);
        writer.endElement("div");
    }

    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        DataGrid grid = (DataGrid)component;
        ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("text/xml");
        ResponseWriter writer = facesContext.getResponseWriter();
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"" + response.getCharacterEncoding() + "\"?>");
            writer.write("<partial-response>");
            writer.write("<table>");
            writer.startCDATA();
            this.encodeTable(facesContext, grid, grid.isPaginator() && grid.isEffect());
            writer.endCDATA();
            writer.write("</table>");
            writer.write("<state>");
            writer.startCDATA();
            StateManager stateManager = facesContext.getApplication().getStateManager();
            stateManager.writeState(facesContext, stateManager.saveView(facesContext));
            writer.endCDATA();
            writer.write("</state>");
            writer.write("</partial-response>");
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        facesContext.responseComplete();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

