/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.colorpicker;

import java.awt.Color;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.colorpicker.ColorPicker;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.resource.ResourceUtils;

public class ColorPickerRenderer
extends CoreRenderer {
    private static final String DEFAULT_PICKER_THUMB = "/yui/colorpicker/assets/picker_thumb.png";
    private static final String DEFAULT_HUE_THUMB = "/yui/colorpicker/assets/hue_thumb.png";

    public void decode(FacesContext facesContext, UIComponent component) {
        ColorPicker colorPicker = (ColorPicker)component;
        String paramName = colorPicker.getClientId(facesContext) + "_input";
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(paramName)) {
            String submittedValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(paramName);
            colorPicker.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ColorPicker colorPicker = (ColorPicker)component;
        this.encodeMarkup(facesContext, colorPicker);
        this.encodeScript(facesContext, colorPicker);
    }

    protected void encodeMarkup(FacesContext facesContext, ColorPicker colorPicker) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = colorPicker.getClientId(facesContext);
        String value = this.getValueAsString(facesContext, colorPicker);
        String buttonId = clientId + "_button";
        String inputId = clientId + "_input";
        this.renderIE6Fix(writer);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)buttonId, null);
        writer.writeAttribute("name", (Object)buttonId, null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.write("<em id=\"" + clientId + "_livePreview\" style=\"overflow:hidden;width:1em;height:1em;display:block;border:solid 1px #000;text-indent:1em;white-space:nowrap;");
        if (value != null) {
            writer.write("background-color:rgb(" + value + ");");
        }
        writer.write("\">Live Preview</em>");
        writer.endElement("button");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.endElement("input");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_dialog"), null);
        if (colorPicker.getHeader() != null) {
            writer.writeAttribute("title", (Object)colorPicker.getHeader(), null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_cpContainer"), null);
        writer.writeAttribute("class", (Object)"yui-picker", null);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("span");
    }

    private void renderIE6Fix(ResponseWriter writer) throws IOException {
        writer.write("<!--[if lt IE 7]>\n");
        writer.startElement("style", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.write("\n* html .yui-picker-bg {\n");
        writer.write("background-image: none;\n");
        writer.write("}\n");
        writer.endElement("style");
        writer.write("<![endif]-->");
    }

    protected void encodeScript(FacesContext facesContext, ColorPicker colorPicker) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = colorPicker.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)colorPicker);
        String value = this.getValueAsString(facesContext, colorPicker);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(widgetVar + " = new PrimeFaces.widget.ColorPicker('" + clientId + "', {");
        writer.write("images: {");
        writer.write("PICKER_THUMB:'" + ResourceUtils.getResourceURL(facesContext, DEFAULT_PICKER_THUMB) + "'");
        writer.write(",HUE_THUMB:'" + ResourceUtils.getResourceURL(facesContext, DEFAULT_HUE_THUMB) + "'");
        writer.write("}");
        if (value != null) {
            writer.write(",initialValue:[" + value + "]");
        }
        if (!colorPicker.isShowControls()) {
            writer.write(",showcontrols: false");
        }
        if (!colorPicker.isShowHexControls()) {
            writer.write(",showhexcontrols: false");
        }
        if (!colorPicker.isShowHexSummary()) {
            writer.write(",showhexsummary: false");
        }
        if (colorPicker.isShowHsvControls()) {
            writer.write(",showhsvcontrols: true");
        }
        if (!colorPicker.isShowRGBControls()) {
            writer.write(",showrgbcontrols: false");
        }
        if (!colorPicker.isShowWebSafe()) {
            writer.write(",showwebsafe: false");
        }
        writer.write("});");
        writer.endElement("script");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        try {
            String submittedValue = (String)value;
            if (this.isValueBlank(submittedValue)) {
                return null;
            }
            ColorPicker colorPicker = (ColorPicker)component;
            if (colorPicker.getConverter() != null) {
                return colorPicker.getConverter().getAsObject(context, (UIComponent)colorPicker, submittedValue);
            }
            String[] rgb = submittedValue.split(",");
            return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    protected String getValueAsString(FacesContext facesContext, ColorPicker colorPicker) {
        Object value = colorPicker.getValue();
        if (value == null) {
            return null;
        }
        if (colorPicker.getConverter() != null) {
            return colorPicker.getConverter().getAsString(facesContext, (UIComponent)colorPicker, value);
        }
        Color color = (Color)value;
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }
}

